##########################################################################
#
#
# Little girl in the big world. An Interactive Fiction story file.
# Designed to be compiled and run with StoryFactory.
#
# Written and declared public domain by Peter Wendrich 2003.
#
#
##########################################################################
#
# The Attic (spooky...)
#
##########################################################################

object objectAttic {
  location: objectWorld
  run {
    /dup &look /eqif
      the attic ^ ^
      /self _look_child
      /drop /tret
    /then
    /dup &name /eqif the attic /drop /tret /then
    /drop /fret
  }
}

object objectMirror {
  name: mirror
  location: objectAttic
  run {
    /dup &look /eqif
      there is a mirror here .
    /then
    /dup &lookin /eqif
      isActorAlice /if
        `` I can see myself '', says Alice .
        /drop /tret
      /then
      isActorPlayer /if
        I see a white rabbit .
        /drop /tret
      /then
    /then
    /dup &name /eqif the mirror /drop /tret /then
    /drop /fret
  }
}

object objectOpenChest {
  name: old wooden chest
  location: objectVoid
  run {
    /dup &close /eqif
      &objectVoid /self [+1] /store
      &objectAttic &objectClosedChest [+1] /store
      done .
      /drop /tret
    /then
    /dup &examine /eqif
      /self holdingObject /if
        an opened old wooden chest which contains : /self _look_child
      /else
        an old wooden chest which is empty .
      /then
      /drop /tret
    /then
    /dup &look /eqif
      an opened old wooden chest stands on the ground .
      /drop /tret
    /then
    /dup &name /eqif the old wooden chest /drop /tret /then
    /dup &lookin /eqif
      /self holdingObject /if
        it contains : /self _look_child
      /else
        it is empty .
      /then
      /drop /tret
    /then
    /dup &open /eqif
      it is already open .
      /drop /tret
    /then
    /drop /fret
  }
}

object objectClosedChest {
  name: old wooden chest
  location: objectAttic
  run {
    /dup &close /eqif
      it is already closed .
    /then
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &get /eqif
      way too heavy to lift .
    /then
    /dup &look /eqif
      an old wooden chest stands on the ground .
    /then
    /dup &name /eqif the old wooden chest /drop /tret /then
    /dup &open /eqif
      isActorAlice /if
        &objectAlice holdingObject &objectKey /eqif
          &objectVoid /self [+1] /store
          &objectAttic &objectOpenChest [+1] /store
          done .
        /else
          `` sorry , I don't have the key '', says Alice .
        /then
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

object objectDolls {
  name: some small dolls
  location: objectOpenChest
  sub lookMyDolls {
    /get $goalAliceFindsDolls /nif
      `` look these are my missing dolls for my dollhouse '', says Alice with a big smile .
      /1 /to $goalAliceFindsDolls
      entertainmentScore ^
      /tret
    /then
    /fret
  }
  run {
    /dup &examine /eqif
      lookMyDolls /nif
        some small dolls in prestine condition although a little dusty .
      /then
      /drop /tret
    /then
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        lookMyDolls /drop
        /get $actor /self [+1] /store
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif
      some small dolls .
      /drop /tret
    /then
    /dup &name /eqif the dolls /drop /tret /then
    /dup &tell /eqif
      isActorAlice /if
        `` I didn't know where my dolls were , but now I have found them again . I can play with them in my dollhouse . '', says Alice .
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

