;******************************************************************************
;*          Module:  WORKSHOP.ELV            Version: 1.??                    *
;*          Last Updated:  Dec. 12, 87       By:  Bruce MacKay                *
;*                         Nov. 27, 87            Marlene (diary pages        *
;******************************************************************************


(actor me
   (noun me myself self elf elves)
   (property
      initial-location MIRRORROOM
      $LDESC "[SANTA'S SMARTEST ELF]"
      $SDESC "Santa's smartest elf"
      $EDESC "From where you're standing you can't see the elf's face.\n"
      $capacity 1500
      $weight 30000
      $open? t
      $invisible? t))
;**************************************************************************
(action demon-check
   (code
       (if (and coldcooler? (= (parent thermometer) cooler))
           (send snow-fuse add)
           (send snow-fuse remove))
       (if (and SPOLE (not(= (parent parka) me)))
           (send frigid-fuse add)
           (send frigid-fuse remove))
       (if (= curloc DROWN) 
           (progn (print "Now that you are older and much wiser, would you like
                          to restart or restore a previously saved game? (Y/N)")
                  (if (yes-or-no)
                  (progn(print "\n\nPress 'Y' to RESTORE or 'N' to RESTART.\n")
                       (if (yes-or-no)
                           (restore)
                           (restart)))
                  (progn(print "\nThankyou for playing elves.\n")
                        (print "Hit <RETURN> to exit.")
                        (if (yes-or-no)
                           (exit)
                           (exit))))))))

;**************************************************************************
(location NOWHERE)

(basic-thing brokenbrasskey
   (noun key)
   (adjective broken brass)
   (property
      $EDESC "The key is broken./n"
      $LDESC "There is a broken brass key here."
      $SDESC "broken brass key"
      initial-location NOWHERE
      $weight 2))

(action aggression
    (verb attack kill hit kick slap punch steal rob grab fart fuck shit burp)
    (direct-object optional)
    (preposition with)
    (indirect-object optional)
    (code
       (print "Such behaviour would be most unbecoming of a Christmas elf.\n")
       (abort)))

(action help
   (verb help)
   (direct-object optional)
   (code 
       (print "That's right.  You're here to help Santa.  What a smart 
               elf!\n")))

(basic-thing stuff
    (noun apple peach plum pear grapefruit pineapple canteloupe
          shirt pants shoes hat scarf socks snowshoes skis toboggan
          eyes ears nose mouth face hair arm hand arms feet legs hands leg
          foot head telephone television tv couch tree floor ceiling pudding
          cookies milk unicorn unicorns dragons dragon)
     (adjective smart dumb blue green red orange yellow black white purple
                big little large small tiny huge Christmas )
     (property
        initial-location NOWHERE))
;**************************************************************************
(location MIRRORROOM
   (noun room)
   (property
      $LDESC " So this is what happens when Santa calls you out of retirement.
You had wondered what it felt like to be subjected to Baron Justus Von Liebig's
teleportation methods.  Well, now you have experienced it first hand. You
remember when you were very young and the wisest oldest elf was summoned.
The mirror in the Great Christmas Hall is still cracked to this date.  Never
had such an emergency required such drastic measures.\n\n

Tonight history repeats itself.  You are now the eldest elf and have been
magically summoned out of retirement.  The burden of responsibility rests
heavily on YOUR shoulders.  Christmas has gone amuck and you must call on your
years of wisdom and the recollections of your youth to set it right.\n\n

You are in an octagonal room filled with hundreds of elves.
Each of the elves is identical and all seem to move in unison.  You stare at
the elf directly in front of you.  He stares back.\n\n 
You feel an itching in your nose which builds and builds until.....  ACHHOOO!
\nThe entire room of elves sneezes simultaneously."
      $SDESC "The octagonal room."
      $EDESC "There is barely enough room to turn around here.  If there was
              anything to find here you'd surely be standing on it!\n "
      $lit? t
      west BUNKHOUSE))

(mirror mirrorroommirror
      (noun walls wall mirrors mirror)
      (property
          initial-location MIRRORROOM))

(action enter-mirror-err
    (verb enter)
    (code
        (print "Enter what?\n")))

(action v-enter-mirror
   (verb enter)
   (direct-object REQUIRED)
   (code (setq %dobject (CanSee $dobject))
         (if Snowing? (progn (print "Nothing happens.\n")
                             (abort)))
         (if (= bunkhousemirror %dobject)
            (progn(setq was_move? T)
                  (if SPole (setq SPole nil)(setq SPole T))
                  (print "You are temporarily stunned by a flash of blinding
                          light.\n")
                  (if SPole (progn
                               (print "The hair at the back of your neck stands
                                       straight up on end.\n")
                               (setq floor(* 2 floor))
                               (putin SNOWMAN FLOE2)
                               (update-inv (Child me))
                               (SOUTHPOLE))
                               (progn
                                   (if FrostyBuilt? 
                                       (putin SNOWMAN FLOE14)
                                       (putin SNOWMAN NOWHERE))
                                   (setq floor (/ floor 2))
                                   (update-inv (Child me))
                                   (NORTHPOLE))))
         (print "You can't enter that!\n"))))

(rtn-fuse frigid-fuse
   (property
      name "frigid-fuse"
      delay 4)
   (method (bang)
     (print "You are not properly dressed for such a cold climate.  Your little
             body, being exposed to the elements, quickly becomes frozen stiff
             like a big green popsicle.  You blew it!  What a let down!  All
             those kiddies are going to miss Christmas just because you were
             too dumb to put on your parka before wandering around out in the
             cold.  Let this be a lesson to you.  Don't go outside without
             your parka and don't stand around in the rain.  Look both ways
             before you cross the street and never cross between parked cars.\n\n
             Now that you are older and much wiser, would you like to restart
             or restore a previously saved game? (Y/N)")
     (if (yes-or-no)
         (progn(print "\n\nPress 'Y' to RESTORE or 'N' to RESTART.\n")
               (if (yes-or-no)
                   (restore)
                   (restart)))
         (progn(print "\nThankyou for playing elves.\n")
               (print "Hit <RETURN> to exit.")
               (if (yes-or-no)
                   (exit) 
                   (exit))))))
;**************************************************************************
(location BUNKHOUSE
   (noun room bunkhouse))

(mirror bunkhousemirror
   (property
       initial-location BUNKHOUSE))

(basic-thing bureau
   (noun bureau dresser)
   (adjective oak)
   (property
      initial-location BUNKHOUSE
      $EDESC "The bureau is made of oak and stands about 3 feet tall.  There
             are 3 drawers each stacked one above the other.  There is a large
             mirror directly over the bureau.\n"
      $LDESC "[BUREAU]"
      $SDESC "bureau"
      $invisible? t
      $weight 30000))

(integral-part drawer1
   (noun drawer)
   (adjective top oak)
   (property
      $EDESC "The top drawer is the one above the middle one.\n"
      $LDESC "[TOP DRAWER]"
      $SDESC "top drawer"
      initial-location BUNKHOUSE
      $parent bureau
      $opens? t
      $open? nil
      $locks? t
      $locked? nil
      $key brasskey
      $capacity 200
      $invisible? t))


(basic-thing flashlight
   (noun lamp lantern)
   (adjective brass)
   (method (light)
      (print "The lantern is now on.\n")
      (setp flashlight $lit? t)
      (send flashlight-fuse add)
      (abort))
   (method (extinguish)
      (print "The lantern is now turned off.\n")
      (setp flashlight $lit? nil)
      (send flashlight-fuse remove)
      (abort))
   (property
      $LDESC "There is a brass lantern here."
      $SDESC "lantern"
      $EDESC "It's a finely crafted brass lantern of obvious elfen design.\n"
      initial-location drawer1
      $weight 15
      $opens? nil
      $lit? nil))

(rtn-fuse flashlight-fuse
   (property
      name "flashlight-fuse"
      delay 50)
   (method (bang)
      (if (and (IsInRec? flashlight me)(getp flashlight $lit?)
         (print "Your nifty lantern flickers then goes out.\n"))
      (setp flashlight $lit? nil)
      (abort))))

(integral-part drawer2
   (noun drawer)
   (adjective middle oak)
   (method (unlock)
      (putin brasskey NOWHERE)
      (putin brokenbrasskey me)
      (print "The brass key slid in easily, but snapped off in the lock as you
               tried to turn it.\n")
      (abort))
    (property
      $EDESC "The middle drawer is the one under the top drawer and above
              the one underneath.\n"
      $LDESC "[MIDDLE DRAWER]"
      $SDESC "middle drawer"
      initial-location BUNKHOUSE
      $parent bureau
      $opens? t
      $open? nil
      $locks? t
      $locked? t
      $key brasskey
      $capacity 200
      $invisible? t))

(integral-part drawer3
   (noun drawer)
   (adjective bottom)
   (property
      $EDESC "The drawer at the bottom is closest to the floor and below the
              middle one.\n"
      $LDESC "BOTTOM DRAWER"
      $SDESC "bottom drawer"
      initial-location BUNKHOUSE
      $parent bureau
      $opens? t
      $open? nil
      $locks? t
      $locked? t
      $key brasskey
      $capacity 200
      $invisible? t))

(basic-thing redlongjohns
   (noun longjohns underwear)
   (adjective red santa's)
   (property 
       $LDESC "There is a pair of red longjohns here."
       $SDESC "pair of red longjohns"
       $EDESC "Well, they're long and red and you're short and dumpy.\n"
       initial-location drawer3
       $weight 5))

      
;*****************************************************************************
(location CLOSET
   (noun room closet hall walls cellar)
   (adjective root)
   (property
      $lit? nil))

(portal ClosetDoor1
   (noun door)
   (property
      $EDESC "Yup! It's a closet door all right!\n"
      $LDESC "[THE CLOSET DOOR]"
      $SDESC "the closet door"
      $otherside CLOSET
      $Pair ClosetDoor2
      initial-location BUNKHOUSE))

(portal ClosetDoor2
   (noun door)
   (property
      $EDESC "Yup! It's a closet door all right!\n"
      $LDESC "[THE CLOSET DOOR]"
      $SDESC "the closet door"
      $otherside BUNKHOUSE
      $Pair ClosetDoor1
      initial-location CLOSET))

(basic-thing parka
   (noun parka jacket coat)
   (adjective nice heavy)
   (property
      $LDESC "Your nice heavy parka is here."
      $SDESC "nice heavy parka"
      $EDESC "The parka looks very warm.  It's stuffed with the finest eider 
              down.  It has a very heavy zipper with a large pocket on either
              side.  You can't be sure, but you suspect there is no pocket
              lint in either pocket.\n"
      initial-location CLOSET
      $open? t
      $capacity 400
      $weight 500))

(integral-part rightpocket
   (noun pocket)
   (adjective right)
   (property
      $EDESC "Pockets are funny.  It's hard to tell whether they're left or
              right.  If it's your jacket and you're wearing it, this would
              be the right pocket.  If it was someone else's jacket and they
              were wearing it while you were examining it, well not only would
              it be the left pocket but you'd probably get your face slapped.
              \n"
      $LDESC "[RIGHT COAT POCKET]"
      $SDESC "right coat pocket"
      initial-location parka
      $parent parka
      $opens? t
      $open? nil
      $capacity 200
      $weight 201
      $invisible? t))

(basic-thing brasskey
   (noun key)
   (adjective brass)
   (property
      $EDESC "It's made of brass.\n"
      $LDESC "There is a brass key here."
      $SDESC "brass key"
      initial-location rightpocket
      $weight 2))

(integral-part leftpocket
   (noun pocket)
   (adjective left)
   (property
      $EDESC "Pockets are funny.  It's hard to tell whether they're left or
              right.  If it's your jacket and you're wearing it, this would
              be the left pocket.  If it was someone else's jacket and they
              were wearing it while you were examining it, well not only would
              it be the right pocket but you'd probably get your face slapped.
              \n"
      $LDESC "[LEFT COAT POCKET]"
      $SDESC "left coat pocket"
      initial-location parka
      $parent parka
      $opens? t
      $open? nil
      $capacity 100
      $weight 101
      $invisible? t))

(basic-thing goldkey
   (noun key)
   (adjective gold)
   (property
      $EDESC "It's one of those old fashioned keys that looks sort of like a
              'K'.  It is made of the finest gold and has the initials S.C.
              engraved delicately on one side.\n"
      $LDESC "There is a gold key here."
      $SDESC "gold key"
      initial-location leftpocket
      $weight 2))

(basic-thing mittens
   (noun mittens mitts)
   (adjective idiot green)
   (method (untie)
        (putin leftmitten me)
        (putin rightmitten me)
        (putin mittenstring me)
        (putin mittens NOWHERE)
        (print "After considerable fumbling, you manage to separate the two
                mittens from the connecting string.\n")
        (abort))
   (method (tie %iobject)
        (if (= %iobject mittenstring)
            (progn (print "You're ancient Granny who knit them for you must 
                    have had more nimble fingers than you.  You can't get the
                    string tied back to the mittens no matter how hard you
                    try.\n")
             (abort))))
   (property
       $LDESC "There is a nice warm pair of mittens here."
       $SDESC "pair of idiot mittens"
       $EDESC "They're idiot mittens.  Looks like they were made just 
               for you!  They are beautiful green mittens with a long
               green string which holds them together.\n"
       initial-location DRAWER3
       $open?  T
       $weight 12
       $capacity 5))

(mittens leftmitten
   (noun mitt mitten)
   (adjective left idiot green)
   (property
        $LDESC "There is a left mitten here."
        $SDESC "left mitten"
        $EDESC "Looks like a left green mitten.\n"
        initial-location NOWHERE
        $weight 5
        $capacity 4))

(mittens rightmitten
   (noun mitt mitten)
   (adjective right idiot green)
   (property
        $LDESC "There is a right mitten here."
        $SDESC "right mitten"
        $EDESC "Looks like a right green mitten.\n"
        initial-location NOWHERE
        $weight 5
        $capacity 4))

(basic-thing mittenstring
   (noun string)
   (adjective green)
   (method (untie)
        (putin leftmitten me)
        (putin rightmitten me)
        (putin mittenstring me)
        (putin mittens NOWHERE)
        (print "After considerable fumbling, you manage to separate the two
                mittens from the connecting string.\n")
        (abort))
   (method (tie %iobject)
        (if (= %iobject mittenstring)
            (progn (print "You're ancient Granny who knit them for you must 
                    have had more nimble fingers than you.  You can't get the
                    string tied back to the mittens no matter how hard you
                    try.\n")
             (abort))))
   (property
       $LDESC "There is a green string here."
       $SDESC "green string"
       $EDESC "It's a green string about 1 metre long of the kind that's
               commonly used to hold idiot mittens together.  Ahh, those
               great old idiot mittens.  You know the kind... where you
               run up to one of the other elves who has a pair on and you
               grab his left mitt and he slaps himself in the head with his
               right hand!\n"
       $weight 2
       initial-location NOWHERE))

(basic-thing bunkbed
    (noun bed beds bunkbed bunkbeds)
    (adjective bunk)
    (property
       $LDESC "BUNKBEDS"
       $SDESC "bunkbeds"
       $EDESC "These bunks seem unusually short.  Each and every one has been
               very neatly made up.  This obviously is not a summer camp.\n"
       $weight 30000
       $invisible? T
       initial-location BUNKHOUSE))

;*****************************************************************************
(location WORKSHOP
   (noun room workshop shop cave passage tools bench benches board hook hooks
    clutter nails paint screws can cans brush brushes blueprints plans)
   (adjective peg work))
 
(basic-thing toys
   (noun toy toys sleds toboggans skates skis dolls trains car cars track
    Alf horses bicycles)
   (adjective electric racing stuffed rocking)
   (property
      $LDESC "There are toys here.  Enough for all the good boys and girls."
      $SDESC "whole lot of toys"
      $EDESC "This is what Santa's part of Christmas is all about...TOYS!  
              There are so many, that it's hard to begin to describe what you
              see.  The first thing you notice is that there seems be a lot
              more than when you were around.  The world's population must have
              doubled in the few short years of your retirement.  The sleds and
              toboggans have the 'New and Improved' look.  There's not much
              change in the design and style of the skates and skis, just better
              materials to work with.  Now the dolls are a different story.  
              You see your standard 'cry-and-wet' doll, rag dolls, the so-called
              fashion doll and the new 'vegetable-patch' doll.  The biggest
              change in the dolls is the talking dolls.  Computer chips are
              a miracle-come-true.  These dolls have real voices...nothing
              tinny about the quality of the sound.  From the number of them
              here, you would guess that at least 4 out of 5 good girls are
              going to find one of these little gems under their Christmas
              Tree tomorrow morning.  Over in the corner you spy the electric
              trains.  Santa and his 'toy architects' have left this design
              alone.  They look the same and operate the same.  The next thing
              you oogle over are the racing cars sets.  The cars are sleek and
              fast!  Not to mention the slick surface of the track.  Too bad
              you have a mission.  You'd love to sit and pretend you're A. J.
              Foyt.  The little ones will be pleased that Santa's elves have
              made up the lastest stuffed toys.  Alf seems to be the most
              popular.  You really don't have much time to look at all the
              toys.  You have a mission, remember?  One last quick scan of the
              room, just to make sure that the usually rocking horses and
              bicycles are present and accounted for.\n"
      initial-location WORKSHOP
      $invisible? t
      $weight 1000
      $onfloor? 1))
 
;*****************************************************************************
(location GIFTWRAP
   (noun room cave))

(basic-thing table
   (noun table)
   (property
      $LDESC "LDESC of table"
      $SDESC "SDESC of table"
      $EDESC "It's a wonder this table isn't swayed in the middle under the
              burden of all the tape and wrapping paper.  The rolls of tape
              are approximately 6 feet in diameter and weigh about 900 kg each.
              The paper is abundant in a seemingly unlimited supply although
              it is not altogether clear exactly where it is coming from.
              Magically, each piece of paper changes to suit the gift and there
              always seems to be plenty left over for the next year.  In the
              centre of the table are piles of labels, cards and ribbon.  Also
              in the centre are an assortment of decorative bows, poinsettias,
              cranberries and holly set to adorn each gift.\n"
      initial-location giftwrap
      $invisible? T
      $weight 30000))

(integral-part paper
    (noun tape paper holly bows cranberries piles ribbon ribbons)
    (adjective wrapping)
    (property
       initial-location giftwrap
       $LDESC "long description of junk  "
       $SDESC "short description of junk"
       $invisible? T
       $EDESC "Obviously giftwrap is not your department.  You've hopelessly
               tangled the paper with all the tape, bows, cranberries and the holly.
               You had better quit before you accidentally
               tape your thumbs together.\n"))

(basic-thing plasticflowers
    (noun poinsettias flowers leaf flower leaves)
    (adjective plastic)
    (property
        initial-location giftwrap
        $invisible? T
        $weight 20
        $LDESC "There are some tacky plastic poinsettias here."
        $SDESC "bunch of tacky plastic poinsettias"
        $EDESC "These are the tackiest plastic poinsettias you have ever
                seen.  There is something written on the underside of
                one of the leaves. (probably watering instructions)\n"
        $RDESC "The inscription on the leaf reads 'Made in Taiwan'.\n"))

(basic-thing cards
    (noun cards labels)
    (adjective christmas)
    (property
         initial-location giftwrap
         $LDESC "There are some Christmas cards and labels here."
         $SDESC "Christmas cards"
         $EDESC "There is something written on the them.\n"
         $RDESC "Santa is no dumb bunny.  He had all the them pre-printed 'From
                 Santa'.\n"
         $weight 8
         $invisible? T))
;*****************************************************************************
(location OFFICE
   (noun room office path paths drift drifts snowdrift snowdrifts)
   (adjective private))

(basic-thing filecabinet
   (noun cabinet cabinets)
   (adjective filing file)
   (property
       $LDESC "LDESC of file cabinet"
       $SDESC "filing cabinet"
       $EDESC "The filing cabinet is dark grey with a small metal label on the
               top drawer which reads 'N. Pole Safe and Security Co., 1937'.\n"
       $locks? T
       $locked? T
       $opens? T
       $open? nil
       initial-location office
       $weight 30000
       $invisible? T))

(basic-thing chair
   (noun chair)
   (adjective cushy)
   (property
       $LDESC "LDESC of chair"
       $SDESC "cushy chair"
       $EDESC "It's one of those cushy swivel chairs.  Sitting in it would
               be hazardous to the completion of your task.  It looks far too
               comfortable.\n"
       initial-location office
       $invisible? T
       $weight 10000))
  
(basic-thing desk
   (noun desk drawer)
   (adjective Santa's oak)
   (property
       $EDESC "It is made of beautiful white oak inlaid with gold
               leaf.  There is a drawer with an ornate gold lock in the
               centre of the desk.\n"
       $SDESC "desk"
       $LDESC "LDESC of desk"
       $open? nil
       $opens? T
       $locks? T
       $locked? T
       $key GOLDKEY
       initial-location OFFICE
       $weight 30000
       $capacity 50
       $invisible? t))

(basic-thing DIARY
   (noun diary book)
   (method (read)
       (setq val (rand 9))
       (cond
         ((= val 0)
          (setp diary $RDESC "
The book opens to a page......\n
                                     December 12, 1873\n
    Dear Diary:\n
    I have been wondering for such a long time how \n
    our dear old boss shrinks before he pops down\n
    the chimney.  I think I have figured it out.  A\n
    few hours ago, I was working in the giftwrap room\n
    and I heard a strange hissing sound coming from\n
    from Santa's office.  It continued for 23 seconds.\n
    After a bit I heard a swooshing sound, not unlike\n
    a tire being filled with air.  I had to peek around\n
    the corner.  There he was practicing the art of\n
    shrinking and growing.  He had his finger pressed\n
    tight to the side of his nose.  It looks like he\n
    exhales every bit of air in his body to shrink\n
    and then sucks in as much as he can take (and then\n
    some!!) to grow!\n
                                     Egbert\n\n"))
  
          ((= val 1)
           (setp diary $RDESC "
The book falls opens to a page......\n
                                     May 29, 1887\n
    Dear Diary:\n
    Today a new little reindeer was born.  He has \n
    the most unusual nose.  It is rather large and\n
    bulbous.....and that's being polite!  Santa was\n
    a bit upset with us for laughing at the 'ugly\n
    duckling'.  He said that this has a very special\n
    meaning.  It seems that Santa's grandfather had\n
    told him a story about a very special reindeer,\n
    Rudolph, whose nose would glow a brilliant red,\n
    as bright as any poinsettia could be.  Santa's\n
    grandfather told him that he had used this reindeer\n
    to guide his sleigh on dark, foggy nights.  In fact\n
    they wrote a song about him.  Well, we now have\n
    Rudolph II among us.  It remains to be seen if the\n
    fable holds any truth.\n
                                     Egbert\n\n"))

         ((= val 2)
          (setp diary $RDESC "
The book opens to a stained page......\n
                                    December 24, 1873\n
    Dear Diary:\n
    Well, it looks like the fable of Rudolph's nose is\n
    true.  It does glow on its' own, but at times he\n
    needs some help.  I have learned of a recipe, from\n
    a very reliable source, that will intensify the brightness,\n
    to the point that you can't even look at it. You must find\n
    a poinsettia leaf and puree it.  After doing this,\n
    make haste and collect the first snowflake of this\n
    Christmas Eve and mix it with the juice.  Do this just\n
    before you give it to him.  Use this recipe with caution\n
    because it may cause some harm to the refractile index of\n
    the nasal tissues.  It is recommended that this be used only\n
    in an EXTREME EMERGENCY!!\n
                                     Egbert\n\n"))

         ((= val 3)
          (setp diary $RDESC "
The book falls open to a page......\n
                                    December 3, 1899\n
    Dear Diary:\n
    As I get older and wiser I learn more and more of\n
    the secrets of the North Pole.  Today, I discovered\n
    how Santa fits all those toys into one bag.  When\n
    I think about it, it makes complete sense.  Santa's\n
    bag is a magic sack.  The opening of the bag is just\n
    the entrance into a void.....another dimension, so to\n
    to speak.  The gifts are molecularized and transformed\n
    into energy as they pass through the opening.  The cord\n
    around the top of the sack is a very special item.  It \n
    records every molecule of every item and its' position\n
    so that when Santa pulls the gift out of the sack, it\n
    is transformed back into matter, with every molecule in\n
    its' rightful position.\n
    
                                     Egbert\n\n"))

         ((= val 4)
          (setp diary $RDESC "
The book shows you a page......\n
                                    December 15, 1901\n
    Dear Diary:\n
    Well, today the ultimate question was answered....\n
    'How does Santa visit all the houses in the world in\n
    one night?'.....  You see, Santa lives in a much higher\n
    energy sphere than us.  He is a spirit who lives in another\n
    dimension.  He transcends time.  He is accelerated.  Our\n
    time passes very slowly for him.  For instance, he can\n
    paint 1000 toy trains to our one!  One second to him is\n
    like 10 hours to us.  So with all these things taken\n
    into consideration, he can travel around the world in one\n
    night!\n	
    
    
    
    
                                     Egbert\n\n"))

         ((= val 5)
          (setp diary $RDESC "
The book flips open to a page......\n
                                     December 24, 1871\n
    Dear Diary:\n
    This Christmas Eve will probably go down in history\n
    as the most perfect Christmas Eve ever known to \n
    mankind. The snowfall is absolutely gorgeous.\n
    Large fluffy flakes are fluttering downward and \n
    landing softly on all the objects below.  The\n
    whole world seems to sparkle and glitter with tiny\n
    lights as the moonlight dances across the landscape.\n
    I couldn't resist taking a short break and going\n
    outside for a walk.  By the time I got back to the\n
    Workshop, I looked like Frosty the Snowman!  \n
    
    
    
    
                                     Egbert\n\n"))
  
         ((= val 6)  
          (setp diary $RDESC "
The book quivers and falls open.....\n
                                     February 1, 1901\n
    Dear Diary:\n
    Well, our month of rest is over.  Time to get back\n
    to work.  Santa has reassured us that he will find \n
    more elves to give us a hand this year.  There are\n
    so many more children this year than last, not to\n
    mention the new fangled ideas for the toys.  Too\n
    bad Santa can't get those inventors to work with us.\n
    If only they knew how difficult it is to actually\n
    produce a reliable, safe model of their ideas!\n
    So what, you say.....well, try to tell the children\n
    that.  They all wish for the newest and first of\n
    everything.  Oh well, if they can't be made happy\n
    at Christmas then what's the point of having it at\n
    all.  Breaktime is over.  I have to get back to work.\n
    
                                     Egbert\n\n"))
  
         ((= val 7)  
          (setp diary $RDESC "
The book finds a page......\n
                                     October 5, 1871\n
    Dear Diary:\n
    You'll never guess what Santa told me today.  I\n
    must be special.  He told me about the Penquin Colony\n
    in the Antarctic.  I'm not supposed to reveal any \n
    details; but, I can tell you that I wouldn't go there\n
    without having a map!  Diary, there are some very\n
    interesting things hidden in the Colony.  I'd better\n
    stop writing before I spill the beans.\n
    
    
    
    
    
    
    
                                     Egbert\n\n"))
  
         ((= val 8)  
          (setp diary $RDESC "
The book opens to a page......\n
                                     December 1, 1889\n
    Dear Diary:\n
    Have you ever heard of Baron Justus Von Liebig's\n
    teleportation discovery?  I just learned about it\n
    today.  It's very slick.  All you have to do is\n
    enter a mirror.  Actually, it's not as simple as\n
    that.  There is some criteria that has to be met.\n
    First of all you have to be the oldest and wisest\n
    elf on the earth.  Secondly, you must be retired.\n
    Third, an emergency which threatens Christmas must\n
    arise and last of all, Santa has to initiate the\n
    mirrors.  The oldest, wisest elf is then summoned\n
    to the north pole to help Santa in his hour of need.\n
    The mirrors can be used by the elf to travel from \n
    place to place.\n
    
                                     Egbert\n\n"))))


   (property
       $LDESC "There is a diary here."
       $SDESC "diary"
       $EDESC "The diary is ancient.  The leather is dry and cracked and
               the paper is yellow and very brittle.  Your heart warms as you
               recognize the handwriting of Egbert the awesomely bright elf.
               Ah!, old Egbert.  Many was the night that you sat by his fire
               as a youth listening to the tales of the wisdom of the ancient
               Christmas elves.  Herein lies the secret to many Christmas
               mysteries:
               How does Santa travel the entire globe in one night?  What makes
               Ruldoph's nose light up?  How does Santa manage to squeeze down
               those narrow chimneys?
               As you stand there looking at the book, it seems to quiver and
               and give off a faint glow.  The glow reaches out from the book
               and envelopes your entire body.\n"
       $weight 50
       initial-location desk))
  


(action Frosty-steals
   (code
       (if (and (= (Parent Snowman) curloc)(= (Parent diary) me))
           (if Spole (progn (print "Percival stole the diary.\n")
                            (putin diary Snowman))))))

(basic-thing mail
   (noun mail)
   (property
       $LDESC "There is a pile of mail here."
       $SDESC "pile of mail"
       $EDESC "The mail looks more like a man-made mountain.\n"
       $RDESC "Every envelope is addressed to Santa Claus.  Have you forgotten
               the oath you took to be a goodie two shoes?  It's a federal
               offence to open other people's mail.\n"
       initial-location office
       $weight 500))

(basic-thing AtariST
   (noun ST computer display keyboard screen monitor report)
   (adjective Atari Santa's)
   (property
       $EDESC "This is one of those new 40 meg ST's with the latest in laser
               storage devices.  The monitor actually looks more like a
               hologram.  There is a 3D view of the world with many lines
               running from city to city.  It sort of looks like an Air Canada
               travel brochure, only all flights originate from the north
               pole.  You sit there staring for a few seconds when
               the display dissolves and an Environment Canada report
               begins to scroll across the screen.\n"
       $SDESC "n Atari ST"
       $LDESC "LDESC of ST"
       $RDESC "Here is the synopsis from Environment Canada...\n\n
               A low pressure zone continues to lie over the northern polar
               regions.  The warming trend should continue until Boxing Day.
               Dense fog and heavy cloud will prevail.  Visibility is 3-4
               metres.  A Traveller's Advisory remains in affect for most
               regions.\n"
       initial-location OFFICE
       $invisible? t
       $weight 30000))

;****************************************************************************
(location SOAPSTONE
     (noun path paths drift drifts snowdrift snowdrifts))
;****************************************************************************
(location GARAGE
   (noun room garage end)
   (adjective dead))

(basic-thing cooler
    (noun cooler box)
    (adjective styrofoam white)
    (method (open)
       (send cooler-fuse add))
    (property
       $SDESC "styrofoam cooler"
       $LDESC "There is a square white box here."
       $EDESC "It's one of those cheap styrofoam coolers you buy at the
               department stores for $4.99.\n"
       initial-location garage
       $weight 540
       $capacity 530
       $opens? T
       $open? nil))

(basic-thing beer
    (noun beer)
    (adjective cold)
    (method (drink)
       (if (not coldcooler?) (progn (print "YECH!!!  Warm beer!  You spit
               the mouthful of beer out and decide not to drink it.\n")
               (abort)))
       (print "WOW!  C C C COLD!  C C C C Canadian BEER!!!  Twenty four of
               them.  Good thing they have those cheap twist off tops because
               you forgot your opener in your other tights.\n\n  You quaff the
               first 20 and begin to feel a mild glow so you slowly sip the
               last four and savour the flavour (notice the Canadian spelling)
               and the colour of the brew.\n")
       (putin beer NOWHERE)
       (putin bottles me)
       (abort))
    (property
       initial-location cooler
       $LDESC "There is a two-four of beer here."
       $SDESC "two-four of cold beer"
       $EDESC "This is obviously the finest of Canadian beer!\n"
       $weight 500))

(rtn-fuse cooler-fuse
    (property
        name "cooler-fuse"
        delay 10)
    (method (bang)
        (if coldcooler? (progn(setp beer $SDESC "two-four of warm beer")
                            (if (IsInRec? me cooler)
                                (print "The styrofoam cooler has warmed up a
                                        bit.\n"))))
        (setq coldcooler? nil)))
 
(basic-thing bottles
    (noun bottles)
    (adjective empty)
    (property
       initial-location NOWHERE
       $weight 100
       $LDESC "There is a two-four of beautiful handcrafted beer bottles here."
       $SDESC "two-four of beautifully handcrafted empty beer bottles"
       $EDESC "They look like beautifully handcrafted magical empty beer
               bottles.  (Well it seemed like magic when you drank them.)\n"
       $capacity 99))
;****************************************************************************
(location OUTSIDEWORKSHOP
     (noun path paths drift drifts snowdrift snowdrifts))
;****************************************************************************

(basic-thing blender
   (noun blender)
   (adjective Santa's)
   (method (put %dobject)
      (if (= %dobject poinsettia)
              (progn(putin poinsettia NOWHERE)
                    (putin poinsettiajuice blender)
                    (print "You drop the poinsettia into the
                            blender and puree it into a bright
                            red juice.\n")
                    (abort)))
      (if (and (= %dobject snowflake)(= (parent poinsettiajuice) blender))
          (progn(putin snowflake poinsettiajuice)
                (print "There is a blinding flash of light and a puff of
                        greasy black smoke (no adventure would be complete
                        without one).      The boring old poinsettia
                        juice has been magically transformed into
                        'No Doze Noze Gloze'.\n")
                (setq NOZEGLOZE T)
                (abort))))
   (property
      $LDESC "Santa's blender is here."
      $SDESC "blender"
      $EDESC "It's a standard kitchen blender which Santa has been making
               liberal use of to mix drinks.\n"
      initial-location FLOE10
      $onfloor? 1
      $invisible? T
      $open? T
      $opens? T
      $weight 50
      $capacity 10))

(basic-thing silkhat
   (noun hat)
   (adjective old silk)
   (property
      $LDESC "There is an old silk hat here."
      $SDESC "n old silk hat"
      $EDESC "The hat is very old and beat up but you sense something quite
              unusual about it.\n"
      initial-location FLOE22
      $onfloor? 2
      $weight 5))

(actor dummy-snowman
   (noun snowman)
   (method (put %dobject)
      (if (= %dobject silkhat)
          (progn(drop-it %actor %dobject)
                (take-it %iobject %dobject)
                (print "There must have been some magic in that old silk
                        hat you found 'cause when you placed it on his head he
                        began to dance around.  Hey!  That's Frosty The Snowman!
                        Don't see any corn cob pipe, but who could forget that
                        face?\n")
                (putin dummy-snowman NOWHERE)
                (putin SNOWMAN FLOE14)
                (setq FrostyBuilt? T)
                (abort))
          (progn(print "What would a snowman want with that?\n")
                (abort))))
   (method (give %dobject)
      (if (= %dobject silkhat)
          (progn(drop-it %actor %dobject)
                (take-it %iobject %dobject)
                (print "There must have been some magic in that old silk
                        hat you found 'cause when you placed it on his head he
                        began to dance around.  Hey!  That's Frosty The Snowman!
                        Don't see any corn cob pipe, but who could forget that
                        face?\n")
                (putin dummy-snowman NOWHERE)
                (putin SNOWMAN FLOE14)
                (setq FrostyBuilt? T)
                (abort))
          (progn(print "What would a snowman want with that?\n")
                (abort))))
    (property
       $LDESC "There is a snowman here."
       $SDESC "snowman"
       $EDESC "The snowman looks a lot like someone you knew a long time ago.
               You pulled a few odds and ends that you had forgotten about
               out of your pocket and made a crude face.  No matter how you
               rearrange the carrots and lumps of coal, the snowman seems to
               to frown.\n"
       initial-location NOWHERE
       $capacity 3
       $weight 3000
       $open? T))

(action make
   (verb make build (make snowman)(build snowman)(make a snowman)(build a snowman))
   (direct-object optional)
   (code
      (if SPOLE (progn (print "It's too cold here to do that.\n")(abort)))
      (if (not(= curloc FLOE14))
          (progn(print "You can't do that here!\n")
                (abort)))
      (if (not $dobject)
      (progn(print "Snowman built.\n")
            (putin DUMMY-SNOWMAN FLOE14))
      (print "You can't do that!\n"))))


(basic-thing poinsettia
   (noun poinsettia flower plant leaf leaves)
   (adjective red fresh real)
   (property
      $LDESC "There is a red poinsettia here."
      $SDESC "red poinsettia"
      $EDESC "This is the finest example of a spurge that you have seen in
              a long time.  It is very unusual to see them growing in a 
              cold climate, seeing as they are native to Central America.
              This poinsettia has bright red leaves.  In fact they seem to
              glow.  It's growth is almost cactus-like, as it waves its'
              radially symmetrical leaves in the light breeze.\n"
      initial-location SNOWMAN
      $open? T
      $opens? nil
      $invisible? nil
      $weight 3))

(basic-thing poinsettiajuice
   (noun juice liquid)
   (adjective red bright)
   (method (put %dobject)
      (send blender put %dobject))
   (method (drink)
      (print "Dumb! Dumb! Dumb! You got this far and screwed up!  The plan
              was to get Santa and Rudolph on their way, not to pull the
              sleigh yourself!  Great, so your nose is glowing.  What are
              you going to do?  Cut it off and glue it on Rudolph?\n")
      (putin poinsettiajuice NOWHERE)
      (abort))
   (property
      $LDESC "There is a bright red liquid here."
      $SDESC "bright red liquid"
      $EDESC "It is an extremely bright red juice.  You thought the flower
              itself glowed....well, this juice is something else!  There
              doesn't seem to be any of the leaf left.  You have managed to
              liquify it!!\n"
      initial-location NOWHERE
      $weight 3
      $capacity 2))
  

;****************************************************************************
;ICECRYSTALGARDEN
;****************************************************************************

(basic-thing iceflower
   (noun flower poinsettia)
   (adjective crystal clear ice)
   (property
      $LDESC "There is a magnificent ice flower here."
      $SDESC "n ice flower"
      $EDESC "You closely examine the flower and only then begin to realize
              just how talented the sculptor was.  Every last detail of
              a real poinsettia plant has been reproduced, right down to the
              miniscule stoma of the petals.  It must have been placed in
              the orb to preserve it.  Looks like it worked, it's the only
              flower left intact.\n"
      initial-location ORB
      $weight 20
      $invisible? nil
      $onfloor? 2))

(basic-thing orb
    (noun orb container)
    (adjective translucent blue)
    (property
       $LDESC "There is an orb here."
       $SDESC "n orb of translucent blue ice"
       $EDESC "The orb is made of ice and looks like it could withstand
               any and all efforts to force it open.  There is a small hole
               in the orb which has been carefully machined into the shape
               of a key hole.\n"
       initial-location FLOE10
       $onfloor? 2
       $weight 1000
       $transp? t
       $invisible? t
       $opens? t
       $open? nil
       $locks? t
       $locked? t
       $key brasskey
       $capacity 999))

(basic-thing thermometer
    (noun thermometer)
    (property
       $LDESC "The official North Pole weather thermometer is here."
       $SDESC "thermometer"
       $EDESC "The mercury in the thermometer is up around 10 degrees Celsius.\n"
       $RDESC "The mercury in the thermometer is up around 10 degrees Celsius.\n"
       initial-location FLOE11
       $onfloor 1
       $weight 100))

(basic-thing snowflake
   (noun snowflake)
   (method (take)
       (print "It's starting to snow EVERYWHERE!  It's snowing in Santa's
               Office, it's snowing in the closet and it's snowing outside!!!
               It slowly flutters toward the ground and glistens and sparkles
               and almost seems to wink at you.  If there were millions of
               elves crowded around you now, they'd all be smiling.  Santa
               is going to be very pleased with you.  Looks like Christmas
               isn't going to be a washout this year after all.\n"))
   (property
       $LDESC "There is a snowflake here."
       $SDESC "snowflake"
       $EDESC "This is the first snowflake which fell on Christmas Eve.  It is
               perfect in every way and is very special.\n"
       initial-location NOWHERE
       $invisible? T
       $weight 1))

(rtn-fuse snow-fuse
    (property
        name "snow-fuse"
        delay 3)
    (method (bang)
        (if (not Snowing?)(progn(putin SNOWFLAKE curloc)
                                (send melt-fuse add)
                                (setp THERMOMETER $EDESC "The mercury in the
                                     thermometer has dropped to -8 degrees
                                     Celsius.\n")
                                (setp THERMOMETER $RDESC "The mercury in the
                                     thermometer has dropped to -8 degrees
                                     Celsius.\n")
                                (print "The mercury in the thermometer has
                                 fallen dramatically in the last few seconds
                                 since you put it in the icy cooler.  In fact
                                the temperature EVERYWHERE seems to be dropping.
                                A delicate snowflake forms in the air above you
                                and falls to your feet.\n")))
        (setq Snowing? T)))

(rtn-fuse melt-fuse
   (property
      name "melt-fuse"
      delay 10)
   (method (bang)
      (if (IsInRec? snowflake me)
          (print "The first snowflake melted!\n"))
      (putin snowflake NOWHERE)))
