;******************************************************************************
;*                Module:  SOUTHPOL.ELV          Version:  1.31               *
;*                Last Updated: Dec. 10, 87      By Marlene Abriel            *
;*                                                                            *
;*                Sets $LDESC, $SDESC, etc for rooms and objects on           *
;*                FLOOR2  in this case, when the actor is at the              *
;*                South Pole.  Called by the ENTER-MIRROR routines.           *
;******************************************************************************

(define (SOUTHPOLE)

(setp BUNKHOUSEMIRROR $onfloor? 2)

(setp SNOWMAN $onfloor? 2)
(setp SNOWMAN $EDESC "Percival Penguin is all dressed up with no place to go.
                      He's wearing a black tuxedo with enormous pockets.\n")


(setp BUNKHOUSE $onfloor? 2)
(setp BUNKHOUSE $LDESC "\nICE PLAIN\n\nYou are standing at the foot of a small
                      knoll at the edge of an enormous plain of ice.  The
                      wind drives a constant wall of hail and snow at your
                      back as you look down at an odd looking door which is
                      built into the slope of the hill.  There is a crystalline
                      mirror to the left of the door.  The snow is blinding
                      but you get glimpses of paths leading off in all
                      directions. ")
(setp BUNKHOUSE $SDESC "At the ice door.")
(setp BUNKHOUSE north FLOE1)
(setp BUNKHOUSE northeast OUTSIDEWORKSHOP)
(setp BUNKHOUSE east OUTSIDEWORKSHOP)
(setp BUNKHOUSE southeast OUTSIDEWORKSHOP)
(setp BUNKHOUSE south OUTSIDEWORKSHOP)
(setp BUNKHOUSE southwest OUTSIDEWORKSHOP)
(setp BUNKHOUSE west OUTSIDEWORKSHOP)
(setp BUNKHOUSE northwest OUTSIDEWORKSHOP)
(setp BUNKHOUSE down CLOSETDOOR1)
(setp BUNKHOUSE up OUTSIDEWORKSHOP)

(setp CLOSETDOOR1 $onfloor? 2)
(setp CLOSETDOOR1 $LDESC "[THE OUTSIDE DOOR OF THE ROOM UNDER HILLSIDE]")
(setp CLOSETDOOR1 $SDESC "the outside door of the room under hillside")
(setp CLOSETDOOR1 $EDESC "The door is about 3 feet tall and is made of solid
                       ice.  There is an outline which somewhat resembles the
                       continent of Antarctica carved on it.\n")
(setp CLOSETDOOR1 $open? nil)


(setp CLOSETDOOR2 $onfloor? 2)
(setp CLOSETDOOR2 $EDESC "The door is about 3 feet tall and is made of solid
                       ice.\n")
(setp CLOSETDOOR2 $LDESC "[THE INSIDE DOOR OF THE ROOM UNDER HILLSIDE]")
(setp CLOSETDOOR2 $SDESC "the inside door of the room under hillside")
(setp CLOSETDOOR2 $open? nil)



(setp CLOSET $onfloor? 2)
(setp CLOSET $LDESC "\nROOM IN THE HILLSIDE\n\nYour first impression of this
                     room in the hill is, that it is very boring.  Why is it
                     here?  Maybe it's a root cellar.  Then again it might be
                     here to provide a shelter from the storm.  Who knows,
                     anyway, you're here.")
(setp CLOSET $SDESC  "In a room in the hillside.")
(setp CLOSET $EDESC  "It's just as you would expect it to be, made of dirt.
                      Someone went to a great deal of trouble to build this
                      room out of the permafrost.  There is a bit of light
                      filtering in, making it possible for you to see what
                      might be a tiny opening to the southwest.\n")
(setp CLOSET north nil)
(setp CLOSET up CLOSETDOOR2)
(setp CLOSET $lit? t)
(setp CLOSET southwest WORKSHOP)


(setp WORKSHOP $onfloor? 2)
(setp WORKSHOP $LDESC "\nNARROW PASSAGE\n\nIt is outrageously cold in this 
                       passageway as it continues into darkness to the 
                       southwest.")
(setp WORKSHOP $SDESC "Shivering in the narrow SW passage.")
(setp WORKSHOP $EDESC "You don't learn anything new about the passage.\n")
(setp WORKSHOP southwest GARAGE)
(setp WORKSHOP northeast CLOSET)
(setp WORKSHOP north nil)
(setp WORKSHOP south nil)
(setp WORKSHOP east nil)
(setp WORKSHOP west nil)


(setp GARAGE $onfloor? 2)
(setp GARAGE $LDESC "\nDEAD END\n\nEvery game has to have a dead end.  You're
                     now in the dead end of ELVES '87.")
(setp GARAGE $SDESC "You stub your nose on the dead end.  You should be
                     following the map that you were supposed to make.  All
                     good adventurers know where they're going.")
(setp GARAGE $EDESC "Someone must have been here before you.  They have left a
                     piece of lined note paper here.\n")
(setp GARAGE northeast WORKSHOP)
(setp GARAGE $lit? nil)
(setp GARAGE east nil)

(setp OUTSIDEWORKSHOP $onfloor? 2)
(setp OUTSIDEWORKSHOP $LDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp OUTSIDEWORKSHOP $SDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp OUTSIDEWORKSHOP $EDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp OUTSIDEWORKSHOP north SOAPSTONE)
(setp OUTSIDEWORKSHOP northeast BUNKHOUSE)
(setp OUTSIDEWORKSHOP east SOAPSTONE)
(setp OUTSIDEWORKSHOP southeast SOAPSTONE)
(setp OUTSIDEWORKSHOP south SOAPSTONE)
(setp OUTSIDEWORKSHOP southwest SOAPSTONE)
(setp OUTSIDEWORKSHOP west SOAPSTONE)
(setp OUTSIDEWORKSHOP northwest SOAPSTONE)
(setp OUTSIDEWORKSHOP up SOAPSTONE)
(setp OUTSIDEWORKSHOP down SOAPSTONE)

(setp SOAPSTONE $onfloor? 2)
(setp SOAPSTONE $LDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp SOAPSTONE $SDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp SOAPSTONE $EDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp SOAPSTONE north OUTSIDEWORKSHOP)
(setp SOAPSTONE northeast OFFICE)
(setp SOAPSTONE east OFFICE)
(setp SOAPSTONE southeast OFFICE)
(setp SOAPSTONE south OFFICE)
(setp SOAPSTONE southwest OFFICE)
(setp SOAPSTONE west OFFICE)
(setp SOAPSTONE northwest OFFICE)
(setp SOAPSTONE up OFFICE)
(setp SOAPSTONE down OFFICE)

(setp OFFICE $onfloor? 2)
(setp OFFICE $LDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp OFFICE $SDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp OFFICE $EDESC "\nICE PLAIN\n\nThe wind is blowing fiercely here,
                             sculpting the snowdrifts into fantastic forms and
                             figures.  It reminds you of a bad dream about
                             getting lost in the ice plains of the Antarctic.
                             Your imagination is triggered by the abstracts...
                             .....dragons, unicorns and other mythical beings.
                             There are paths leading off in many directions.")
(setp OFFICE north OFFICE)
(setp OFFICE northeast OFFICE)
(setp OFFICE east OFFICE)
(setp OFFICE southeast OFFICE)
(setp OFFICE south OFFICE)
(setp OFFICE southwest SOAPSTONE)
(setp OFFICE west OFFICE)
(setp OFFICE northwest OFFICE)
(setp OFFICE up OFFICE)
(setp OFFICE down OFFICE)

(setp DROWN $onfloor? 2)
(setp DROWN $LDESC
            "\nNow you've done it!  You've slid off the floe into the frigid
               water.  Your life passes before your eyes.  They say drowning
               is not such a bad way to go, but whoever said that must have
               drowned in warm water.  Your frozen little body bobs to the
               surface for a second then flips upside down and you sink to
               the bottom of the ocean.  You're dead!  You blew it!  Millions
               of little kids aren't going to have Christmas this year because
               YOU WERE A DUMMY!  BAH!  HUMBUG!\n")

(setp FLOE1 $onfloor? 2)
(setp FLOE1 $LDESC
              "\nYou've stepped out onto a mass of hexagonal ice floes, each
               identical to the other.  The edge of each floe looks very
               slippery and the water is a cold deep blue.  In fact, off
               hand, I'd say the water was down right frigid.  Watch your
               step out here, my little elf friend.  Some of the floes are 
               close enough together that
               you might carefully walk from one to another, but the ice
               mass is breaking up and many of the well travelled paths
               are now gone. Solid land lies due south.")
(setp FLOE1 $SDESC
       "Decided to take another crack at the ice floes, did you?")
(setp FLOE1 north FLOE2)
(setp FLOE1 south BUNKHOUSE)
(setp FLOE1 northeast DROWN)
(setp FLOE1 east DROWN)
(setp FLOE1 southeast DROWN)
(setp FLOE1 southwest DROWN)
(setp FLOE1 west DROWN)
(setp FLOE1 northwest DROWN)

(setp FLOE2 $onfloor? 2)
(setp FLOE2 $LDESC 
             "\nAs you step to the next floe, the ice crumbles beneath your
               feet.  You barely are able to scramble across the widening
               gap.  The floe rocks unsteadily and creaks and moans under
               your weight. You can't go back the way you came.  That last
               floe seems to have entirely broken up.  You make a mental
               note to lay off the figgy pudding next Christmas.")
(setp FLOE2 $SDESC "On an ice floe.")
(setp FLOE2 southeast FLOE5)
(setp FLOE2 north DROWN)
(setp FLOE2 northeast DROWN)
(setp FLOE2 east DROWN)
(setp FLOE2 south DROWN)
(setp FLOE2 southwest DROWN)
(setp FLOE2 west DROWN)
(setp FLOE2 northwest DROWN)

(setp FLOE3 $onfloor? 2)
(setp FLOE3 $LDESC "On an ice floe.")
(setp FLOE3 $SDESC "On an ice floe.")
(setp FLOE3 north FLOE4)
(setp FLOE3 northeast DROWN)
(setp FLOE3 east DROWN)
(setp FLOE3 southeast FLOE6)
(setp FLOE3 south DROWN)
(setp FLOE3 southwest DROWN)
(setp FLOE3 west DROWN)
(setp FLOE3 northwest DROWN)
       
(setp FLOE4 $onfloor? 2)
(setp FLOE4 $LDESC "On an ice floe.")
(setp FLOE4 $SDESC "On an ice floe.")
(setp FLOE4 north DROWN)
(setp FLOE4 northeast DROWN)
(setp FLOE4 east DROWN)
(setp FLOE4 southeast FLOE7)
(setp FLOE4 south FLOE3)
(setp FLOE4 southwest DROWN)
(setp FLOE4 west DROWN)
(setp FLOE4 northwest DROWN)
       
(setp FLOE5 $onfloor? 2)
(setp FLOE5 $LDESC "On an ice floe.")
(setp FLOE5 $SDESC "On an ice floe.")
(setp FLOE5 north DROWN)
(setp FLOE5 northeast FLOE9)
(setp FLOE5 east DROWN)
(setp FLOE5 southeast FLOE8)
(setp FLOE5 south DROWN)
(setp FLOE5 southwest DROWN)
(setp FLOE5 west DROWN)
(setp FLOE5 northwest FLOE2)
      
(setp FLOE6 $onfloor? 2)
(setp FLOE6 $LDESC "On an ice floe.")
(setp FLOE6 $SDESC "On an ice floe.")
(setp FLOE6 north DROWN)
(setp FLOE6 northeast DROWN)
(setp FLOE6 east DROWN)
(setp FLOE6 southeast FLOE9)
(setp FLOE6 south DROWN)
(setp FLOE6 southwest DROWN)
(setp FLOE6 west DROWN)
(setp FLOE6 northwest FLOE3)
       
(setp FLOE7 $onfloor? 2)
(setp FLOE7 $LDESC "On an ice floe.")
(setp FLOE7 $SDESC "On an ice floe.")
(setp FLOE7 north DROWN)
(setp FLOE7 northeast FLOE11)
(setp FLOE7 east DROWN)
(setp FLOE7 southeast DROWN)
(setp FLOE7 south DROWN)
(setp FLOE7 southwest DROWN)
(setp FLOE7 west DROWN)
(setp FLOE7 northwest FLOE4)
       
(setp FLOE8 $onfloor? 2)
(setp FLOE8 $LDESC "On an ice floe.")
(setp FLOE8 $SDESC "On an ice floe.")
(setp FLOE8 north DROWN)
(setp FLOE8 northeast FLOE12)
(setp FLOE8 east DROWN)
(setp FLOE8 southeast DROWN)
(setp FLOE8 south DROWN)
(setp FLOE8 southwest DROWN)
(setp FLOE8 west DROWN)
(setp FLOE8 northwest FLOE5)
       
(setp FLOE9 $onfloor? 2)
(setp FLOE9 $LDESC "On an ice floe.")
(setp FLOE9 $SDESC "On an ice floe.")
(setp FLOE9 north DROWN)
(setp FLOE9 northeast DROWN)
(setp FLOE9 east DROWN)
(setp FLOE9 southeast DROWN)
(setp FLOE9 south DROWN)
(setp FLOE9 southwest FLOE5)
(setp FLOE9 west DROWN)
(setp FLOE9 northwest FLOE6)

(setp FLOE10 $onfloor? 2)
(setp FLOE10 $LDESC"\nCRYSTAL GARDEN\n\n
               In order to step onto this ice floe you have to duck under an
               archway of ice.......\n\n
               You have found yourself in a place that you have only seen in
               your imagination.  How many times have you dreamed of the Ice
               Caves?  The older elves used to sit around after a hard day of
               work and tell tales of these caves.  All that remains of a once
               perfect ice crystal flower garden is a single delicate
               poinsettia.  Some unknown force has destroyed all the other
               flowers, leaving a scattered array of broken stems and petals in
               it's wake.  The lone poinsettia is encased in an orb of frost
               and jagged shards of ice.")
(setp FLOE10 $SDESC "In the ice crystal garden.")
(setp FLOE10 $EDESC "It looks like a herd of reindeer stampeded through here.
                     There's no point in searching through the rubble.  It's
                     only broken pieces of ice.\n")
(setp FLOE10 north DROWN)
(setp FLOE10 northeast FLOE14)
(setp FLOE10 east DROWN)
(setp FLOE10 southeast FLOE13)
(setp FLOE10 south DROWN)
(setp FLOE10 southwest DROWN)
(setp FLOE10 west DROWN)
(setp FLOE10 northwest DROWN)
       
(setp FLOE11 $onfloor? 2)
(setp FLOE11 $LDESC "On an ice floe.")
(setp FLOE11 $SDESC "On an ice floe.")
(setp FLOE11 north DROWN)
(setp FLOE11 northeast DROWN)
(setp FLOE11 east DROWN)
(setp FLOE11 southeast FLOE14)
(setp FLOE11 south DROWN)
(setp FLOE11 southwest FLOE7)
(setp FLOE11 west DROWN)
(setp FLOE11 northwest DROWN)

(setp FLOE12 $onfloor? 2)
(setp FLOE12 $LDESC "On an ice floe.")
(setp FLOE12 $SDESC "On an ice floe.")
(setp FLOE12 north FLOE13)
(setp FLOE12 northeast DROWN)
(setp FLOE12 east DROWN)
(setp FLOE12 southeast FLOE15)
(setp FLOE12 south DROWN)
(setp FLOE12 southwest FLOE8)
(setp FLOE12 west DROWN)
(setp FLOE12 northwest DROWN)

(setp FLOE13 $onfloor? 2)
(setp FLOE13 $LDESC "On an ice floe.")
(setp FLOE13 $SDESC "On an ice floe.")
(setp FLOE13 $EDESC nil)
(setp FLOE13 $lit? T)
(setp FLOE13 north DROWN)
(setp FLOE13 northeast DROWN)
(setp FLOE13 east DROWN)
(setp FLOE13 southeast FLOE16)
(setp FLOE13 south FLOE12)
(setp FLOE13 southwest DROWN)
(setp FLOE13 west DROWN)
(setp FLOE13 northwest FLOE10)


(setp FLOE14 $onfloor? 2)
(setp FLOE14 $LDESC "On an ice floe.")
(setp FLOE14 $SDESC "On an ice floe.")
(setp FLOE14 north DROWN)
(setp FLOE14 northeast DROWN)
(setp FLOE14 east DROWN)
(setp FLOE14 southeast DROWN)
(setp FLOE14 south DROWN)
(setp FLOE14 southwest FLOE10)
(setp FLOE14 west DROWN)
(setp FLOE14 northwest FLOE11)

(setp FLOE15 $onfloor? 2)
(setp FLOE15 $LDESC "On an ice floe.")
(setp FLOE15 $SDESC "On an ice floe.")
(setp FLOE15 north DROWN)
(setp FLOE15 northeast DROWN)
(setp FLOE15 east DROWN)
(setp FLOE15 southeast DROWN)
(setp FLOE15 south DROWN)
(setp FLOE15 southwest DROWN)
(setp FLOE15 west DROWN)
(setp FLOE15 northwest FLOE12)

(setp FLOE16 $onfloor? 2)
(setp FLOE16 $LDESC "On an ice floe.")
(setp FLOE16 $SDESC "On an ice floe.")
(setp FLOE16 north FLOE17)
(setp FLOE16 northeast DROWN)
(setp FLOE16 east DROWN)
(setp FLOE16 southeast FLOE19)
(setp FLOE16 south DROWN)
(setp FLOE16 southwest DROWN)          
(setp FLOE16 west DROWN)
(setp FLOE16 northwest FLOE13)

(setp FLOE17 $onfloor? 2)
(setp FLOE17 $LDESC "On an ice floe.")
(setp FLOE17 $SDESC "On an ice floe.")
(setp FLOE17 north FLOE18)
(setp FLOE17 northeast FLOE21)
(setp FLOE17 east DROWN)
(setp FLOE17 southeast DROWN)
(setp FLOE17 south DROWN)
(setp FLOE17 southwest DROWN)
(setp FLOE17 west DROWN)
(setp FLOE17 northwest DROWN)

(setp FLOE18 $onfloor? 2)
(setp FLOE18 $LDESC "On an ice floe.")
(setp FLOE18 $SDESC "On an ice floe.")
(setp FLOE18 north DROWN)
(setp FLOE18 northeast DROWN)
(setp FLOE18 east DROWN)
(setp FLOE18 southeast DROWN)
(setp FLOE18 south FLOE17)
(setp FLOE18 southwest DROWN)
(setp FLOE18 west DROWN)
(setp FLOE18 northwest DROWN)

(setp FLOE19 $onfloor? 2)
(setp FLOE19 $LDESC "On an ice floe.")
(setp FLOE19 $SDESC "On an ice floe.")
(setp FLOE19 north DROWN)
(setp FLOE19 northeast DROWN)
(setp FLOE19 east DROWN)
(setp FLOE19 southeast FLOE22)
(setp FLOE19 south DROWN)
(setp FLOE19 southwest DROWN)
(setp FLOE19 west DROWN)
(setp FLOE19 northwest FLOE16)

(setp FLOE20 $onfloor? 2)
(setp FLOE20 $LDESC "On an ice floe.")
(setp FLOE20 $SDESC "On an ice floe.")
(setp FLOE20 north DROWN)
(setp FLOE20 northeast FLOE24)
(setp FLOE20 east DROWN)
(setp FLOE20 southeast FLOE23)
(setp FLOE20 south DROWN)
(setp FLOE20 southwest DROWN)
(setp FLOE20 west DROWN)
(setp FLOE20 northwest DROWN)

(setp FLOE21 $onfloor? 2)
(setp FLOE21 $LDESC "On an ice floe.")
(setp FLOE21 $SDESC "On an ice floe.")
(setp FLOE21 north DROWN)
(setp FLOE21 northeast FLOE25)
(setp FLOE21 east DROWN)
(setp FLOE21 southeast FLOE24)
(setp FLOE21 south DROWN)
(setp FLOE21 southwest FLOE17)
(setp FLOE21 west DROWN)
(setp FLOE21 northwest DROWN)

(setp FLOE22 $onfloor? 2)
(setp FLOE22 $LDESC "\nGREAT ICE HALL\n\nThis ice floe has formed itself into
                       a cave.  The front of the cavern emanates an
                       eerie bluish glow which sparkles and glistens off the
                       walls, gradually fading as your eyes look deeper and
                       deeper into the furthest recesses.  You are in a great
                       hall which was carved eons ago by the great Christmas
                       elves.  You sense great powers at work in the ice.  The
                       source of all Christmas magic flows from within.")
(setp FLOE22 $SDESC "In the great ice hall.")
(setp FLOE22 north FLOE23)
(setp FLOE22 northeast DROWN)
(setp FLOE22 east DROWN)
(setp FLOE22 southeast DROWN)
(setp FLOE22 south DROWN)
(setp FLOE22 southwest DROWN)
(setp FLOE22 west DROWN)
(setp FLOE22 northwest FLOE19)

(setp FLOE23 $onfloor? 2)
(setp FLOE23 $LDESC "On an ice floe.")
(setp FLOE23 $SDESC "On an ice floe.")
(setp FLOE23 north DROWN)
(setp FLOE23 northeast DROWN)
(setp FLOE23 east DROWN)
(setp FLOE23 southeast DROWN)
(setp FLOE23 south FLOE22)
(setp FLOE23 southwest DROWN)
(setp FLOE23 west DROWN)
(setp FLOE23 northwest FLOE20)

(setp FLOE24 $onfloor? 2)
(setp FLOE24 $LDESC "On an ice floe.")
(setp FLOE24 $SDESC "On an ice floe.")
(setp FLOE24 north DROWN)
(setp FLOE24 northeast DROWN)
(setp FLOE24 east DROWN)
(setp FLOE24 southeast DROWN)
(setp FLOE24 south DROWN)
(setp FLOE24 southwest FLOE20)
(setp FLOE24 west DROWN)
(setp FLOE24 northwest FLOE21)

(setp FLOE25 $onfloor? 2)
(setp FLOE25 $LDESC "On an ice floe.")
(setp FLOE25 $SDESC "On an ice floe.")
(setp FLOE25 north BUNKHOUSE)
(setp FLOE25 northeast DROWN)
(setp FLOE25 east DROWN)
(setp FLOE25 southeast DROWN)
(setp FLOE25 south DROWN)
(setp FLOE25 southwest FLOE21)
(setp FLOE25 west DROWN)
(setp FLOE25 northwest DROWN)

)
