;*******************************************************************************
;*                Module:  NORTHPOL.ELV          Version:  1.21                *
;*                Last Updated: Dec 11, 87       By  Bruce MacKay              *
;*                                                                             *
;*                Sets $LDESC, $SDESC, etc for rooms and objects on            *
;*                FLOOR1  in this case, when the actor is at the               *
;*                North Pole.  Called by the ENTER-MIRROR routines.            *
;*******************************************************************************

(define (NORTHPOLE)

(setp SNOWMAN $EDESC "The snowman looks roughly like 3 balls of snow piled
           on top of each other with  coal, carrots and an assortment of other
           frozen vegetables arranged into a happy face.\n")
(setp SNOWMAN $onfloor? 1)

(setp BUNKHOUSE $LDESC "\nBUNKHOUSE\n\nFrom the looks of this room, you are in
             the elves' bunkhouse.  There is a closet to the south, a few sets
             of bunk
             beds, an oak bureau, and the door to the workshop to the west.")
(setp BUNKHOUSE $SDESC "In the Bunkhouse")
(setp BUNKHOUSE $onfloor? 1)
(setp BUNKHOUSE north nil)
(setp BUNKHOUSE northeast nil)
(setp BUNKHOUSE east nil)
(setp BUNKHOUSE southeast nil)
(setp BUNKHOUSE south ClosetDoor1)
(setp BUNKHOUSE southwest nil)
(setp BUNKHOUSE west WORKSHOP)
(setp BUNKHOUSE northwest nil)
(setp BUNKHOUSE down nil)

(setp CLOSET $LDESC "\nCLOSET\n\nThis closet seems very familiar.")
(setp CLOSET $EDESC "The closet is about 1 metre square.  Good thing you brought
              your nifty lantern.  There's no other light in here.\n")
(setp CLOSET $SDESC "Your closet.")
(setp CLOSET $onfloor? 1)
(setp CLOSET $lit? nil)
(setp CLOSET north ClosetDoor2)
(setp CLOSET southwest nil)
(setp CLOSET up nil)

(setp CLOSETDOOR1 $EDESC "Yup! It's a closet door all right!\n")
(setp CLOSETDOOR1 $LDESC "[THE CLOSET DOOR]")
(setp CLOSETDOOR1 $SDESC "the closet door")
(setp CLOSETDOOR1 $onfloor? 1)

(setp CLOSETDOOR2 $EDESC "Yup! It's a closet door all right!\n")
(setp CLOSETDOOR2 $LDESC "[THE CLOSET DOOR]")
(setp CLOSETDOOR2 $SDESC "the closet door")
(setp CLOSETDOOR2 $onfloor? 1)

(setp WORKSHOP $LDESC "\nWORKSHOP\n\nThis  is Santa's Workshop. Not many people
                have laid their eyes on this room. All around you is a
                clutter of toys, in various stages of development and
                tools of all descriptions. To the north there is a door.
                Doors also lie to the south, east and
                west. Work benches line all four walls. Above each bench
                is a peg board full of hooks. Tools hang from the hooks.
                The tops of the benches are covered with an array of
                items, from scraps of building materials, the odd nail 
                and screw, paint brushes, cans of paint (some open and
                some closed) to blueprints and plans of toys. The floor
                is cluttered with toys. These toys represent just about
                every stage of development possible. In fact the clutter
                on the floor is so bad, that you have to kick a path in
                order to move about the room.")
(setp WORKSHOP $SDESC "You find yourself amongst the clutter of the Workshop
                once again.")
(setp WORKSHOP $EDESC "This place is in such a state that it is almost 
                impossible to distinguish the different objects.  In fact it
                is much easier to describe everything together instead of
                individually.  Why you have every decided to examine this
                jungle is beyond me.  Surely you must recall how chaotic
                the workshop gets on Christmas Eve.  The result has always
                been what you see lying before you...a mess!  But if you
                insist..........\n\n
                Let's start with the benches.  The scraps of leftover building
                materials are nothing but sawdust with a few twisted nails and
                deformed screws mixed in.  The paint brushes have seen better
                days.  They should have been soaked in varsol because the
                paint on them has been allowed to dry and harden.  In fact you
                could use them for a hammer!  The brushes are lying beside a
                couple of open paint cans.  Of course there's nothing left in
                them.  Next you see three closed cans of paint.  It's obvious
                what tint the paint inside is, because the labels are different
                colours.  Last, but not least are the blueprints and toys.  It's
                been a long time since you read one of these.  You were a very 
                young elf when you built toys in the workshop.  Flipping 
                through them brings back memories...rocking horses, bicycles,
                electric trains, dolls, teddy bears...every toy that you can
                possibly think of has a set of plans.\n
                Above the work benches are peg boards where the tools should
                hang.  Someone has taken the time to outline the shape of 
                each tool.  You wonder why you or one of your buddies hadn't
                thought of that.  Now everybody knows what tool goes where.
                Most of the hooks are bare, but from the outlines you can see
                that the tools used today haven't changed from when you worked
                here.\n
                The clutter on the floor is impossible to decipher.  You wish 
                you had a broom and dustpan.  The best place for this stuff is
                in the garbage.  Don't waste you time trying to figure it out.
                Ignore it...looks like someone else did!\n")
(setp WORKSHOP $onfloor? 1)
(setp WORKSHOP northeast nil)
(setp WORKSHOP southwest nil)
(setp WORKSHOP east BUNKHOUSE)
(setp WORKSHOP west GARAGE)
(setp WORKSHOP south GIFTWRAP)
(setp WORKSHOP north OUTSIDEWORKSHOP)

(setp GIFTWRAP $LDESC "\nGIFTWRAP\n\nNow this is a room that most people would give
                 their eye teeth to own, especially during the Christmas
                 Season. It's a gift wrapping room. Can you just imagine
                 a never ending supply of scotch tape. By the looks of the
                 rolls of tape here, you would never run out.  The table here
                 is laden with an assortment of paraphernalia used to wrap
                 gifts.")
(setp GIFTWRAP $SDESC "What happened ? Need to wrap a gift ?")
(setp GIFTWRAP north WORKSHOP)
(setp GIFTWRAP south OFFICE)

(setp OFFICE $LDESC "\nOFFICE\n\nYou are in the private office of Mr. S. 
               Claus. In front of you is a huge desk.  There are the usual 
               office-type pieces of furniture:  filing cabinets, a swivel
               chair and an Atari ST (no office should be without one).
               There are doors to the north and south.")
(setp OFFICE $SDESC "Santa's Private Office.")
(setp OFFICE $EDESC "The desk and computer are the most prominent pieces of
                     furniture in the room.\n")
(setp OFFICE $onfloor? 1)
(setp OFFICE north GIFTWRAP)
(setp OFFICE south SOAPSTONE)

(setp SOAPSTONE $LDESC "\nSOAPSTONE\n\nYou are outside,
                south of the Workshop, standing on a path made of soapstone.
                It continues south to a delicious looking gingerbread
                cottage.")
(setp SOAPSTONE $SDESC "On the soapstone path.")
(setp SOAPSTONE $EDESC "The path disappears in the fog.\n")
(setp SOAPSTONE $onfloor? 1)
(setp SOAPSTONE north OFFICE)
(setp SOAPSTONE northeast nil)
(setp SOAPSTONE east FLOE20)
(setp SOAPSTONE southeast nil)
(setp SOAPSTONE south FLOE11)
(setp SOAPSTONE southwest nil)
(setp SOAPSTONE west FLOE19)
(setp SOAPSTONE northwest nil)
(setp SOAPSTONE up nil)
(setp SOAPSTONE down nil)

(setp GARAGE $LDESC "\nGARAGE\n\nThis appears to be a two-sled garage. 
                To the west is the double garage door which is securely locked
                To the east is the door to the Workshop.\n")
(setp GARAGE $SDESC "The two-sled garage.")
(setp GARAGE $onfloor? 1)
(setp GARAGE northeast nil)
(setp GARAGE $lit? T)
(setp GARAGE east WORKSHOP)

(setp OUTSIDEWORKSHOP $LDESC "\nOUTSIDE\n\n
              You're outside of Santa's Workshop just north of the building.
              There is a soapstone walkway which leads east and west around
              the workshop and a cement path leading north.
              It's foggy and unseasonably warm out
              here.  Looks like we'll be needing Rudolph's nose tonight!")
(setp OUTSIDEWORKSHOP $SDESC "Outside the workshop again.")
(setp OUTSIDEWORKSHOP $EDESC "The fog is so dense you can only see a few metres
                              in front of your little elf nose.\n")
(setp OUTSIDEWORKSHOP $onfloor? 1)
(setp OUTSIDEWORKSHOP south WORKSHOP)
(setp OUTSIDEWORKSHOP north FLOE25)
(setp OUTSIDEWORKSHOP northeast nil)
(setp OUTSIDEWORKSHOP east FLOE22)
(setp OUTSIDEWORKSHOP southeast nil)
(setp OUTSIDEWORKSHOP southwest nil)
(setp OUTSIDEWORKSHOP west FLOE18)
(setp OUTSIDEWORKSHOP northwest nil)
(setp OUTSIDEWORKSHOP up nil)
(setp OUTSIDEWORKSHOP down nil)

(setp FLOE25 $LDESC "\nCEMENT PATH\n\nThe path continues north and goes back
                     south to the cottage.  Funny, there's no snow to shovel
                     today.  Something is definitely weird with the weather.")
(setp FLOE25 $SDESC "On the cement path.")
(setp FLOE25 $onfloor? 1)
(setp FLOE25 north FLOE24)
(setp FLOE25 northeast nil)
(setp FLOE25 east nil)
(setp FLOE25 southeast nil)
(setp FLOE25 south OUTSIDEWORKSHOP)
(setp FLOE25 southwest nil)
(setp FLOE25 west nil)
(setp FLOE25 northwest nil)

(setp FLOE24 $LDESC "\nCEMENT PATH\n\nThere is something ahead on the path
                      further north.")
(setp FLOE24 $SDESC "On the cement path.")
(setp FLOE24 $onfloor? 1)
(setp FLOE24 north FLOE23)
(setp FLOE24 northeast nil)
(setp FLOE24 east nil)
(setp FLOE24 southeast nil)
(setp FLOE24 south FLOE25)
(setp FLOE24 southwest nil)
(setp FLOE24 west nil)
(setp FLOE24 northwest nil)


(setp FLOE23 $LDESC "\nNORTHPOLE\n\nThe path ends at the North Pole.  If you
                       had a compass right now it would be pointing at your
                       toenails.")
(setp FLOE23 $SDESC "Back at the North Pole.")
(setp FLOE23 $onfloor? 1)
(setp FLOE23 north nil)
(setp FLOE23 northeast nil)
(setp FLOE23 east nil)
(setp FLOE23 southeast nil)
(setp FLOE23 south FLOE24)
(setp FLOE23 southwest nil)
(setp FLOE23 west nil)
(setp FLOE23 northwest nil)

(setp FLOE22 $LDESC "\nSOAPSTONE\n\nThis part of the path leads around the
                       workshop to the south and west.")
(setp FLOE22 $SDESC "On the soapstone path, northeast of the workshop.")
(setp FLOE22 $onfloor? 1)
(setp FLOE22 north nil)
(setp FLOE22 northeast nil)
(setp FLOE22 east nil)
(setp FLOE22 southeast nil)
(setp FLOE22 south FLOE21)
(setp FLOE22 southwest nil)
(setp FLOE22 west OUTSIDEWORKSHOP)
(setp FLOE22 northwest nil)

(setp FLOE21 $LDESC "\nSOAPSTONE\n\nThis part of the path leads around the
                       workshop to the north and south.")
(setp FLOE21 $SDESC "On the soapstone path, east of the workshop.")
(setp FLOE21 $onfloor? 1)
(setp FLOE21 north FLOE22)
(setp FLOE21 northeast nil)
(setp FLOE21 east nil)
(setp FLOE21 southeast nil)
(setp FLOE21 south FLOE20)
(setp FLOE21 southwest nil)
(setp FLOE21 west nil)
(setp FLOE21 northwest nil)


(setp FLOE20 $LDESC "\nSOAPSTONE\n\nThis part of the path leads around the
                       workshop to the north and west.")
(setp FLOE20 $SDESC "On the soapstone path, southeast of the workshop.")
(setp FLOE20 $onfloor? 1)
(setp FLOE20 north FLOE21)
(setp FLOE20 northeast nil)
(setp FLOE20 east nil)
(setp FLOE20 southeast nil)
(setp FLOE20 south nil)
(setp FLOE20 southwest nil)
(setp FLOE20 west SOAPSTONE)
(setp FLOE20 northwest nil)

(setp FLOE19 $LDESC "\nSOAPSTONE\n\nThis part of the path leads around the
                       workshop to the north and east.")
(setp FLOE19 $SDESC "On the soapstone path, southwest of the workshop.")
(setp FLOE19 $onfloor? 1)
(setp FLOE19 north FLOE17)
(setp FLOE19 northeast nil)
(setp FLOE19 east SOAPSTONE)
(setp FLOE19 southeast nil)
(setp FLOE19 south nil)
(setp FLOE19 southwest nil)
(setp FLOE19 west nil)
(setp FLOE19 northwest nil)

(setp FLOE18 $LDESC "\nSOAPSTONE\n\nThis part of the path leads around the
                       workshop to the south and east.")
(setp FLOE18 $SDESC "On the soapstone path, northwest of the workshop.")
(setp FLOE18 $onfloor? 1)
(setp FLOE18 north nil)
(setp FLOE18 northeast nil)
(setp FLOE18 east OUTSIDEWORKSHOP)
(setp FLOE18 southeast nil)
(setp FLOE18 south FLOE17)
(setp FLOE18 southwest nil)
(setp FLOE18 west nil)
(setp FLOE18 northwest nil)

(setp FLOE17 $LDESC "\nSOAPSTONE\n\nThis part of the path leads around the
                       workshop to the south and north.  You are outside
                       the garage with the reindeer runway to the west.")
(setp FLOE17 $SDESC "On the soapstone path, west of the workshop and the
                       garage.")
(setp FLOE17 $onfloor? 1)
(setp FLOE17 north FLOE18)
(setp FLOE17 northeast nil)
(setp FLOE17 east nil)
(setp FLOE17 southeast nil)
(setp FLOE17 south FLOE19)
(setp FLOE17 southwest nil)
(setp FLOE17 west FLOE16)
(setp FLOE17 northwest nil)

(setp FLOE16 $LDESC "\nRUNWAY\n\nThe runway is normally a sheet of smooth
                       ice, but these warm temperatures have turned it into
                       a slushway.  There is no way that Santa could get the
                       sleigh up to takeoff speed in this mess.  The runway
                       continues to the west.  The garage is east and the
                       reindeer barn is due north.")
(setp FLOE16 $SDESC "On the runway.")
(setp FLOE16 $onfloor? 1)
(setp FLOE16 north FLOE13)
(setp FLOE16 northeast nil)
(setp FLOE16 east FLOE17)
(setp FLOE16 southeast nil)
(setp FLOE16 south nil)
(setp FLOE16 southwest nil)
(setp FLOE16 west FLOE15)
(setp FLOE16 northwest nil)

(setp FLOE15 $LDESC "\nRUNWAY\n\nYou're about halfway down the very long
                       runway.  Looking east and west makes you tired at
                       just the thought of walking to either end.")
(setp FLOE15 $SDESC "On the runway.")
(setp FLOE15 $onfloor? 1)
(setp FLOE15 north nil)
(setp FLOE15 northeast nil)
(setp FLOE15 east FLOE16)
(setp FLOE15 southeast nil)
(setp FLOE15 south nil)
(setp FLOE15 southwest nil)
(setp FLOE15 west FLOE14)
(setp FLOE15 northwest nil)

(setp FLOE14 $LDESC "\nRUNWAY\n\nYou're finally at the west end of the
                       runway.  The east end has disappeared from sight as
                       the fog keeps getting thicker and the temperature
                       continues to gradually warm.  The snow is melting
                       all around, but there might just be enough left to
                       make a snowman.  Nobody's looking.  Go ahead!")
(setp FLOE14 $SDESC "On the runway.")
(setp FLOE14 $onfloor? 1)
(setp FLOE14 north nil)
(setp FLOE14 northeast nil)
(setp FLOE14 east FLOE15)
(setp FLOE14 southeast nil)
(setp FLOE14 south nil)
(setp FLOE14 southwest nil)
(setp FLOE14 west nil)
(setp FLOE14 northwest nil)

(setp FLOE13 $LDESC "\nREINDEER BARN\n\nEven with your lantern, you have
                     trouble seeing in here.  It looks like an ordinary barn
                     except that there is no straw, pitchforks, milking
                     machines or shovels to be found.  The barn is completely
                     empty.  The atmosphere in here is unusually 'thick'.")
(setp FLOE13 $SDESC "In the reindeer barn.")
(setp FLOE13 $EDESC "Examining the corners of the barn closely, you find
                     absolutely nothing that you didn't see when you first
                     walked into the barn, but the pungent odor which pervades
                     the air in here shocks you into a new level of awareness.
                     Odd that you didn't notice the enormous set of double
                     doors leading northeast into the corral.\n")
(setp FLOE13 $onfloor? 1)
(setp FLOE13 $lit? nil)
(setp FLOE13 north nil)
(setp FLOE13 northeast FLOE12)
(setp FLOE13 east nil)
(setp FLOE13 southeast nil)
(setp FLOE13 south FLOE16)
(setp FLOE13 southwest nil)
(setp FLOE13 west nil)
(setp FLOE13 northwest nil)

(setp FLOE12 $LDESC "\nCORRAL\n\nWhew!  If you thought it smelled bad in the
                     barn...  by the smell of things, there's been a large
                     herd of reindeer here recently.  Very recently!!!")
(setp FLOE12 $SDESC "In the reindeer corral.")
(setp FLOE12 $onfloor? 1)
(setp FLOE12 north nil)
(setp FLOE12 northeast nil)
(setp FLOE12 east nil)
(setp FLOE12 southeast nil)
(setp FLOE12 south FLOE13)
(setp FLOE12 southwest nil)
(setp FLOE12 west nil)
(setp FLOE12 northwest nil)

(setp FLOE11 $LDESC "\nOUTSIDE COTTAGE\n\nThe sight of the cottage warms your
                     heart.  It looks positively, absolutely edible.  The door
                     is delicately decorated with swirling patterns of icing
                     and those little candies that look and taste like ball
                     bearings.  Oddly, the front door is open.")
(setp FLOE11 $SDESC "Outside Santa's cottage.")
(setp FLOE11 $onfloor? 1)
(setp FLOE11 north SOAPSTONE)
(setp FLOE11 northeast nil)
(setp FLOE11 east nil)
(setp FLOE11 southeast nil)
(setp FLOE11 south FLOE10)
(setp FLOE11 southwest nil)
(setp FLOE11 west nil)
(setp FLOE11 northwest nil)

(setp FLOE10 $LDESC "\nCOTTAGE\n\nWow, talk about chaos!  Santa Claus is here
                     rushing around trying to get ready for the big trip
                     tonight.  You would think that with a whole year to get
                     ready and with all the practice he's had that he'd be
                     leisurely sitting by the fire with his feet up, collecting
                     his thoughts before he heads out.  Not so.  Everything
                     is in a state of uproar (and the weather isn't helping
                     any either.)  Santa is trying to decide between his usual
                     red suit or a yellow rain slicker.  He rushes over every
                     once in a while and buzzes himself another quick drink
                     in the blender.  He's lost his shiny black belt and is
                     holding his pants up with one hand while trying to do
                     twelve things at once with the other.  He glances up at
                     you as you walk in and says 'Say, you don't have anything
                     Santa could use to hold up his pants do you?'")
(setp FLOE10 $SDESC "Inside Santa's chaotic cottage.\nSanta is here.\n")
(setp FLOE10 $onfloor? 1)
(setp FLOE10 north FLOE11)
(setp FLOE10 northeast nil)
(setp FLOE10 east nil)
(setp FLOE10 southeast nil)
(setp FLOE10 south nil)
(setp FLOE10 southwest nil)
(setp FLOE10 west nil)
(setp FLOE10 northwest nil)

)
