/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */

/*
**  This a screen management library borrowed with permission from the
**  Elm mail system (a great mailer--I highly recommend it!).
**
**  I've hacked this library to only provide what I need.
**
**  Original copyright follows:
*/
/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 * 			Copyright (c) 1986 Dave Taylor
 ******************************************************************************/

#ifndef M_XENIX
#include <sys/termio.h>
#endif

#include <stdio.h>
#include <curses.h>
#include <ctype.h>

#define DEFAULT_term_lines	24
#define DEFAULT_COLUMNS	80
#define TTYIN	0


#define		VERY_LONG_STRING	2500

int term_lines = DEFAULT_term_lines - 1;
int term_cols  = DEFAULT_COLUMNS;
extern char escape_char;

#ifdef SHORTNAMES
# define _cleartoeoln	_clrtoeoln
# define _cleartoeos	_clr2eos
#endif

#ifndef BSD
struct termio raw_tty, 
              orig_tty;
#else
#define TCGETA	TIOCGETP
#define TCSETAW	TIOCSETP

struct sgttyb raw_tty,
	      orig_tty;
#endif

static int inraw = 0;                  /* are we IN rawmode?    */


static int _memory_locked = 0;		/* are we IN memlock??   */

static int _intransmit;			/* are we transmitting keys? */

static
char *_clearscreen, *_moveto, *_cleartoeoln, *_cleartoeos,
	*_setinverse, *_clearinverse;


static
int _lines,_columns;

static char _terminal[1024];              /* Storage for terminal entry */
static char _capabilities[1024];           /* String for cursor motion */

static char *ptr = _capabilities;	/* for buffering         */

int    outchar();			/* char output for tputs */
char  *tgetstr(),     		       /* Get termcap capability */
      *tgoto();				/* and the goto stuff    */

InitScreen()
{
int  tgetent(),      /* get termcap entry */
     err;
char termname[40];
char *strcpy(), *getenv();
	
	if (getenv("TERM") == NULL) {
		fprintf(stderr,
		  "TERM variable not set; Screen capabilities required\n");
		return(FALSE);
	}
	if (strcpy(termname, getenv("TERM")) == NULL) {
		fprintf(stderr,"Can't get TERM variable\n");
		return(FALSE);
	}
	if ((err = tgetent(_terminal, termname)) != 1) {
		fprintf(stderr,"Can't get entry for TERM\n");
		return(FALSE);
	}

	/* load in all those pesky values */
	_clearscreen       = tgetstr("cl", &ptr);
	_moveto            = tgetstr("cm", &ptr);
	_cleartoeoln       = tgetstr("ce", &ptr);
	_cleartoeos        = tgetstr("cd", &ptr);
	_setinverse        = tgetstr("so", &ptr);
	_clearinverse      = tgetstr("se", &ptr);
	_lines	      	   = tgetnum("li");
	_columns	   = tgetnum("co");

	if (!_clearscreen) {
		fprintf(stderr,
			"Terminal must have clearscreen (cl) capability\n");
		return(FALSE);
	}
	if (!_moveto) {
		fprintf(stderr,
			"Terminal must have cursor motion (cm)\n");
		return(FALSE);
	}
	if (!_cleartoeoln) {
		fprintf(stderr,
			"Terminal must have clear to end-of-line (ce)\n");
		return(FALSE);
	}
	if (!_cleartoeos) {
		fprintf(stderr,
			"Terminal must have clear to end-of-screen (cd)\n");
		return(FALSE);
	}
	if (_lines == -1)
		_lines = DEFAULT_term_lines;
	if (_columns == -1)
		_columns = DEFAULT_COLUMNS;
	return(TRUE);
}

ScreenSize(lines, columns)
int *lines, *columns;
{
	/** returns the number of lines and columns on the display. **/

	if (_lines == 0) _lines = DEFAULT_term_lines;
	if (_columns == 0) _columns = DEFAULT_COLUMNS;

	*lines = _lines - 1;		/* assume index from zero*/
	*columns = _columns;		/* assume index from one */
}

ClearScreen()
{
	/* clear the screen: returns -1 if not capable */

	tputs(_clearscreen, 1, outchar);
	fflush(stdout);      /* clear the output buffer */
}

MoveCursor(row, col)
int row, col;
{
	/** move cursor to the specified row column on the screen.
            0,0 is the top left! **/

	char *stuff, *tgoto();

	stuff = tgoto(_moveto, col, row);
	tputs(stuff, 1, outchar);
/*	fflush(stdout);	*/
}

CleartoEOLN()
{
	/** clear to end of line **/

	tputs(_cleartoeoln, 1, outchar);
	fflush(stdout);  /* clear the output buffer */
}

CleartoEOS()
{
	/** clear to end of screen **/

	tputs(_cleartoeos, 1, outchar);
	fflush(stdout);  /* clear the output buffer */
}

Raw(state)
int state;
{
	/** state is either TRUE or FALSE, as indicated by call **/

	if (state == FALSE && inraw) {
	  (void) ioctl(TTYIN, TCSETAW, &orig_tty);
	  inraw = 0;
	}
	else if (state == TRUE && ! inraw) {

	  (void) ioctl(TTYIN, TCGETA, &orig_tty);	/** current setting **/

	  (void) ioctl(TTYIN, TCGETA, &raw_tty);    /** again! **/
#ifdef BSD
/*	  raw_tty.sg_flags &= ~(ECHO | CRMOD);	/* echo off */
	  raw_tty.sg_flags &= ~ECHO;		/* echo off */
	  raw_tty.sg_flags |= CBREAK;	/* raw on    */
#else
	  raw_tty.c_lflag &= ~(ICANON | ECHO);	/* noecho raw mode        */

	  raw_tty.c_cc[VMIN] = '\01';	/* minimum # of chars to queue    */
	  raw_tty.c_cc[VTIME] = '\0';	/* minimum time to wait for input */

#endif
	  raw_tty.c_cc[VINTR]= escape_char;
	  (void) ioctl(TTYIN, TCSETAW, &raw_tty);
	  inraw = 1;
	}
}

int
ReadCh()
{
	/** read a character with Raw mode set! **/

	register int result;
	char ch;
	result = read(0, &ch, 1);
        return((result <= 0 ) ? EOF : ch);
}


outchar(c)
char c;
{
	/** output the given character.  From tputs... **/
	/** Note: this CANNOT be a macro!              **/

	putc(c, stdout);
}


#if 0
static int inverse = FALSE;

SetInverse() {

	if (!inverse) {
		StartInverse();
		inverse = TRUE;
	}
}

SetNormal() {

	if (inverse) {
		EndInverse();
		inverse = FALSE;
	}
}
#endif


StartInverse()
{
	/** set inverse video mode **/

	if (!_setinverse)
		return(-1);

	tputs(_setinverse, 1, outchar);
/*	fflush(stdout);	*/
	return(0);
}


EndInverse()
{
	/** compliment of startinverse **/

	if (!_clearinverse)
		return(-1);

	tputs(_clearinverse, 1, outchar);
/*	fflush(stdout);	*/
	return(0);
}

