/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */



#include	<stdio.h>
#include	<setjmp.h>
#include	<signal.h>
#include	"a2.h"
#include	"cli.h"


FILE *logging_fp = NULL;
long	breakpoint = -1;
long	trace_lo = -1;
long	trace_hi;
int	in_cli;

unsigned short lpoint;		/* point where dissassembly occurs */
long phantom_location = -1;
int map_to_upper = 1;
jmp_buf jb;

cli_catch() {
	signal(SIGINT,cli_catch);
	printf("\n");
	longjmp(jb,1);
}

cli() 
{
	char	foo[200];

	restore_term();
	MoveCursor(term_lines, 0);
	status(stdout);
	in_cli = TRUE;
	lpoint = Pc;
	signal(SIGINT, cli_catch);
	setjmp(jb);
	do {
		printf(">>>");
		if (fgets(foo, 200, stdin) == NULL) {
			printf("\n");
			exit(0);
		}
		foo[strlen(foo)-1] = '\0';
		if (parse(first_tbl, foo)) {
			running = FALSE;
			tracing = FALSE;
			return;			/* single step; no redraw */
		}
	} while (in_cli);

	set_term();
	redraw_screen();
	if (breakpoint != -1 || trace_lo != -1) {
		tracing = TRUE;
		running = FALSE;
	} else {
		tracing = FALSE;
		running = TRUE;
	}
}


status(fp)
FILE *fp;
{

	diss(Pc, fp);
	flags(fp);
}


