; LIBASM.ASM -- Assembly Language DOS Interface Routines
;	Turbo C/ANSI Version, assumes Small model (64K code, separate 64K data)
;	Written April 1991 by Craig A. Finseth

; -------------------- Constants and Macros --------------------

TRUE	equ	255
FALSE	equ	0
NUL	equ	0
BEL	equ	7
CR	equ	13
LF	equ	10
SPACE	equ	32

; C function call stack layout -- SI, DI, BP, and SP must be preserved

old_bp	equ	0
ret_addr equ	2
arg1	equ	4
arg2	equ	6
arg3	equ	8
arg4	equ	10
arg5	equ	12
arg6	equ	14
arg7	equ	16
arg8	equ	18

; "safe" stack layout -- BP is not saved

sret_addr equ	0
sarg1	equ	2
sarg2	equ	4
sarg3	equ	6
sarg4	equ	8
sarg5	equ	10
sarg6	equ	12
sarg7	equ	14
sarg8	equ	16

clear	macro	x
	xor		x,x
	endm

zero	macro	x
	xor		x,x
	endm

testz	macro	x
	or		x,x
	endm

; -------------------- Data Segment --------------------

_DATA	segment	word public 'DATA'	; initialized data

	extrn	_t_attrib : byte	; video attribute to use

iscolor	db	FALSE
wastext	db	TRUE
_DATA	ends

_BSS	segment	word public 'BSS'		; uninitialized data
oldmode	db	?
cursor_def dw	?
_BSS	ends

DGROUP	group	_DATA, _BSS
	assume	ds:DGROUP

; -------------------- Code Segment --------------------

_TEXT	segment	byte public 'CODE'
	assume	cs:_TEXT

	public	_BlockAlloc, _BlockFree, _BlockGet, _BlockPut
	public	_c_service
	public	_JFiniA, _JInitA, _JGetKeyA, _JIsKeyA, _JLightOff, _JLightOn,
	public	_JPushKeyA
	public	_lseeka, _PSystem
	public	_VidInit, _VidFini, _VidBell, _VidChar, _VidClear, _VidCursor
	public	_VidCurOff, _VidCurOn

; ------------------------------------------------------------

; Allocate a block of memory and return the starting paragraph number
; or zero.

;	unsigned
;	BlockAlloc(unsigned para)
;	C Callable

_BlockAlloc proc near
	mov	BX,SP
	mov	BX,[BX] + sarg1
	mov	DX,BX		; save a copy
	mov	AH,48H
	clc
	int	21H
	jc	alloc_no
	cmp	BX,DX
	jne	alloc_no
	ret
alloc_no: zero	AX
	ret
_BlockAlloc endp


; ------------------------------------------------------------

; Free a block of memory.

;	void
;	BlockFree(unsigned para)
;	C Callable

_BlockFree proc	near
	mov	BX,SP
	mov	BX,[BX] + sarg1
	mov	ES,BX
	mov	AH,49H
	int	21H
	ret
_BlockFree endp


; ------------------------------------------------------------

; Get a block of data from high memory.

;	void
;	BlockGet(char *to, char huge *from, int len)
;	C Callable

;	do	{
;		*to++ = *from++;
;		} while (--len > 0);

_BlockGet proc	near
	push	BP
	mov	BP,SP
	push	DI
	push	SI
	push	DS
	push	ES

	mov	DI,[BP] + arg1		; to
	mov	AX,DS			;  & segment
	mov	ES,AX

	mov	SI,[BP] + arg2		; from
	mov	AX,[BP] + arg3		;  & segment
	mov	DS,AX

	mov	CX,[BP] + arg4		; CX is len
	cld

;mloop:	mov	AL,DS:[SI]		; *from++
;	inc	SI
;	mov	ES:[DI],AL		; *to++ =
;	inc	DI
;	loop	mloop			; while --len>0

	rep	movsb

	pop	ES
	pop	DS
	pop	SI
	pop	DI
	pop	BP
	ret
_BlockGet endp


; ------------------------------------------------------------

; Put a block of data into high memory.

;	void
;	BlockPut(char huge *to, char *from, int len)
;	C Callable

;	do	{
;		*to++ = *from++;
;		} while (--len > 0);

_BlockPut proc	near
	push	BP
	mov	BP,SP
	push	DI
	push	SI
	push	ES

	mov	DI,[BP] + arg1		; to
	mov	AX,[BP] + arg2		;  & segment
	mov	ES,AX

	mov	SI,[BP] + arg3		; from

	mov	CX,[BP] + arg4		; CX is len
	cld

;mloop:	mov	AL,DS:[SI]		; *from++
;	inc	SI
;	mov	ES:[DI],AL		; *to++ =
;	inc	DI
;	loop	mloop			; while --len>0

	rep	movsb

	pop	ES
	pop	SI
	pop	DI
	pop	BP
	ret
_BlockPut endp


; ------------------------------------------------------------

; Link to Jaguar special services.

_c_service proc near
	push	BP
	mov	BP,SP
	xchg	DI,[BP+4]
	pop	BP
	int	60H
	ret
_c_service endp


; ------------------------------------------------------------

; Terminate any special HP95LX processing.

;	void
;	JFiniA(void)
;	C Callable

_JFiniA	proc	near
	mov	AH,4AH		; turn on serial port power
	mov	AL,1
	int	15H
	ret
_JFiniA	endp


; ------------------------------------------------------------

; Initialize any special HP95LX processing.

;	void
;	JInitA(void)
;	C Callable

_JInitA	proc	near
	mov	AH,4AH		; turn off serial port power
	zero	AL
	int	15H
	ret
_JInitA	endp


; ------------------------------------------------------------

; Return the next key.  HP95LX specific.

;	int
;	JGetKeyA(void)
;	C Callable

_JGetKeyA proc	near
	mov	AH,10H
	int	16H
	ret
_JGetKeyA endp


; ------------------------------------------------------------

; Return non-zero if a key is available or zero if not.  HP95LX specific.

;	int
;	JIsKeyA(void)
;	C Callable

_JIsKeyA proc	near
	mov	AH,11H
	int	16H
	jz	jik_none
	mov	AX,1
	ret
jik_none: zero	AX
	ret
_JIsKeyA endp


; ------------------------------------------------------------

; Turn off the light sleep mode when checking the key press status.
; HP95LX specific.

;	void
;	JLightOff(void)
;	C Callable

_JLightOff proc	near
	mov	AX,4E00H
	int	15H
	ret
_JLightOff endp


; ------------------------------------------------------------

; Turn on the light sleep mode when checking the key press status.
; HP95LX specific.

;	void
;	JLightOn(void)
;	C Callable

_JLightOn proc	near
	mov	AX,4E01H
	int	15H
	ret
_JLightOn endp


; ------------------------------------------------------------

; Push the specified key into the input buffer.  HP95LX specific.

;	void
;	JPushKeyA(int key)
;	C Callable

_JPushKeyA proc	near
	push	BP
	mov	BP,SP
	mov	CX,[BP] + arg1
	mov	AH,05H
	int	16H
	pop	BP
	ret
_JPushKeyA endp


; ------------------------------------------------------------

;	long
;	lseeka(int fd, long dist, int mode)
;	C callable

_lseeka	proc		near
		mov		BX,SP
		mov		DX,[BX] + sarg2
		mov		CX,[BX] + sarg3
		mov		AX,[BX] + sarg4
		mov		AH,42H
		mov		BX,[BX] + sarg1
		int		21H
		jnc		lseek_a
		mov		DX,-1
		neg		AX
lseek_a:	ret
_lseeka	endp


; ------------------------------------------------------------

;	int
;	PSystem(int AH, ...) /* int DX, int CX, int BX, int AL, int SI, int DI */
;	C callable
;	Note:  if the carry flag is set, the return code is negated

_PSystem proc	near
	push	BP
	mov	BP,SP
	push	DI
	push	SI

	mov	AX,[BP] + arg5		; AL
	mov	BX,[BP] + arg1		; AH
	mov	AH,BL
	mov	DX,[BP] + arg2
	mov	CX,[BP] + arg3
	mov	BX,[BP] + arg4
	mov	SI,[BP] + arg6
	mov	DI,[BP] + arg7

	clc
	int	21H
	jnc	psyst_ok
	neg	AX
	pop	SI
	pop	DI
	pop	BP
	ret

psyst_ok: and	AX,7FFFH
	pop	SI
	pop	DI
	pop	BP
	ret
_PSystem endp


; ------------------------------------------------------------

; Initialize the screen to 80x25 text mode.  Used (needed) for direct
; memory output only.

;	int
;	VidInit(void)
;	C callable

_VidInit proc	near
	int	11H			; equipment check
	and	AL,30H
	cmp	AL,30H
	jz	vidi_mret		; monochome display

	mov	iscolor,TRUE

	mov	AH,0FH		; get current video mode
	int	10H
	cmp	AL,2			; 80x25 BW
	jz	vidi_cret
	cmp	AL,3			; 80x25 color
	jz	vidi_cret

	mov	oldmode,AL	; save old mode
	mov	wastext,FALSE
	mov	AX,0002H		; set to mode 2, 80x25 BW
	int	10H

vidi_cret:
	mov	CX,0007H
	mov	cursor_def,CX

	mov	AX,0B800H	; color base
	ret

vidi_mret:
	mov	CX,000CH
	mov	cursor_def,CX

	mov	AX,0B000H	; monochrome base
	ret
_VidInit endp


; ------------------------------------------------------------

; Restore the screen.  Used (needed) for direct memory output only.

;	void
;	VidFini(void)
;	C callable

_VidFini proc	near
	test	iscolor,0FFH
	jz	vidf_ret
	test	wastext,0FFH
	jnz	vidf_ret

	mov	AH,0			; put old mode back
	mov	AL,oldmode
	int	10H
vidf_ret: ret
_VidFini endp


; ------------------------------------------------------------

; Ring the bell.  Usable for both BIOS and direct memory output.

;	void
;	VidBell(void)
;	C callable

_VidBell proc	near
	mov	AL,BEL
	zero	BL
	mov	AH,14		; write TTY
	int	10H
	ret
_VidBell endp


; ------------------------------------------------------------

; Write the specified character to the current cursor location. 
; Usable for BIOS output only.

;	void
;	VidChar(char char)
;	C callable

_VidChar proc	near
	push	BP
	mov	BP,SP

	mov	AL,[BP] + arg1
	zero	BH			; page
	mov	BL,_t_attrib
	mov	CX,1			; repeat count

	mov	AH,9			; write char and attribute
	int	10H
	pop	BP
	ret
_VidChar endp


; ------------------------------------------------------------

; Clear the next COUNT characters.  Usable for BIOS output only.

;	void
;	VidClear(int count)
;	C callable

_VidClear proc	near
	push	BP
	mov	BP,SP

	mov	AL,SPACE
	zero	BH			; page
	mov	BL,_t_attrib
	mov	CX,[BP] + arg1		; repeat count: # of char to clear
	test	CX,0FFFFH
	jz	vidc_ret

	mov	AH,9			; write char and attribute
	int	10H
vidc_ret:
	pop	BP
	ret
_VidClear endp


; ------------------------------------------------------------

; Set the cursor to the specified row/column.  Usable for both BIOS
; and direct memory output.

;	void
;	VidCursor(int row, int col)
;	C callable

_VidCursor proc	near
	push	BP
	mov	BP,SP

	mov	CL,[BP] + arg1
	mov	DL,[BP] + arg2		; col
	mov	DH,CL			; row

	zero	BH			; page
	mov	AH,2			; set cursor position
	int	10H
	pop	BP
	ret
_VidCursor endp


; ------------------------------------------------------------

; Tur the cursor off.

;	void
;	VidCurOff(void)
;	C callable

_VidCurOff proc near
	mov	AH,1		; set cursor size
	mov	CX,0FF00H
	int	10H
	ret
_VidCurOff endp


; ------------------------------------------------------------

; Set the cursor to a block cursor.

;	void
;	VidCurOn(void)
;	C callable

_VidCurOn proc near
	mov	AH,1		; set cursor size
	mov	CX,cursor_def
	int	10H
	ret
_VidCurOn endp


_TEXT	ends

		end

; end of LIBASM.ASM -- Assembly Language DOS Interface Routines
