/* FGENLIB.H -- Main General Header File

	Written July 1988 by Craig Finseth
*/

	/* operating system -- define only one */

#define VARARGS		1	/* supports varargs */

/* #define BERK43		1 */
#define SUNOS4		1
/* #define SUNOS3		1 */
/* #define UNICOS		1 */
/* #define UNIXV		1 */
/* #define MSDOS		1 */

#if defined(SUNOS4)
#define SUNOS3		1
#endif

#if defined(SUNOS3)
#define BERK43		1
#endif

#if defined(UNICOS)
#define UNIXV		1
#endif

/* -------------------- General Includes -------------------- */

#if !defined(MSDOS)
#include <sys/types.h>
#include <sys/file.h>
#include <time.h>
time_t time();
struct tm *localtime();
#if defined(UNIXV)
#include <fcntl.h>
#include <malloc.h>
#include <unistd.h>
#endif
#endif
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#if defined(VARARGS)
#if defined(__STDC__)
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#endif

#if defined(UNIXV)
#define L_SET			0
#endif

/* -------------------- Configuration Constants -------------------- */

	/* types */

#define FLAG		char

	/* constants */

#ifndef NULL
#define NULL		((void *) 0)
#endif

#define TRUE		1
#define FALSE		0

#if !defined(MSDOS)
#define MAXINT		2147483647
#define MININT		(-2147483648)
#define MAXUNS		4294967295
#endif

#define NUL		'\0'
#define BEL		'\7'
#define BS		'\10'
#define TAB		'\11'
#define LF		'\12'
#define VT		'\13'
#define FF		'\14'
#define CR		'\15'
#define SP		' '
#define DEL		'\177'
#define NL		'\n'
#define ESC		'\33'

#if defined(MSDOS)
#define NEWLINE		"\r\n"
#else
#define NEWLINE		"\n"
#endif

#if defined(MSDOS)
#define BUFFSIZE	1024		/* good buffer size to use */
#define FNAMEMAX	81		/* size of file name */
#define TOKENMAX	257		/* size of a general token */
#define INPMAX		256		/* size of user input buffer */
#else
#define BUFFSIZE	(24 * 1024)	/* good buffer size to use */
#define FNAMEMAX	1025		/* size of file name */
#define TOKENMAX	1025		/* size of a general token */
#define INPMAX		256		/* size of user input buffer */
#endif

/* -------------------- Routines -------------------- */

	/* LIB.C */

#if defined(MSDOS)
#define close(fd)		PSystem(0x3E,0,0,fd)
#define creat(name)		PSystem(0x3C,name,0)
#define open(name,mode,perm)	PSystem(0x3D,name,0,0,mode)
#define lseek(fd,dist,mode)	lseeka(fd,dist,mode)
#define read(fd,buff,amt)	PSystem(0x3F,buff,amt,fd)
#define rename(old,new)		PSystem(0x56,old,0,0,0,0,new)
#define tell(fd)		tellc(fd)
#define unlink(name)		PSystem(0x41,name)
#define write(fd,buff,amt)	PSystem(0x40,buff,amt,fd)
#endif

#if defined(UNIXV)
#define memmove(d,s,l)	memcpy(d,s,l)	/* ANSI C compatibility */
#endif
#ifdef BERK43
#define memmove(d,s,l)	bcopy(s,d,l)	/* ANSI C compatibility */
#endif
#define xstrncpy(d,s)		{ strncpy((d),(s),sizeof(d)); (d)[sizeof(d)-1]=NUL; }

int max();			/* int a, int b */
int min();			/* int a, int b */
char *sindex();			/* char *str, char chr */
FLAG SToN();			/* char *str, int *n, int base */
FLAG strequ();			/* char *a, char *b */
FLAG strnequ();			/* char *a, char *b, int len */
FLAG xisalnum();		/* int c */
FLAG xisalpha();		/* int c */
FLAG xisdigit();		/* int c */
FLAG xisgray();			/* char c */
FLAG xislower();		/* int c */
FLAG xisupper();		/* int c */
void xstrcpy();			/* char *dest, char *src */
int xtolower();			/* int c */
int xtoupper();			/* int c */

	/* LIBASM.ASM */

#if defined(MSDOS)
unsigned BlockAlloc(unsigned para);
void BlockFree(unsigned para);
void BlockGet(char *to, char huge *from, int len);
void BlockPut(char huge *to, char *from, int len);
void JFiniA(void);
void JInitA(void);
int JGetKeyA(void);
int JIsKeyA(void);
void JLightOff(void);
void JLightOn(void);
void JPushKeyA(int key);
long lseeka(int fd, long dist, int mode);
int PSystem(int AH, ...); /* int DX, int CX, int BX, int AL, int SI, int DI */
int VidInit(void);
void VidFini(void);
void VidBell(void);
void VidChar(char chr);
void VidClear(int count);
void VidCursor(int row, int col);
void VidCurOff(void);
void VidCurOn(void);
#endif

	/* XPRINTF.C */

void xprintf();			/* char *fmt, ... */
void xdprintf();		/* int fd, char *fmt, ... */
void xeprintf();		/* char *fmt, ... */
void xsprintf();		/* char *string, char *fmt, ... */

/* end of FGENLIB.H -- Main General Header File */
