/* SMJAGUAR.C -- HP95LX (Jaguar) Commands and Support, System-Manager Compliant

	Written March 1992 by Craig A. Finseth
	Copyright 1992 by Craig A. Finseth

NOTE: This entire file is only compiled and linked on IBM PC (MSDOS)
systems and for the system-manager compliant version.  Therefore, no
#ifdef's are required. */

#include "freyja.h"

/* The following are excerpts from files Copyright 1990 by
Hewlett-Packard and Copyright 1990 by Lotus Development Corporation. */

/* ============================================================ */
/* #include "headers/mdit.h" */

typedef struct {
	char    far *m_buffer;    /*  user-supplied edit buffer  */
	int     m_length;         /*  length of buffer  */
	int     m_pos;            /*  current cursor position  */
	int     m_row, m_col;     /*  location of edit area  */
	int     m_nrows, m_ncols; /*  dimensions of edit area  */
	int	m_yoff,m_disprows;/*  current top row, number of rows displayable */
	char    m_ccol;           /*  cursor column  */
	char    m_modified;       /*  1 -> buffer has been modified  */
        char    m_xoff;           /*  1st disp. col (for ticker fields only)*/
        char    wrapflag;         /*  1 -> wordwrap enabled,-1 ticker field */
	int     far *m_line;      /*  pointer to array used for line starts */
				  /*     must be at least m_nrows+1 long */
	char 	markon;		  /* currenty marking? */
	char	spec_flag;
	int	markst;		  /* offset of start of mark, inclusive */
	int	markend;	  /* offset of end of mark, inclusive */
        int     m_dispcols;       /*  displayable columns */
} MDITDATA;


/* ============================================================ */
/* #include "headers/edit.h" */

typedef struct {
	int edit_length; 	/* current length of the edit buffer */
	char first_time;      	/* flag for special processing on first char */
	char spec_flags;	/* bit 0 is tab handling */
     	int prompt_window;      /* whether this belongs to the prompt window */
	char far *message_line; /* the top line message for prompt */
	int message_line_length;/* length of same */
	char far *prompt_line;  /* second line of prompt window */
	int prompt_line_length; /* length of same */
	char edit_buffer[80];   /* work space for the buffer */
	int  line_array[2];	/* line array needed by mdit */
	MDITDATA mdit;          /* multi-line edit structure */
	int e_dispcols;
} EDITDATA;

/* ============================================================ */
/* #include "headers/event.h" */

enum event_kind {
	E_NONE,		/* no events available */
	E_KEY,		/* keystroke available */
	E_BREAK,	/* CNTRL_BREAK encountered */
	E_ACTIV,	/* reactivation event, always follows E_DEACT */
	E_DEACT,	/* about to sleep, next event request is delayed */
	E_TERM,		/* forced closure of application */
	E_BRIDGE,	/* 123 bridge service request, only ret. to 123 */
	E_GROW,	 	/* request to 123 to grow */
	E_SHRINK,	/* request to 123 to shrink */
	E_ALARM_EXP,	/* application's alarm has expired */
	E_ALARM_DAY,	/* daily chance to set an alarm */
	E_TIMECHANGE	/* system date or time has been changed */
};

typedef struct {
	enum event_kind kind;
	unsigned int data;	/* ASCII (CP 850) translation of keystroke */
	unsigned char scan;	/* scan code from BIOS */
	unsigned char shifts;	/* shifts register, when function returns */
				/* not necessarily when key struck */
	unsigned int lics;	/* LICS translation of keystroke */
	unsigned char fkey_num;	/* function key number for 123 only */
	void far * bridge;	/* pointer to 123 bridge data structure */
} EVENT;


/* ============================================================ */
/* #include "headers/fmenu.h" */

/* define return codes */

#define	RET_BADFILE		-5
#define	RET_BADDIR		-4
#define	RET_BADDRIVE	-3
#define	RET_UNKNOWN		-2
#define	RET_BAD			-1
#define	RET_OK			0
#define	RET_REDISPLAY	1
#define	RET_ACCEPT		2
#define	RET_ABORT		3

/* file info structures created in FM_BUFFER */
typedef	struct {
	char fi_attr;				/*  file attribute  */
	int fi_time;				/*  time modified  */
     	int fi_date;				/*  date modified  */
	long fi_size;  				/*  file length  */
     	char fi_name[13];			/*  file name  */
} FILEINFO;                                  

/* define the menu structure */
typedef struct {
	char far *fm_path;		/* base directory name C:\DATA\ */
	char far *fm_pattern;		/* file pattern, e.g.  *.WK1    */
	FILEINFO far *fm_buffer;	/* workspace  for file list (hold finfos) */
	int fm_buf_size;		/* size of the buffer in bytes */
     	int fm_startline,fm_startcol;	/* starting row,col */
	int fm_numlines, fm_numcols;	/* number of lines and columns */
	int fm_filesperline;		/* nuumber of files displayed across */
/* -- Initted in service -- */
	int fm_firstedit;			/* 0 if first edit char, else multi line */
	int fm_filesinbuf;		/* number of files in list */
	int fm_maxfinbuf;		/* maximum number of files buffer holds */
	int fm_topfile;			/* file at top of list */
	int fm_curselect;		/* index of file to highlight */
	int fm_oldselect;		/* index of file to un-highlight */
	int fm_focus;			/* 1 = fmenu, 2 = edit */
} FMENU;


/* ============================================================ */
/*#include "headers/menu.h"*/

#define   MAX_KWDS    20
#define   MAX_MENU     3
#define   MAX_MWID     80

typedef struct {
     char menu_text [MAX_MENU][MAX_MWID];
     int menu_count;
     int menu_highlight;
     int menu_tprompt;
     char menu_line   [MAX_KWDS];
     char menu_offset [MAX_KWDS];
     char menu_length [MAX_KWDS];
     char menu_letter [MAX_KWDS];
    unsigned menu_prompt[MAX_KWDS];
     } MENUDATA;


/* ============================================================ */
/*#include "headers/settings.h"*/

#define MAX_MACRO_LEN	256
#define NAMEBUFLEN	30
#define TITLEBUFLEN	30
#define COMPANYBUFLEN	28

/*  settings */
typedef struct {
	int	Country;	/* */
	int	Volume; 	/* 1 speaker volume level 0ffh for off and 0-3 */
	int	Contrast;	/* 2 contrast level 1-5 */
	int	WeekStart;	/* 3 week starts SUNDAY or Monday */
	int	Punctuation;	/* 4 Punctuation format */
	int 	Language;	/* two character code for current language */
	int	DateFormat;	/* 6 current date format */
	int	TimeFormat;	/* 7 current time format */
	int	Sort;		/* 8 collating sequence */
	char	PicFile[80];	/* picture file name */
	char	Name_Buff[NAMEBUFLEN];	
	char	Title_Buff[TITLEBUFLEN]; 
	char	Company_Buff[COMPANYBUFLEN]; 
	int 	LanguageCount;
	int	LanguagesAvail[6];	/* MAX_LANG */
	char	LanguageMenu[66];	

	char	DateSeparator[2]; /* date separator  can be /-. */
	char	TimeSeparator[2]; /* time separator can be :., or h (for hms) */
	char	DateOrder;	/* */
	char	Time24;		/* use 24 hour time? */

	char	Currency[16];   /* currency string */
	int	CurrencyFix;   /* prefix or sufix */

	int	Keyboard;
	int	PrBaud; 	/* printer baud rate */
	int	PrDriver;	/* epson, hp, etc, by code */
	int 	PrInterface;	/* com 1, etc  */
	int	SystemRupt;		/* sysmgr interupt number - 60 default */
	int	CodePage;		/* for PC based - 437 or 850 based */
	int	ExitKeyCode;	/* for PC based - active exit key */
	int	MenuKeyCode;	/* for PC based - active menu key */
	int	CharKeyCode;	/* for PC based - active CHAR key toggle */
	int	Alarm[6];
} SETTINGS;


typedef struct {
	char	MacroFK;	   /* MacroFunctionKey Number 1-10 0 for not used */
        unsigned char MacroSize;   /* elements in the macro */
        char    CommentString[38]; /* MacroFunctionKey's Comment line */
	unsigned int MacroBody[MAX_MACRO_LEN];
} MACROHD;


/* ============================================================ */
/* #include "headers/time.h" */
typedef struct {
	int	dt_year;
	char	dt_month;
	char	dt_date;
	char	dt_day;
	char	dt_hour;
	char	dt_minute;
	char	dt_second;
	char	dt_hundreth;
} DTM;


/* ============================================================ */
/* #include "headers/interfac.h" */

#define SC_EVENT	1
#define SC_MENU 	2
#define SC_SCREEN	3
#define SC_FILE 	5
#define SC_PM		6
#define SC_CB		7
#define SC_DTIME	11
#define SC_MISC 	15

#define F_M_EVENT	(SC_EVENT * 256) + 0
#define m_event(a)	\
	c_service(F_M_EVENT,(void far *)(a) )

#define F_M_NEVENT    (SC_EVENT * 256) + 1
#define m_nevent(a)	\
	c_service(F_M_NEVENT,(void far *)(a))

#define F_M_NO_FINI	(SC_EVENT * 256) + 7
#define m_no_fini(a)	\
	c_service(F_M_NO_FINI,(void far *)(a) )



#define F_MENU_SETUP	(SC_MENU * 256) + 0
#define menu_setup(a,b,c,d,e,f,g)	\
	c_service(F_MENU_SETUP,(void far *)(a),(void far *)(b), \
		(c),(d),(void far *)(e),(f),(void far *)(g) )

#define F_MENU_DIS	(SC_MENU * 256) + 1
#define menu_dis(a)	\
	c_service(F_MENU_DIS,(void far *)(a))

#define F_MENU_ON	(SC_MENU * 256) + 2
#define menu_on(a)	\
	c_service(F_MENU_ON,(void far *)(a))

#define F_MENU_OFF	(SC_MENU * 256) + 3
#define menu_off(a)	\
	c_service(F_MENU_OFF,(void far *)(a))

#define F_MENU_KEY	(SC_MENU * 256) + 4
#define menu_key(a,b,c) \
	c_service(F_MENU_KEY,(void far *)(a),(b),(void far *)(c))

#define F_FMENU_INIT	  (SC_MENU * 256) + 5
#define fmenu_init(a,b,c,d,e)	  \
	c_service(F_FMENU_INIT,(void far *)(a),(void far *)(b),(char far *)(c),(d),(e))

#define F_FMENU_DIS	 (SC_MENU * 256) + 6
#define fmenu_dis(a,b)	  \
	c_service(F_FMENU_DIS,(void far *)(a),(void far *)(b))

#define F_FMENU_KEY	 (SC_MENU * 256) + 7
#define fmenu_key(a,b,c) \
	c_service(F_FMENU_KEY,(void far *)(a),(void far *)(b),(c))

#define F_FMENU_OFF	  (SC_MENU * 256) + 8
#define fmenu_off(a,b)	 \
	c_service(F_FMENU_OFF,(void far *)(a),(void far *)(a))



#define F_M_CLEAR	(SC_SCREEN * 256) + 1
#define m_clear(a,b,c,d)	     \
	c_service(F_M_CLEAR,a,b,c,d)



#define F_M_GET_SYSDIR	(SC_FILE * 256) + 22
#define m_get_sysdir(a) 	      \
	c_service(F_M_GET_SYSDIR,(void far *)(a))



#define F_M_INIT	(SC_PM * 256) + 0
#define m_init()	c_service(F_M_INIT)

#define F_M_FINI	(SC_PM * 256) + 1
#define m_fini()	c_service(F_M_FINI)

#define F_M_LOCK	(SC_PM * 256) + 2
#define m_lock()	c_service(F_M_LOCK)

#define F_M_UNLOCK	(SC_PM * 256) + 3
#define m_unlock()	c_service(F_M_UNLOCK)



#define F_M_OPEN_CB	(SC_CB * 256) + 0
#define m_open_cb()		\
	c_service(F_M_OPEN_CB)

#define F_M_CLOSE_CB	(SC_CB * 256) + 1
#define m_close_cb()		\
	c_service(F_M_CLOSE_CB)

#define F_M_RESET_CB	(SC_CB * 256) + 2
#define m_reset_cb(a)		\
	c_service(F_M_RESET_CB,(void far *)(a))

#define F_M_NEW_REP	(SC_CB * 256) + 4
#define m_new_rep(a)		 \
	c_service(F_M_NEW_REP,(void far *)(a))

#define F_M_FINI_REP	(SC_CB * 256) + 5
#define m_fini_rep()		\
	c_service(F_M_FINI_REP)

#define F_M_REP_INDEX	(SC_CB * 256) + 7
#define m_rep_index(a,b,c)	\
	c_service(F_M_REP_INDEX,(void far *)(a),(void far *)(b),(void far *)(c))

#define F_M_CB_WRITE	(SC_CB * 256) + 8
#define m_cb_write(a,b) 	\
	c_service(F_M_CB_WRITE,(void far *)(a),b)

#define F_M_CB_READ	(SC_CB * 256) + 9
#define m_cb_read(a,b,c,d)	\
	c_service(F_M_CB_READ,a,b,(void far *)(c),d)



#define F_M_GETDTM	(SC_DTIME * 256) + 1
#define m_getdtm(a)	      \
	c_service(F_M_GETDTM,(void far *)(a))

#define F_M_GET_SETTINGS (SC_DTIME *256) +9
#define m_get_settings(a,b)      \
	c_service(F_M_GET_SETTINGS, (void far *)(a),(void far *)(b))



#define F_MESSAGE	(SC_MISC * 256) + 3
#define message(a,b,c,d)	       \
	c_service(F_MESSAGE,(void far *)(a),b,(void far *)(c),d)

#define F_MSG_OFF	(SC_MISC * 256) + 4
#define msg_off()		\
	c_service(F_MSG_OFF)

/* ============================================================ */

static MACROHD m;
static int *mac_ptr;
static int mac_len;

void J_Char(int which);
FLAG J_Copy(void);
FLAG J_Paste(void);

/* ------------------------------------------------------------ */

void
JInit(void)
	{
	SETTINGS s;

	m_init();

	mac_len = 0;

	m.MacroFK = 1;
	m_get_settings(&s, &m);
	DSetup(s.WeekStart);
	}


/* ------------------------------------------------------------ */

void
JFini(void)
	{
	m_fini();
	}


/* ------------------------------------------------------------ */

/* End a redisplay. */

void
JDisEnd(void)
	{
	JLightOn();
	m_unlock();
	}


/* ------------------------------------------------------------ */

/* Start a redisplay. */

void
JDisStart(void)
	{
	m_lock();
	JLightOff();
	}


/* ------------------------------------------------------------ */

/* Return the current date. */

void
JGetDate(int *year, int *mon, int *day)
	{
	DTM d;

	m_getdtm(&d);
	*year = d.dt_year;
	*mon = d.dt_month - 1;
	*day = d.dt_day;
	}


/* ------------------------------------------------------------ */

/* Returns the default configuration file directory. DNAME must point
to an FNAMEMAX-sized buffer. */

void
JGetDir(char *dname)
	{
	m_get_sysdir(dname);
	}


/* ------------------------------------------------------------ */

/* Get a file name using the file getter.  Return True on success or
False on abort. */

FLAG
JGetFile(char *prompt, char *fname, FLAG usestar)
	{
	FILEINFO fi[100];
	FMENU f;
	EDITDATA ed;
	EVENT e;
	FLAG isdone = FALSE;
	FLAG ok = TRUE;
	char dn[FNAMEMAX];
	char fn[FNAMEMAX];
	char *cptr;

	xstrcpy(dn, fname);
	for (cptr = dn + strlen(dn); cptr > dn; --cptr) {
		if (*cptr == ':' || *cptr == '/' || *cptr == '\\') break;
		}
	if (*cptr == ':' || *cptr == '/' || *cptr == '\\') {
		xstrcpy(fn, cptr + 1);
		*(cptr + 1) = NUL;
		}
	else	{
		xstrcpy(fn, cptr);
		*cptr = NUL;
		}
	if (*fn == NUL || usestar) {
		xstrcpy(fn, "*.*");
		}

	f.fm_path = dn;
	f.fm_pattern = fn;
	f.fm_buffer = fi;
	f.fm_buf_size = sizeof(fi);
	f.fm_startline = -2;
	f.fm_startcol = 0;
	f.fm_numlines = 15;
	f.fm_numcols = 40;
	f.fm_filesperline = 3;

	ed.prompt_window = 1;
	ed.prompt_line_length = 0;
	ed.message_line = prompt;
	ed.message_line_length = strlen(prompt);

	m_clear(-3, 0, 15, 40);

	if (fmenu_init(&f, &ed, "", 0, 0) != RET_OK) {
		DError("can't init file getter");
		return(FALSE);
		}

	VidCurOff();
	e.kind = E_ACTIV;
	while (!isdone) {
		if (e.kind != E_NONE) fmenu_dis(&f, &ed);
		m_event(&e);
		switch (e.kind) {

		case E_ACTIV:
			DNewDisplay();
			DIncrDisplay();
			break;

		case E_TERM:
			mac_len = 1;
			mac_ptr = (int *)(m.MacroBody);
			m.MacroBody[0] = KEYQUIT;
			isdone = TRUE;
			break;
		
		case E_BREAK:
			ok = FALSE;
			isdone = TRUE;
			break;

		case E_KEY:
			if (e.data == ESC || e.data == BEL) {
				ok = FALSE;
				isdone = TRUE;
				}
			else	{
				switch (fmenu_key(&f, &ed, e.data)) {

				case RET_UNKNOWN:
				case RET_BAD:
					TBell();
					break;

				case RET_OK:
					break;

				case RET_REDISPLAY:
					DModeLine();
					break;

				case RET_ACCEPT:
					isdone = TRUE;
					break;

				case RET_ABORT:
					ok = FALSE;
					isdone = TRUE;
					break;
					}
				}
			break;
			}
		}

	fmenu_off(&f, &ed);
	VidCurOn();
	DNewDisplay();
	xstrcpy(fname, ed.edit_buffer);
	return(ok);
	}


/* ------------------------------------------------------------ */

/* Get a key and handle Jaguar-specific translation. */

int
JGetKey(void)
	{
	int chr;
	EVENT e;

again:
	if (mac_len > 0) {
		mac_len--;
		chr = *mac_ptr++;
		}
	else	{
		for (chr = KEYNONE; chr == KEYNONE; ) {
			m_event(&e);
			switch (e.kind) {

			case E_ACTIV:
				DNewDisplay();
				DIncrDisplay();
				VidCurOn();
				break;

			case E_TERM:
				chr = KEYQUIT;
				break;

			case E_BREAK:
				chr = KEYABORT;
				break;

			case E_KEY:
				chr = e.data;
				break;
				}
			}
		}

	if (chr & 0xFF) {	/* regular key */
		chr &= 0xFF;
		return(chr);
		}
	else	{
		chr >>= 8;
		chr &= 0xFF;
		if (chr == 0xC8) chr = 133;
		else if (chr >= 0xDB && chr <= 0xE4) {
			J_Char(chr - 0xDB + 1);
			goto again;
			}
		return(chr + 0x100);
		}
	}


/* ------------------------------------------------------------ */

/* Check for a key press.  Return as KIsKey */

char
JIsKey(void)
	{
	EVENT e;

	if (mac_len > 0) return('Y');

	m_nevent(&e);
	switch (e.kind) {

	case E_ACTIV:
		DNewDisplay();
		DIncrDisplay();
		VidCurOn();
		break;

	case E_TERM:
		mac_len = 1;
		mac_ptr = (int *)(m.MacroBody);
		m.MacroBody[0] = KEYQUIT;
		
	case E_KEY:
		return('Y');
		/*break;*/
		}
	return('N');
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's menu key. */

void
JMenu()
	{
	MENUDATA u;
	EVENT e;
	int which = 0;
	FLAG isdone = FALSE;
	FLAG ok = TRUE;

	uarg = 0;
	menu_setup(&u, "Help\0Open\0PasteClip\0RegionToClip\0Save\0Quit\0",
		6, 1, NULL, 0, NULL);

	VidCurOff();
	menu_on(&u);

	while (!isdone) {
		menu_dis(&u);
		DJMenus(0);
		m_event(&e);
		switch (e.kind) {

		case E_ACTIV:
			DNewDisplay();
			DIncrDisplay();
			VidCurOff();
			break;

		case E_TERM:
			mac_len = 1;
			mac_ptr = (int *)(m.MacroBody);
			m.MacroBody[0] = KEYQUIT;
			isdone = TRUE;
			break;
		
		case E_BREAK:
			mac_len = 1;
			mac_ptr = (int *)(m.MacroBody);
			m.MacroBody[0] = KEYQUIT;
			isdone = TRUE;
			break;

		case E_KEY:
			if (e.data == ESC || e.data == BEL) {
				which = -1;
				isdone = TRUE;
				}
			else	{
				menu_key(&u, e.data, &which);
				if (which != -1) isdone = TRUE;
				}
			break;
			}
		}

	menu_off(&u);
	VidCurOn();

	switch (which) {

	case 0:
		HHelp();
		break;

	case 1:
		FFileFind();
		break;

	case 2:
		ok = J_Paste();
		break;

	case 3:
		ok = J_Copy();
		break;

	case 4:
		FFileSave();
		break;

	case 5:
		MExit();
		break;
		}
	if (!ok) JGetKey();
	}


/* ------------------------------------------------------------ */

/* Display a message. */

void
JMsg(char *str)
	{
	m_lock();
	message(str, strlen(str), "", 0);
	JGetKey();
	msg_off();
	m_unlock();
	}


/* ------------------------------------------------------------ */

/* Cancel an exit operation. */

void
JNoFini(void)
	{
	EVENT e;

	m_no_fini(&e);
	}


/* ------------------------------------------------------------ */

/* Pre-allocate the specified number of paragraphs.  This is a
"placeholder" routine until I can fetch a current copy of the
development tools.  Version 1.5? */

void
JPreAlloc(unsigned paras)
	{
	}


/* ------------------------------------------------------------ */

/* Switch input to the specified function key. */

void
J_Char(int which)
	{
	SETTINGS s;

	m.MacroFK = which;
	m_get_settings(&s, &m);

	if (which == m.MacroFK) {
		mac_ptr = (int *)(m.MacroBody);
		mac_len = m.MacroSize;
		}
	}


/* ------------------------------------------------------------ */

/* Copy the region's contents into the buffer. Return True on
success or False if the caller should wait for a keyboard press. */

FLAG
J_Copy(void)
	{
	char chr;
	FLAG isafter;

	if (m_open_cb() != 0) {
		DEchoNM("can't open clipboard");
		return(FALSE);
		}
	if (m_reset_cb("Freyja") != 0) {
		DEchoNM("can't init clipboard");
		m_close_cb();
		return(FALSE);
		}
	m_new_rep("TEXT");

/* cycle over the region */

	if (isafter = BIsAfterMark(mark)) BMarkSwap(mark);
	BMarkToPoint(cwin->point);
	while (!BIsEnd() && BIsBeforeMark(mark)) {
		chr = BGetCharAdv();
		if (chr == NL) chr = '\xd';
		m_cb_write(&chr, 1);
		}
	BPointToMark(cwin->point);
	if (isafter) BMarkSwap(mark);

	m_fini_rep();
	m_close_cb();
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* Paste the clipboard's contents into the buffer. Return True on
success or False if the caller should wait for a keyboard press. */

FLAG
J_Paste(void)
	{
	int index;
	int len;
	char chr;
	int cnt;

	if (m_open_cb() != 0) {
		DEchoNM("can't open clipboard");
		return(FALSE);
		}
	if (m_rep_index("TEXT", &index, &len) != 0) {
		DEchoNM("nothing to paste");
		m_close_cb();
		return(FALSE);
		}

	BMarkToPoint(mark);
	for (cnt = 0; cnt < len; cnt++) {
		m_cb_read(index, cnt, &chr, 1);
		if (chr == '\xd') chr = NL;
		if (!BInsChar(chr)) break;
		}
	m_close_cb();
	return(TRUE);
	}


/* end of SMJAGUAR.C -- HP95LX (Jaguar) Commands and Support, System-Manager
Compliant */
