# Makefile for Freyja

# Uncomment exactly one of the following two sections.  After changing
# which one is commented out, you will have to recompile everything.
# You can ensure this recompilation by doing "erase *.obj" or "touch *.h"

# Use these for a regular version

COPTS = -f
OBJFILES = calc.obj jaguar.obj
LNKFILE = freyja.lnk
PROGS = freyja.exe

# Use these for a system-manager compliant version (must not have
# the calculator, as it uses floating point)

#COPTS = -f- -DSYSMGR -DNOCALC -DNOEXEC
#OBJFILES = smjaguar.obj
#LNKFILE = smfreyja.lnk
#PROGS = freyja.exm makeexm.exe

# --------------------------------------------------

H = freyja.h fgenlib.h
CORE  = buf.obj char.obj date.obj display.obj file.obj flib.obj help.obj ini.obj key.obj misc.obj region.obj table.obj term.obj white.obj word.obj xprintf.obj $(OBJFILES)

all:	$(PROGS)

# --------------------------------------------------

# /v for debugging, /m->/s for detailed symbol table
LOPTS = /c/d/m

# -v for debugging
.c.obj:
	tcc $(COPTS) $*

.asm.obj:
	tasm $* /mx;

# --------------------------------------------------
# The tlink program should generate this warning message:
# "Warning: __stklen defined in module NAME.c is duplicated in module STKLEN"

freyja.exe:	freyja.obj $(CORE) libasm.obj
	tlink $(LOPTS) @$(LNKFILE)

freyja.obj:	freyja.c $(H)
	tcc -c $(CFLAGS) $(COPTS) -DMAIN freyja.c

# --------------------------------------------------
# The tlink program should generate this warning message:
# "Warning: __stklen defined in module NAME.c is duplicated in module STKLEN"

makeexm.exe:	makeexm.obj flib.obj xprintf.obj libasm.obj
	tlink $(LOPTS) \lib\c0s makeexm flib xprintf libasm,makeexm,makeexm,\lib\cs

makeexm.obj:	makeexm.c fgenlib.h
	tcc -c $(CFLAGS) makeexm.c

# --------------------------------------------------
# The tlink program should generate this warning message:
# "Warning: __stklen defined in module NAME.c is duplicated in module STKLEN"

freyja.exm:	makeexm.exe c0s.obj freyja.obj $(CORE) libasm.obj
	tlink $(LOPTS) @$(LNKFILE)
	makeexm freyja smfreyja

# --------------------------------------------------

$(CORE):	$(H)

# --------------------------------------------------

# Build 5 1/4" MS/DOS diskettes from MS/DOS system

distrib:
	touch *.*
	echo "insert disk 1"
	erase a:*.*
	copy makefile.msd	a:
	copy Makefile.unx	a:
	copy README	a:
	copy ascii	a:
	copy buf.c	a:
	copy c0s.asm	a:
	copy calc.c	a:
	copy char.c	a:
	copy date.c	a:
	copy display.c	a:
	copy fcalc.doc	a:
	copy fcmdlist.doc	a:
	copy fcmdxref.doc	a:
	copy fcopying.doc	a:
	copy ffsf.doc	a:
	copy fgenlib.h	a:
	copy file.c	a:
	copy fleague.doc	a:
	copy flib.c	a:
	copy freyja.c	a:
	copy freyja.doc	a:
	echo "insert disk 2"
	erase a:*.*
	copy freyja.exe	a:
	copy freyja.exm a:
	copy freyja.h	a:
	copy freyja.ini	a:
	copy freyja.lnk	a:
	copy ftutoria.doc	a:
	copy fwarrant.doc	a:
	copy help.c	a:
	copy ini.c	a:
	copy jaguar.c	a:
	copy key.c	a:
	copy libasm.asm	a:
	copy makeexm.c	a:
	copy misc.c	a:
	copy region.c	a:
	copy smfreyja.lnk	a:
	copy smjaguar.c	a:
	copy table.c	a:
	copy term.c	a:
	copy turboc.cfg	a:
	copy white.c	a:
	copy word.c	a:
	copy xprintf.c	a:
	copy xprintf.doc	a:
	echo Do not forget to copy emacs

# --------------------------------------------------

cleanup:
	-erase *.obj
	-erase *.map

cleanall:
	-erase *.obj
	-erase *.map
	-erase $(PROGS)
