/* KEY.C -- Key Input Routines

	Written March 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

#define ZCY		'\031'

static struct buffer *buf_buf = NULL;
static struct mark *buf_pt = NULL;

static int mac_buf[MACROMAX] = { KEYNONE };
static int *mac_ptr = mac_buf;
static FLAG mac_record = FALSE;
static int mac_arg = KEYNONE;

static char *str_ptr = NULL;
static int str_len = 0;

/* ------------------------------------------------------------ */

/* Ask a yes/no question in the echo line.  Return KEYQUIT, KEYABORT,
'Y', or 'N'. */

int
KAsk(msg)
	char *msg;
	{
	DEcho(msg);
	for (;;) {
		switch (xtoupper(KGetChar())) {

		case KEYQUIT:
			DModeLine();
			return(KEYQUIT);
			/*break;*/

		case KEYABORT:
		case ESC:
		case BEL:
			DModeLine();
			return(KEYABORT);
			/*break;*/

		case SP:
		case 'Y':
			DModeLine();
			return('Y');
			/*break;*/

		case DEL:
		case BS:
		case 'N':
			DModeLine();
			return('N');
			/*break;*/

		default:
			TBell();
			break;
			}
		}
	}


/* ------------------------------------------------------------ */

/* begin defining keyboard macro */

void
KBegMac()
	{
	uarg = 0;
	if (mac_arg > 0) {
		DError("Using macro");
		return;
		}
	mac_ptr = mac_buf;
	mac_record = TRUE;
	}


/* ------------------------------------------------------------ */

/* Echo msg if no char is typed within interval return true if msg
printed, else false */

FLAG
KDelayPrompt(msg)
	char *msg;
	{
	int cnt;

	for (cnt = 0; cnt < DELAYCOUNT; cnt++) {
		if (KIsKey() == 'Y') return(FALSE);
		}
	DEchoNM(msg);
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* finish defining keyboard macro */

void
KEndMac()
	{
	uarg = 0;
	mac_record = FALSE;
	mac_ptr -= 2;
	if (mac_ptr < mac_buf) mac_ptr = mac_buf;
	*mac_ptr = KEYNONE;
	}


/* ------------------------------------------------------------ */

/* Switch input to be from the specified buffer.  The entire buffer is
read, starting from the beginning.  The point is preserved. */

void
KFromBuf(bptr)
	struct buffer *bptr;
	{
	struct buffer *savebuf = cbuf;

	BBufGoto(bptr);
	if ((buf_pt = BMarkCreate()) != NULL) {
		buf_buf = bptr;
		BMoveToStart();
		}
	BBufGoto(savebuf);
	}


/* ------------------------------------------------------------ */

/* do keyboard macro */

void
KFromMac()
	{
	if (mac_record) {
		DError("Creating macro");
		uarg = 0;
		return;
		}
	mac_arg = uarg;
	mac_ptr = mac_buf;
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Switch input to be from the supplied string. */

void
KFromStr(str, len)
	char *str;
	int len;
	{
	if (str == NULL || len <= 0) {
		str_len = 0;
		}
	else	{
		str_ptr = str;
		str_len = len;
		}
	}


/* ------------------------------------------------------------ */

/* Get a character and handle keyboard macros */

int
KGetChar()
	{
	int chr;
	
	if (buf_buf != NULL) {
		struct buffer *savebuf = cbuf;

		BBufGoto(buf_buf);
		if (!BIsEnd()) {	/* get next char */
			chr = BGetCharAdv();
			BBufGoto(savebuf);
			return(chr);
			}
		BPointToMark(buf_pt);
		BMarkDelete(buf_pt);
		buf_buf = NULL;
		BBufGoto(savebuf);
		}
	if (str_len > 0) {
		str_len--;
		return(*str_ptr++);
		}
	while (mac_arg > 0) {
		chr = *mac_ptr++;
		if (chr != KEYNONE) return(chr);
		mac_arg--;
		mac_ptr = mac_buf;
		DIncrDisplay();
		TForce();
		}
	TForce();
#if defined(MSDOS)
	if (c.g.key_type == 'J') {
		chr = JGetKey();
		}
	else
#endif
		chr = TGetKey();

	if (c.g.ESC_swap != ESC) {
		if (chr == ESC) chr = c.g.ESC_swap;
		else if (chr == c.g.ESC_swap) chr = ESC;
		}
	if (c.g.CTX_swap != ZCX) {
		if (chr == ZCX) chr = c.g.CTX_swap;
		else if (chr == c.g.CTX_swap) chr = ZCX;
		}
	if (mac_record) {
		*mac_ptr++ = chr;
		if (mac_ptr > &mac_buf[MACROMAX - 1]) {
			DError("Keyboard macro full");
			mac_ptr--;
			}
		*mac_ptr = KEYNONE;
		}
	return(chr);
	}


/* ------------------------------------------------------------ */

/* Input a string argument. Return KEYQUIT, KEYABORT, or 'Y' (if ok). */

int
KGetStr(msg, str, len)
	char *msg;
	char *str;
	int len;
	{
	char sbuf[BIGBUFFSIZE];
	char buf[BIGBUFFSIZE];
	int c;
	int amt;
	int retval;

	*sbuf = NUL;
	for (retval = KEYNONE; retval == KEYNONE; ) {
		xsprintf(buf, "%s: %s", msg, sbuf);
		DEcho(buf);

		amt = strlen(sbuf);
		c = KGetChar();
		switch (c) {

		case KEYQUIT:
			retval = KEYQUIT;
			break;

		case KEYABORT:
		case ESC:
		case BEL:
			retval = KEYABORT;
			break;

		case CR:
			retval = 'Y';
			break;

		case BS:
		case DEL:
			if (*sbuf != NUL) sbuf[amt - 1] = NUL;
			break;

#if defined(MSDOS)
		case 0x100 + 97:	/* Ctrl-F4 */
#endif
		case ZCY:
			KFromBuf(kill_buf);
			break;

		default:
			if (amt >= len - 1) {
				sbuf[amt - 1] = NUL;
				TBell();
				}

			if (c == ZCQ) c = KGetChar();
			sbuf[amt] = c;
			sbuf[amt + 1] = NUL;
			break;
			}
		}
	if (retval != KEYQUIT && retval != KEYABORT && *sbuf != NUL)
		xstrcpy(str, sbuf);
	DModeLine();
	return(retval);
	}


/* ------------------------------------------------------------ */

/* Is key available from macro? */

char
KIsKey()
	{
	if (buf_buf != NULL) {
		struct buffer *savebuf = cbuf;

		BBufGoto(buf_buf);
		if (!BIsEnd()) {
			BBufGoto(savebuf);
			return('Y');
			}
		BPointToMark(buf_pt);
		BMarkDelete(buf_pt);
		buf_buf = NULL;
		BBufGoto(savebuf);
		}
	if (str_len > 0) return('Y');
	if (!mac_record && mac_arg > 0) return('Y');
#if defined(MSDOS)
	if (c.g.key_type == 'J')
		return(JIsKey());
	else
#endif
		return(TIsKey());
	}


/* ------------------------------------------------------------ */

/* Return a pointer to the start of the keyboard macro. */

int *
KMacPtr()
	{
	return(mac_buf);
	}


/* ------------------------------------------------------------ */

/* Internal routine to display current argument */

FLAG
KUArg(targ)
	int targ;
	{
	int cnt;
	char buf[LINEBUFFSIZE];

	if (targ == 4) {
		for (cnt = 0; cnt < DELAYCOUNT; cnt++) {
			if (KIsKey() == 'Y') return(FALSE);
			}
		}
	xsprintf(buf, "Arg: %d", targ);
	DEchoNM(buf);
	return(TRUE);
	}


/* KEY.C -- Key Input Routines */
