/* FREYJA.H -- Freyja Header File

	Written 1980 by Mark of the Unicorn, Inc.
	Rewritten 1991 by Craig A. Finseth

*/

/* -------------------- We Begin -------------------- */

#include "fgenlib.h"

#if defined(MSDOS)
#if defined(MAIN)
#define STACKSIZE	((10 * 1024) / 16);
int _stklen = STACKSIZE;
#endif
#endif

#if defined(BERK43) || defined(UNIXV)
#define UNIX		1
#endif

#if defined(UNIX)
char *getenv();
#endif

#if defined(SYSMGR)
#undef CALC
#endif

/* -------------------- Constants -------------------- */

	/* amount of time to delay for delayed echos -- this is a loop count*/
#if defined(MSDOS)
#define DELAYCOUNT	0
#else
#define DELAYCOUNT	1000
#endif

	/* size of the largest terminal to handle */
#if defined(MSDOS)
#define ROWMAX		25
#define COLMAX		80
#else
#define ROWMAX		132
#define COLMAX		240
#endif

	/* preference items */
#define HOVERLAP	5		/* columns to overlap for h. scroll */
#define VOVERLAP	2		/* lines to overlap for ^V */
#define PREF_PCT	40		/* preferred row as a % 0-100 */
#define MACROMAX	128		/* max size of a keybaord macro */

	/* universal global declarations */
#define	FORWARD		1
#define	BACKWARD	0

	/* file names for help */
#if !defined(NOCALC)
#define CALCULATOR_FILE	"fcalc.doc"
#endif
#define CMDLIST_FILE	"fcmdlist.doc"
#define COPYING_FILE	"fcopying.doc"
#define FSF_FILE	"ffsf.doc"
#define INFO_FILE	"freyja.doc"
#define LEAGUE_FILE	"fleague.doc"
#define XREF_FILE	"fcmdxref.doc"
#define TUTORIAL_FILE	"ftutoria.doc"
#define WARRANTY_FILE	"fwarrant.doc"

	/* maximum limits */
#define	STRMAX		40		/* size of a response */
#define LINEBUFFSIZE	255		/* size of an output line buffer */
#define SMALLBUFFSIZE	33

#define BIGBUFFSIZE	(FNAMEMAX)	/* largest of FNAMEMAX and previous
					buffer sizes */
#define NUMBUFFERS	12		/* buffers */

#define ZCQ		'\021'		/* ^Q */
#define ZCX		'\030'		/* ^X */
#define ZCZ		'\032'		/* ^Z */
#define SNL		'\037'		/* "soft" newline, ^_ */

	/* pseudo-key definitions */
#define KEYNONE		(-1)		/* no valid key */
#define KEYABORT	(-2)
#define KEYQUIT		(-3)

	/* for visible grayspace */
#if defined(UNIX)
#define VIS_SPACE_CHAR	'.'
#define VIS_TAB_CHAR	'>'
#define VIS_NL_CHAR	'<'
#endif
#if defined(MSDOS)
#define VIS_SPACE_CHAR	'\372'
#define VIS_TAB_CHAR	'\020'
#define VIS_NL_CHAR	'\021'
#define KEYHELP		(0x100 + 59)
#endif

/* -------------------- Configuration Settings -------------------- */

#define INI_FILENAME	"freyja.ini"

struct conf_buffer {
	int left_margin;	/* indent column */
	int right_margin;	/* fill column */
	int tab_spacing;	/* tab stop spacing */
	char fill;		/* filling mode */
	};

struct conf_global {
	char screen_type;	/* screen type */
	char screen_size;	/* screen size */
	char key_type;		/* keyboard input */
	char special;		/* special handling */
	char parameter_1;	/* parameter 1 */
	int swap_size;		/* default swap area size in Kbytes */
	int ESC_swap;		/* swap Esc and this char (27 for no swap) */
	int CTX_swap;		/* swap ^X and this char (24 for no swap) */
	char meta_handle;	/* bit 2^8 in a character */
	FLAG wrap_allowed;	/* check for word wrap files */
	FLAG vis_gray;		/* True if grayspace is visible, False if not*/
	FLAG use_caret;		/* True if carat notation */
	int language;		/* Output language */
	FLAG skip_system;	/* True if system buffers should be skipped */
	FLAG saving;		/* True if ^X ^S should save unmodified files */
	};

struct conf {
	struct conf_buffer d;
	struct conf_global g;
	};

#if defined(MAIN)
struct conf c;
#else
extern struct conf c;
#endif

/* -------------------- Windows -------------------- */

#define NUMWINDOWS	2

struct window {
	FLAG visible;		/* is the window visible/in use? */
	int top;		/* first line of window */
	int bot;		/* last line of window */
	struct mark *sstart;	/* mark at the start of the window */
	struct mark *send;	/* mark at the end of the window */
	FLAG isend;		/* is the end mark valid? */
	struct mark *point;	/* the point */
	int offset;		/* the horizontal offset */
	};

#if defined(MAIN)
struct window windows[NUMWINDOWS];
struct window *cwin;		/* the current window */
int num_windows;		/* number of windows being displayed */
#else
extern struct window windows[NUMWINDOWS];
extern struct window *cwin;
extern int num_windows;
#endif

/* -------------------- Buffers -------------------- */

#define	PAGESIZE	1024		/* page size in bytes */
#define	SWAPMAX		256		/* maximum number of pages */
#define NUM_PHYS_PAGES	16		/* number of pages in memory */

#define	MAXMARK		(2 * NUMBUFFERS + 4 * NUMWINDOWS + 4)

struct virt_page {
	struct virt_page *next;		/* chain of pages in buffer */
	struct virt_page *prev;
	char where;			/* where page is M-memory, S-swap,
					L-locked */
	int page_num;			/* page number in the swap area */
	int gap_start;			/* gap start */
	int page_len;			/* page length */
	};

struct mark {
	struct virt_page *pptr;		/* page in the buffer */
	struct buffer *bptr;		/* buffer the mark is in */
	int mark_offset;		/* offset in the page */
	FLAG is_mod;			/* screen mark modified flags */
	};

struct buffer {
	char fname[FNAMEMAX];		/* the file name */
	struct conf_buffer c;		/* configuration parameters */
	struct mark *mptr;		/* the mark */
	struct virt_page *first;	/* describe the pages */
	struct virt_page *last;
	struct virt_page *point_page;	/* point's page number */
	int point_offset;		/* offset within page */
	int num_pages;			/* number of pages in buffer */
	FLAG is_mod;			/* has the buffer been modified? */
#ifdef UNIX
	long file_time;
#endif
	};

#if defined(MAIN)
struct buffer buffers[NUMBUFFERS];
#else
extern struct buffer buffers[NUMBUFFERS];
#endif

	/* current buffer information */
#if defined(MAIN)
struct buffer *cbuf;			/* the curent buffer */
struct mark *mark;			/* the current mark */
#else
extern struct buffer *cbuf;
extern struct mark *mark;
#endif

	/* system buffer support */
#define IS_SYS(x)	(*(x) == '%')
#define SYS_BUFFLIST	"%bufflist%"
#define SYS_DIRED	"%dired%"
#define SYS_HELP	"%help%"
#define SYS_KILL	"%kill%"
#define SYS_SCRATCH	"%scratch%"

/* -------------------- Globals -------------------- */

#if defined(MAIN)
int lastkey;		/* the last command key given */
int lasttable;		/* the last prefix table used */
int key;		/* the current command key */
int table;		/* the current command table */

int uarg;		/* command argument */
FLAG isuarg;		/* was there an argument? */
FLAG isrepeating;	/* are we on the second or later repetition? */
FLAG doabort;		/* do we leave the editor? */

struct buffer *kill_buf;	/* kill buffer */

char stringarg[STRMAX];	/* last string entered */
char filearg[FNAMEMAX];	/* last filename entered */
#else
extern int lastkey;
extern int lasttable;
extern int key;
extern int table;
extern int uarg;
extern FLAG isuarg;
extern FLAG isrepeating;
extern FLAG doabort;
extern struct buffer *kill_buf;
extern char stringarg[STRMAX];
extern char filearg[FNAMEMAX];
#endif

/* -------------------- Routines -------------------- */

	/* buf.c */

FLAG BInit();		/* int swap_size */
void BFini();		/* void */
struct buffer *BBufCreate();	/* char *fname */
void BBufDelete();	/* struct buffer *bptr */
struct buffer *BBufFind();	/* char *name */
void BBufGoto();	/* struct buffer *bptr */
void BBufUnmod();	/* void */
void BCharChange();	/* char new */
void BCharDelete();	/* int amount */
FLAG BFileRead();	/* void */
FLAG BFileWrite();	/* void */
void BFlush();		/* void */
char BGetChar();	/* void */
char BGetCharAdv();	/* void */
int BGetCol();		/* void */
long BGetLength();	/* struct buffer *bptr */
long BGetLocation();	/* void */
FLAG BInsChar();	/* char new */
void BInsSpaces();	/* int amount */
FLAG BInsString();	/* char *str */
void BInsTabSpaces();	/* int amount */
void BInvalid();	/* void */
FLAG BIsAfterMark();	/* struct mark *mptr */
FLAG BIsAtMark();	/* struct mark *mptr */
FLAG BIsBeforeMark();	/* struct mark *mptr */
FLAG BIsEnd();		/* void */
FLAG BIsFree();		/* struct buffer *bptr */
FLAG BIsMod();		/* struct buffer *bptr */
FLAG BIsStart();	/* void */
void BMakeColB();	/* int col */
void BMakeColF();	/* int col */
struct buffer *BMarkBuf(); /* struct mark *mptr */
struct mark *BMarkCreate(); /* void */
void BMarkDelete();	/* struct mark *mptr */
FLAG BMarkIsMod();	/* struct mark *mptr */
void BMarkSetMod();	/* struct mark *mptr */
struct mark *BMarkScreen();	/* int row */
void BMarkSwap();	/* struct mark *mptr */
void BMarkToPoint();	/* struct mark *mptr */
void BMoveBy();		/* int amount */
void BMoveToEnd();	/* void */
void BMoveToStart();	/* void */
void BPointToMark();	/* struct mark *mptr */
void BPopState();	/* void */
void BPushState();	/* void */
void BRegCopy();	/* struct mark *mptr, struct buffer *bptr */
void BRegDelete();	/* struct mark *mptr */
FLAG BSearchB();	/* char c1, char c2 */
FLAG BSearchF();	/* char c1, char c2 */

	/* calc.c */

#if !defined(NOCALC)
void UInit();		/* void */
void UCalc();		/* void */
char *UDescr();		/* int operation */
void UEnter();		/* void */
char *UHelp();		/* int operation */
void ULoadMac();	/* void */
int UNumOps();		/* void */
void UPrintX();		/* void */
void USetup();		/* FLAG iscomma, FLAG issep */
#endif

	/* char.c */

void CCharB();		/* void */
void CCharBD();		/* void */
void CCharF();		/* void */
void CCharFD();		/* void */
void CCharTran();	/* void */
void CLineA();		/* void */
void CLineAED();	/* void */
void CLineB();		/* void */
void CLineE();		/* void */
void CLineF();		/* void */
void CLineFD();		/* void */
void CScrnB();		/* void */
void CScrnBOW();	/* void */
void CScrnF();		/* void */
void CScrnFOW();	/* void */

	/* date.c */

void DCal();		/* void */
void DMove();		/* int amout */
void DNext();		/* void */
void DNow();		/* struct tm *tptr */
int DOW();		/* long day */
void DPrev();		/* void */
void DSetup();		/* int weekstart, int datefmt, int timefmt */
void DToDate();		/* struct tm *tptr, long day, int cal */
long DToDayN();		/* struct tm *tptr, int cal */
#if !defined(SYSMGR)
void DXCal();		/* struct tm *tptr */
#endif

	/* display.c */

void DInit1();		/* void */
void DInit2();		/* void */
void DFini();		/* void */
void DEcho();		/* char *msg */
void DEchoNM();		/* char *msg */
void DError();		/* char *msg */
void DIncrDisplay();	/* void */
#if defined(MSDOS)
void DJMenus();		/* int which */
#endif
void DLeft();		/* void */
void DModeFlags();	/* void */
void DModeLine();	/* void */
void DNewDisplay();	/* void */
int DPrefLine();	/* void */
void DRight();		/* void */
void DScreenRange();	/* void */
void DTogVisGray();	/* void */
void DView();		/* char *msg */
void DWindGrow();	/* void */
int DWindHeight();	/* void */
void DWindOne();	/* void */
void DWindSwap();	/* void */
void DWindTog();	/* void */
void DWindTwo();	/* void */
void DWindTwoO();	/* void */

	/* file.c */

void FBufBeg();		/* void */
void FBufDel();		/* void */
void FBufEnd();		/* void */
void FBufList();	/* void */
void FBufNext();	/* void */
void FBufPrev();	/* void */
#if !defined(NOEXEC)
void FCommand();	/* void */
#endif
void FDIRED();		/* void */
void FFileFind();	/* void */
void FFileRead();	/* void */
void FFileSave();	/* void */
void FFileWrite();	/* void */
FLAG FMakeSys();	/* char *name, FLAG erase */
int FPathOpen();	/* char *name, char *actualname */

	/* help.c */

void HHelp();		/* void */

	/* ini.c */

FLAG IniLoad();		/* char screen, int size */

	/* jaguar.c */

#if defined(MSDOS)
void JInit(void);
void JFini(void);
#if !defined(SYSMGR)
void JAppt();		/* void */
void JComm();		/* void */
void JDisEnd(void);
void JDisStart(void);
void JFiler();		/* void */
void JGetDir(char *dname);
int JGetKey(void);
void JHPCalc();		/* void */
char JIsKey(void);
void JLotus();		/* void */
void JMemo();		/* void */
void JMenu();		/* void */
void JPhone();		/* void */
void JSetup();		/* void */
#else
void JDisEnd(void);
void JDisStart(void);
void JGetDate(int *year, int *mon, int *day);
void JGetDir(char *dname);
FLAG JGetFile(char *prompt, char *fname, FLAG usestar);
int JGetKey(void);
char JIsKey(void);
void JMenu();		/* void */
void JMsg(char *str);
void JNoFini(void);
void JPreAlloc(unsigned paras);
#endif
#endif

	/* key.c */

int KAsk();		/* char *msg */
void KBegMac();		/* void */
FLAG KDelayPrompt();	/* char *msg */
void KEndMac();		/* void */
void KFromBuf();	/* struct buffer *bptr */
void KFromMac();	/* void */
void KFromStr();	/* char *str, int len */
int KGetChar();		/* void */
int KGetStr();		/* char *msg, char *str, int len */
char KIsKey();		/* void */
int *KMacPtr();		/* void */
FLAG KUArg();		/* int targ */

	/* misc.c */

void GoToGray();	/* FLAG isforward */
void GoToNotGray();	/* FLAG isforward */
FLAG IsGray();		/* void */
FLAG IsNL();		/* void */
FLAG IsWhite();		/* void */
void MAbort();		/* void */
void MCtrlX();		/* void */
void MExit();		/* void */
void MIns8();		/* void */
void MInsChar();	/* void */
void MMakeDelete();	/* void */
void MNotImpl();	/* void */
void MMeta();		/* void */
void MQuote();		/* void */
void MReplace();	/* void */
void MReplaceQ();	/* void */
void MSearchB();	/* void */
void MSearchF();	/* void */
void MUArg();		/* void */
void MovePastB();	/* FLAG (*pred)() */
void MovePastF();	/* FLAG (*pred)() */
void MoveToB();		/* FLAG (*pred)() */
void MoveToF();		/* FLAG (*pred)() */
FLAG SearchNLB();	/* void */
FLAG SearchNLF();	/* void */

	/* region.c */

void RDelWhite();	/* void */
void RHardToSoft();	/* void */
void RIndent();		/* void */
void RKillToMark();	/* struct mark * mptr, FLAG isforward */
void RLower();		/* void */
void RMarkSet();	/* void */
void RMarkSwap();	/* void */
void ROutdent();	/* void */
void RRegCopy();	/* void */
void RRegDelete();	/* void */
void RSoftToHard();	/* void */
void RTabify();		/* void */
void RUntabify();	/* void */
void RUpper();		/* void */
void RYank();		/* void */

	/* table.c */

char *TabDescr();	/* int key, int table */
void TabDispatch();	/* int key, int table */
char *TabHelp();	/* int key, int table */
int TabTable();		/* int key, int table */
FLAG TabIsDelete();	/* int key, int table */
FLAG TabIsVMove();	/* int key, int table */
int TabNumFunc();	/* void */

	/* term.c */

FLAG TInit();		/* void */
void TFini();		/* void */
void TAdjCol();		/* void */
void TBell();		/* void */
void TCLEOL();		/* void */
void TClrScreen();	/* void */
void TForce();		/* void */
int TGetCol();		/* void */
int TGetKey();		/* void */
int TGetOffset();	/* void */
int TGetRow();		/* void */
int TGetWidth();	/* char c, int column */
void THiOff();		/* void */
void THiOn();		/* void */
FLAG TIsKey();		/* void */
int TMaxCol();		/* void */
int TMaxRow();		/* void */
char *TPrintChar();	/* char c, char *buf */
void TPutChar();	/* char c */
void TPutStr();		/* char *str */
void TSetOffset();	/* int offset */
void TSetPoint();	/* int row, int column */

	/* white.c */

void WDelFWhite();	/* void */
void WDelWhite();	/* void */
void WFixup();		/* struct conf_buffer *cptr */
void WIndNext();	/* void */
void WIndDel();		/* void */
void WIndThis();	/* void */
void WInsNL();		/* void */
void WInsNLA();		/* void */
void WJoinGray();	/* void */
void WLineCenter();	/* void */
void WPrintLine();	/* void */
void WPrintMar();	/* void */
void WPrintPos();	/* void */
void WSetFill();	/* void */
void WSetLeft();	/* void */
void WSetRight();	/* void */
void WSetTabs();	/* void */

	/* word.c */

void WCaseRotate();	/* void */
void WNumB();		/* void */
void WNumF();		/* void */
void WNumMark();	/* void */
void WParaB();		/* void */
void WParaF();		/* void */
void WParaFill();	/* void */
void WParaMark();	/* void */
void WSentB();		/* void */
void WSentBD();		/* void */
void WSentF();		/* void */
void WSentFD();		/* void */
void WWordB();		/* void */
void WWordBD();		/* void */
void WWordCap();	/* void */
void WWordF();		/* void */
void WWordFD();		/* void */
void WWordLow();	/* void */
void WWordTran();	/* void */
void WWordUp();		/* void */
void WWrap();		/* void */

/* end of FREYJA.H -- Freyja Header File */
