/* FREYJA.C -- Freyja Text Editor

	Written March 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

void edit();		/* void */

/* ------------------------------------------------------------ */

#if !defined(SYSMGR)
int
main(argc,argv)
	int argc;
	char *argv[];
	{
	int cnt;
	char screen = '@';
	int size = 128;
	FLAG any = FALSE;

	xprintf("Freyja, Copyright 1991,2 by Craig A. Finseth\r\n");

	if (argc < 1) {
usage:
		xprintf("usage is: freyja [-options] [<file(s)>]\r\n\
	-z <size>	edit area size in Kbytes\r\n\
	-s <type>	screen type, one of:\r\n\
				v	vt100\r\n\
%s",
#if defined(UNIX)
"				t	termcap\n"
#else
#if defined(MSDOS)
"				b	bios calls\r\n\
				m	direct video memory access\r\n"
#else
""
#endif
#endif
			);
		exit(1);
		}

/* arguments */

	for (cnt = 1; cnt < argc; cnt++) {
		if (strequ(argv[cnt], "-s")) {		/* set screen type */
			if (++cnt >= argc) {
				xprintf("Missing screen type.\r\n");
				goto usage;
				}
			screen = xtoupper(*argv[cnt]);
			}
		if (strequ(argv[cnt], "-s")) {	/* set buffer size */
			if (++cnt >= argc) {
				xprintf("Missing buffer size.\r\n");
				goto usage;
				}
			if (!SToN(argv[cnt], &size, 10)) {
				xprintf("Buffer size must be an integer.\r\n");
				goto usage;
				}
			}
		else if (*argv[cnt] == '-') {
			xprintf("Unrecognized option '%s'.\n", argv[cnt]);
			goto usage;
			}
		else	;
		}

/* now can initialize stuff */

	if (!IniLoad(screen, size)) exit(1);
	TInit();
	if (!BInit(c.g.swap_size)) {
		DError("Can't init buf");
		TFini();
		exit(1);
		}

	DInit1();
	cbuf = NULL;
	kill_buf = BBufCreate(SYS_KILL);

/* now load files from cmd line */

	for (cnt = 1; cnt < argc; cnt++) {
		if (*argv[cnt] == '-') {
			++cnt;
			}
		else	{
			if (BBufCreate(argv[cnt]) != NULL) BFileRead();
			any = TRUE;
			}
		}

	if (!any) {
#else
unsigned int errno;
unsigned int __brklvl;
unsigned char *environ = "";

void
main(void)
	{
	JInit();

	if (!IniLoad('@', 128)) JFini();
	TInit();
	if (!BInit(c.g.swap_size)) {
		JMsg("Can't init buf");
		JFini();
		}

	DInit1();
	cbuf = NULL;
	kill_buf = BBufCreate(SYS_KILL);

		{
#endif
		BBufCreate(SYS_SCRATCH);
		BInsStr("Freyja, an Emacs-type Text Editor\n\
Copyright 1991,2 by Craig A. Finseth\n\
\n\
Type ^X ^C to exit\n\
     ^X H for help\n\
     ^X H ^C for copying information\n\
     ^X H ^W for warranty information\n\
-------------------------------------\n\
     ^W to clear this text\n");
		}

	DInit2();
#if !defined(NOCALC)
	UInit();
#endif

#if defined(MSDOS) && !defined(SYSMGR)
	if (c.g.special == 'J') JInit();
#endif

	lastkey = 0;
	lasttable = 0;

	*stringarg = NUL;
	*filearg = NUL;

	DNewDisplay();

	edit();			/* do the actual editing */

#if defined(SYSMGR)
	BFini();
	JFini();
#else
#if defined(MSDOS)
	if (c.g.special == 'J') JFini();
#endif
	DFini();
	BFini();
	TSetPoint(TMaxRow() - 1,0);
	TFini();
#if defined(MSDOS)
	_exit(0);
#else
	exit(0);
#endif
#endif
	}


/* ------------------------------------------------------------ */

/* This does the actual editing, we assume that the buffer is
initialized. */

void
edit()
	{
	struct buffer *lbuf = NULL;

	doabort = FALSE;

	while (!doabort) {
		if (cbuf->c.fill == 'W') WWrap();
		if (cbuf != lbuf) DModeLine();
		lbuf = cbuf;

		DIncrDisplay();

		table = 0;
		key = KGetChar();
		uarg = 1;
		isuarg = FALSE;
		isrepeating = FALSE;
		while (uarg > 0) {
			TabDispatch(key, table);
			if (--uarg < 0) uarg = 0;
			isrepeating = TRUE;
			}
		lastkey = key;
		lasttable = table;
		}
	}


/* end of FREYJA.C -- Freyja Text Editor */
