/*
// Abstract:
//	PAGER---Display Pager
//
//	The Display Pager module counts lines of text that have been
//	displayed and after a specified number of lines, will ask:
//	"Press RETURN to contine: ".
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	27 October 1990
//
// History:
// V01-001	Derek S. Nickel		27-OCT-1990
//	Original.
//
*/

#include <conio.h>
#include <stdio.h>

#include "pager.h"
#include "modes.h"

/***********************************************************************
	pager
***********************************************************************/

void pager(int xlines)
{
	static int displayed_lines = 0;
	static int max_lines = 23;

	if (xlines > 0) {
		displayed_lines = 0;
		max_lines = xlines;
	} else if (xlines < 0) {
		displayed_lines = 0;
	} else {
		if (displayed_lines == max_lines) {
			displayed_lines = 0;
			if (modes.pager) {
				printf("Press RETURN to contine: ");
				getch();
				printf("\r                         \r");

			}
		}
		displayed_lines++;
	}
}
