/* sect.h -- Program Section Operations */


/* Include this file before star.h */
#ifdef _SECT_DEF_
#define _SECT_DEF_


#define SC_SEGBYTES 64		/* 64 nibbles per seg (one nibble per byte) */


/* Section - used as value */
typedef struct sect
{
  long
    sc_reloc;			/* Relocation address for segment,
				 * updated after each pass
				 */
  int
    sc_bits;			/* See SC_xxx bits below */

  struct codeseg
    *sc_code_head,		/* Beginning of code chain */
    *sc_code_tail;		/* End of code chain */
}
SECT;


/* Section code segment */
typedef struct codeseg
{
  struct codeseg
    *sc_next;			/* Next segment in list */

  int
    sc_nbytes;			/* # of bytes in use (one nib per byte) */

  char
    sc_data[SC_SEGBYTES];	/* Data, one nibble stored in each char */
}
SECT_CSEG;


/* Section bits */
#define SC_R	 0001		/* Read access - extrapolated */
#define SC_W	 0002		/* Write access (RAM) - extrapolated */

#define SC_SECT  0070		/* Mask for SC_xSECT below */
#define SC_ASECT 0010		/* Is ASECT (addresses) */
#define SC_PSECT 0020		/* Is PSECT (R/W program) */
#define SC_CSECT 0030		/* Is CSECT (R/O program) */
#define SC_DSECT 0040		/* Is DSECT (R/W data) */
#define SC_LSECT 0050		/* Is LSECT (R/O literal pool) */


/* Interface */
extern SECT
  *sc_new();				      /* Create new section */

extern void
  sc_init(),				      /* Initialize */
  sc_add_code(SECT *, int, unsigned long),    /* Add code to section */
  sc_reloc(SECT *, long),		      /* Relocate section */
  sc_flush(SECT *, FILE *);		      /* Flush section onto file */

#endif
