/* sad.h - SAD header file */

#ifndef _SAD_CONFIG_
#define _SAD_CONFIG_

static char
  sad_version[] = "1.03";

  
#define SAD_CORE ".core"	/* Core file */
#define SAD_SYMBOLS ".symbols"	/* Symbols file */
#define SAD_COMMENTS ".comments" /* Comments file */
#define SAD_FORMATS ".formats"	/* Formats file */
#define SAD_MACROS ".macros"	/* Macro pattern file */
#define SAD_AUTOFMT "formats.out" /* Formats auto gen output */

#define JUMPREL  0x40		/* What is considered a routine offset */
#define DATAREL  0x6		/* What is considered a var offset */
#define NOREL    0

#define COMMENT_COL 40

#define PASS1 0			/* Pass 1 (collection) */
#define PASS2 1			/* Pass 2 (output) */
#define PASSF 2			/* Pass F (format extraction) */

/* True if char is good for initial pos in sym id */
#define IS_INITIAL_SYM(C) \
  (((C) >= 'a' && (C) <= 'z') || \
   ((C) >= 'A' && (C) <= 'Z') || \
   (C)== '_' || \
   (C) < 0)			/* ISO 8859-1, upper half */

/* True if char is good for any pos within sym id */
#define IS_INNER_SYM(C) \
  ((C) > ' ' && (C) != ':' && (C) != '=' && (C) != ';' && \
   (C) != '/' && (C) != '#' && (C) != '.' && (C) != '<' && \
   (C) != '>' && (C) != ',' && (C) != '(' && (C) != ')')


/* Xref node */
struct xrefaddr {
  int val;			/* XREF value */
  struct xrefaddr *link;	/* Next in chain */
};


/* This is just so that programs that never will
 * use formats don't have to include format.h
 */
#ifndef _FMT_CONFG_
#define FMT char
#else
#define FMT struct format
#endif


/* Comments are considered to be symbols,
 * and reside in the comment table.
 */
struct symbol {
  int
    val,			/* Symbol value or macro tag */
    ref;			/* Reference counter (for Xref) */

  struct symbol *link;		/* Next symbol */

  union {
    char *str;			/* Symbol ID, comment string, macro def */
    FMT
      *format;			/* Format description */
  }
  s_v;


  unsigned char
    type,			/* T_xxx */
    seq;			/* Sequence counter, or pattern size */

  struct xrefaddr
    *xrefhead,			/* XREF address list */
    *xreftail;
};


#define id s_v.str		/* For symbol/comment reference */
#define form s_v.format		/* For format reference */

#define T_COM_TYPE  7		/* Type field mask */
#define T_COM_MINOR 0		/* Comment is `minor comment' */
#define T_COM_MAJOR 1		/* Comment is `major comment' */
#define T_COM_ISDEF 010		/* Comment was included in listing */
#define T_COM_ERASE 020		/* Comment marked for deletion */

#define T_SYM_TYPE 7		/* Type field mask */
#define T_SYM_CODE 1		/* Symbol is address of code */
#define T_SYM_DATA 2		/* Symbol is address of data */
#define T_SYM_RPL  3		/* Symbol is address of thread */
#define T_SYM_ISDEF 010		/* Symbol listing includes definition */
#define T_SYM_ERASE 020		/* Symbol marked for deletion (during merge) */
#define T_SYM_LOCAL 040		/* Symbol is local */

#define T_FMT_TYPE 7		/* Format type field mask */
#define T_FMT_RPL  1		/* Format is `r', form is NULL */
#define T_FMT_CODE 2		/* Format is `c', form is NULL */
#define T_FMT_AUTO 010		/* Format is auto-generated */

#define T_MACRO	   0		/* Unused, token type */

#define IS_HEX(C)   (hextoi_map[(C) & 0377] >= 0)
#define HEX_TO_I(C) hextoi_map[(C) & 0377]
#define I_TO_HEX(D) hexmap[(D) & 017]


/* 64-bit real. Uses quite a deal of space, but is only used
 * for various data conversions, never really stored anywhere.
 */
typedef struct {
  int x, mr, m, m1, s;
}
hp_real;

typedef hp_real hp_longreal;

#ifndef TRUE
#define FALSE 0
#define TRUE (!FALSE)
#endif


/* Common stuff in misc */
extern
  pc, lineno, ncomments, nsymbols, nlocals,
  opt_lines;

extern char
  hextoi_map[0400], hexmap[];

extern struct symbol
  *comroot, **comref, *symroot, **symref,
  *macroot, **macref;


/* Functions */
extern void
  init(), error(), warning(), print_comfile(), 
  load_symbols(), print_symfile(), disable_intr(),
  add_local_symbol();

extern 
  hexstrtoi(), anystrtoi(), intstrtoi(), comcmp(), symcmp(),
  stringp(), symbolidp(), determine_pc();

extern char
  *strdup(), *byspace(), *realtos(), *local_id(),
  *itobmask();

#endif
