#include "dis48.h"
#include <fcntl.h>

#ifdef notdef
void
StuffNybble(char *mem, NAddr addr, Nybble n)
{
	char	t;
	
	t = mem[addr >> 1] & ((addr & 1) ? 0x0f : 0xf0);
	n &= 0xf;
	if (addr & 1)
		n <<= 4;
		
	mem[addr >> 1] = t | n;
}
#endif

#define NSIZE 524288
#define BSIZE (NSIZE / 2)

Bitmap	completed;
int	dopause = 0;

#ifdef ANSI
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	char	*p;
	int	n;
	int	s, e;
	char	buf[80];
	char	*mem, *malloc();
	
	if ((argc > 1) && !strcmp(argv[1], "-p"))
		dopause = 1;
		
	if ((mem = malloc(BSIZE)) == NULL) {
		fprintf(stderr, "malloc failed\n");
		exit(1);
	}
	
	if ((completed = malloc(BITS(NSIZE))) == NULL) {
		fprintf(stderr, "malloc failed\n");
		goto done;
	}
	
	memset(completed, 0, BITS(NSIZE));
	if ((n = open("rom", O_RDONLY)) < 0) {
		fprintf(stderr, "open failed\n");
		goto done2;
	}
	
	if (read(n, mem, BSIZE) <= 0/* != BSIZE*/) {
		fprintf(stderr, "read failed\n");
		close(n);
		goto done2;
	}
	
	(void) close(n);
	while (1) {
		printf("start?\n");
		if (fgets(buf, sizeof(buf), stdin) == NULL)
			break;
			
		if (sscanf(buf, "%x", &s) != 1)
			break;
			
		printf("end?\n");
		if (fgets(buf, sizeof(buf), stdin) == NULL)
			break;
			
		if (sscanf(buf, "%x", &e) != 1)
			break;
			
		Disassemble(mem, s, e, stdout);
	}
done2:
	free(completed);
done:	
	free(mem);
	exit(0);
}
