/* xalloc - allocate memory, give error message and die if no more
 * Written by Jim McBeath (jimmc) at SCI
 *
 *  3.Jun.86  jimmc
 * 18.Sep.87  jimmc  Add xcalloc
 * 22.Sep.87  jimmc  Allow null msg strings
 *  5.Nov.87  jimmc  Change xalloc to xallocm etc.;
 *			add new xalloc, xcalloc, xrealloc
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include <stdio.h>

#define ERROR_EXIT 1
#define NULLCP (char *)NULL

extern char *malloc(), *calloc(), *realloc();

extern char *Progname;

static int totalused=0;		/* only true if no frees performed */

char *
xalloc( size )
int size;		/* number of bytes to allocate */
{
char *x;

	x = malloc( (unsigned)size );
	if (x==0) xnomem(NULLCP,size);
	totalused += size;
	return x;
}

char *
xallocm( size, msg )
int size;		/* number of bytes to allocate */
char *msg;		/* error string */
{
char *x;

	x = malloc( (unsigned)size );
	if (x==0) xnomem(msg,size);
	totalused += size;
	return x;
}

char *
xcalloc( size )		/* NOTE ARGS NOT SAME AS calloc()! */
int size;		/* number of bytes to allocate */
{
char *x;

	x = calloc( (unsigned)size, 1 );
	if (x==0) xnomem(NULLCP,size);
	totalused += size;
	return x;
}

char *
xcallocm( size, msg )	/* NOTE ARGS NOT SAME AS calloc()! */
int size;		/* number of bytes to allocate */
char *msg;		/* error string */
{
char *x;

	x = calloc( (unsigned)size, 1 );
	if (x==0) xnomem(msg,size);
	totalused += size;
	return x;
}

char *
xrealloc( ptr, size )
char *ptr;		/* old pointer */
int size;		/* number of bytes to allocate */
{
char *x;

	x = realloc( ptr, (unsigned)size );
	if (x==0) xnomem(NULLCP,size);
	totalused += size;	/*** not quite accurate! */
	return x;
}

char *
xreallocm( ptr, size, msg )
char *ptr;		/* old pointer */
int size;		/* number of bytes to allocate */
char *msg;		/* error string */
{
char *x;

	x = realloc( ptr, (unsigned)size );
	if (x==0) xnomem(msg,size);
	totalused += size;	/*** not quite accurate! */
	return x;
}

static
xnomem(msg,size)
char *msg;
int size;
{
char *nomemmsg="No more memory";

	if (msg)
		fprintf(stderr,"\n%s: %s (%s)\n", Progname, nomemmsg, msg);
	else
		fprintf(stderr,"\n%s: %s\n", Progname, nomemmsg);

#if 0	/* not accurate! */
	fprintf(stderr,"Previously used: %d; this request: %d\n",
			totalused, size);
#else
	fprintf(stderr,"Requested memory size: %d\n", size);
#endif
	exit(ERROR_EXIT);
}

/* end */
