/* varsubs.c - set/get variable values for spin
 *
 * 16.Oct.87  jimmc  Initial definition
 * 21.Oct.87  jimmc  Add fset, fdeclare, fget
 *  5.Nov.87  jimmc  Use SPescape instead of SPwerror
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include <strings.h>
#include "xalloc.h"
#include "spin.h"

extern SPtoken *SPexec();

typedef struct _SPvarinfo {
	char *name;	/* name of the variable */
	SPtoken *val;	/* value as a token */
	struct _SPvarinfo *next;
} SPvarinfo;

SPvarinfo *SPvarbase;

static char *badvaruse="BadVarUse";
static char *badvardecl="BadVarDecl";
static char *badvarref="BadVarRef";

SPvarinfo *
sp_iget(name)
char *name;
{
SPvarinfo *vinfo;

	for (vinfo=SPvarbase;vinfo;vinfo=vinfo->next)
		if (strcmp(vinfo->name,name)==0) return vinfo;
	return NIL;
}

static
sp_dodeclare(name)
char *name;
{
SPvarinfo *vinfo;

	vinfo = XALLOCM(SPvarinfo,1,"sp_declare");
	vinfo->next = SPvarbase;
	SPvarbase = vinfo;
	vinfo->name = XALLOCM(char,strlen(name)+1,"declare name");
	strcpy(vinfo->name,name);
	vinfo->val = NIL;
}

int
sp_declare(name)
char *name;
{
SPvarinfo *vinfo;

	vinfo = sp_iget(name);
	if (vinfo) {
		SPescape(badvardecl,"%s already declared",name);
		/* NOTREACHED */
	}
	sp_dodeclare(name);
	return 1;
}

int
sp_fdeclare(name)
char *name;
{

	if (!sp_iget(name)) sp_dodeclare(name);
	return 1;
}

SPtoken *
sp_set(name,value)
char *name;
SPtoken *value;
{
SPvarinfo *vinfo;

	vinfo = sp_iget(name);
	if (!vinfo) {
/* for auto-declaration, simply call sp_declare(name) here instead
 * of delivering the error message */
		SPescape(badvaruse,"variable %s set but not declared",name);
		/* NOTREACHED */
	}
	FREETOKEN(vinfo->val)
	vinfo->val = value;
	return value;
}

SPtoken *
sp_fset(name,value)
char *name;
SPtoken *value;
{
SPvarinfo *vinfo;

	(void)sp_fdeclare(name);
	vinfo = sp_iget(name);
	if (!vinfo) {
/* should never happen, since we called sp_fdeclare first */
		SPescape(badvaruse,"variable %s set but not declared",name);
		/* NOTREACHED */
	}
	FREETOKEN(vinfo->val)
	vinfo->val = value;
	return value;
}

SPtoken *
sp_get(name)
char *name;
{
SPvarinfo *vinfo;

	vinfo = sp_iget(name);
	if (!vinfo) {
		SPescape(badvarref,
			"variable %s referenced but not declared",name);
		/* NOTREACHED */
	}
	return vinfo->val;
}

SPtoken *
sp_fget(name)
char *name;
{
SPvarinfo *vinfo;

	vinfo = sp_iget(name);
	if (!vinfo) return NIL;
	return vinfo->val;
}

SPinitvars()
{
	SPdeffunc("declare","in",sp_declare);
	SPdeffunc("fdeclare","in",sp_fdeclare);
	SPdeffunc("set","lnV",sp_set);
	SPdeffunc("fset","lnV",sp_fset);
	SPdeffunc("get","ln",sp_get);
	SPdeffunc("fget","ln",sp_fget);
}

/* end */
