/* spin.h - application programs using spin should include this file.
 *
 * 16.Oct.87  jimmc  Initial definition
 */

/* xalloc.h must also be included in order to use the ALLOC/FREE macros */

#define NIL 0
#define void int
	/* void is broken */

typedef struct _SPtoken {	/* one token */
	int type;	/* token type */
#define SPTokNil 'N'	/* the NIL type */
#define SPTokInt 'i'
#define SPTokFloat 'f'
#define SPTokStr 's'
#define SPTokName 'n'
#define SPTokList 'l'
#define SPTokLP '('
#define SPTokRP ')'
#define SPTokSM ';'
	union {
		int n;		/* integer values */
		float f;	/* float values */
		char *s;	/* string and name values */
		struct _SPtoken *l;	/* list values */
	} value;
	struct _SPtoken *next;	/* for tokens in a list */
} SPtoken;

extern SPtoken *__tmptoken;	/* for ALLOC and FREE macros */

#define ALLOCTOKEN(_tk_) { \
	_tk_ = XALLOC(SPtoken,1); \
}

#define FREETOKEN(_tk_) { \
	XFREE(_tk_); \
	_tk_ = NIL; \
}

#define FREETOKENLIST(_tk_) { \
	while (_tk_) { \
		__tmptoken = _tk_->next; \
		XFREE(_tk_); \
		_tk_ = __tmptoken; \
	} \
	_tk_ = NIL; \
}

/* end */
