/* listsubs.c - routines which deal with lists for spin
 *
 * 16.Oct.87  jimmc  Initial definition
 * 21.Oct.87  jimmc  Add eval function
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include "xalloc.h"
#include "spin.h"

extern SPtoken *SPcopytoken(), *SPexec();

SPtoken *
sp_quote(list)
SPtoken *list;
{
	return SPcopytoken(list);
}

SPtoken *
sp_eval(list)
SPtoken *list;
{
	return SPexec(list);
}

SPinitlist()
{
	SPdeffunc("quote","LL",sp_quote);
	SPdeffunc("eval","LV",sp_eval);
}


/* convert an integer array into a list
 */
SPtoken *
SPiarrtolist(ac,av)
int ac;		/* size of integer array */
int *av;	/* array of integers to convert to a list */
{
	SPtoken *ap, *next, **app;
	int i;

	ALLOCTOKEN(ap)
	ap->type = SPTokList;
	ap->next = NIL;
	app = &(ap->value.l);
	for (i=0; i<ac; i++) {
		ALLOCTOKEN(next)
		next->type = SPTokInt;
		next->value.n = av[i];
		*app = next;
		app = &(next->next);
	}
	*app = NIL;
	return ap;
}

/* converts a list to an array of ints; mallocs the array and returns
 * a pointer to it.  The list must contain only ints.
 * On error, returns -1.
 */
int		/* returns size of array as value */
SPlisttoiarr(ap,ipp)
SPtoken *ap;
int **ipp;		/* pointer to array pointer for return value */
{
	int i,n;
	int *ip;
	SPtoken *np;

	if (ap->type != SPTokList) return -1;
	n = 0;		/* count the number of ints */
	for (np=ap->value.l; np; np=np->next) {
		if (np->type != SPTokInt) return -1;	/* must be all ints */
		n++;
	}
	ip = XALLOC(int,n);
	for (i=0, np=ap->value.l; i<n; i++, np=np->next) {
		ip[i] = np->value.n;
	}
	*ipp = ip;
	return n;
}

/* end */
