	/* lex - lex routines for spin
	 *
	 * 16.Oct.87  jimmc  Initial definition (taken from ilet)
	 * 21.Oct.87  jimmc  Add NIL token
	 */

	/* definitions */

D	[0-9]
E       [Ee][+-]?{D}+
O	[0-7]
H	[0-9A-Fa-f]
S	[A-Za-z]
s	[A-Za-z0-9_]
W	[ \t\n\f]
w	[ \t\f]
x	[Xx]

%{
#include <ctype.h>
#include <stdio.h>
#include "spin.h"
#include "spinparse.h"
#include "xalloc.h"

#undef input
#undef output
#undef unput

/* a macro to aid debugging */
/* #define RETURN(c) {printf("token %s\n","c");return(c);} */
#define RETURN(c) return(c)

#define malform()   {SPwerror("bad character formation"); \
			SPtokenpval = ""; RETURN(SPTokStr); }
#define collect()   {while(c != '\'' && c != '\n' && c != ';') c = input(); \
                     unput('\n');}

char *SPtokenpval;
int SPtokenival;
float SPtokenfval;

%}
	/* rules follow the next %% */
%%

"/*"		{ for (;;) {	/* slash-star starts comments */
				int c;
				if ((c=input())==0) break;	/* EOF */
				if (c=='*') {
				    if ((c=input())=='/') break;
					/* end of comment */
				    else unput(c);
				    }
				/* continue eating comment */
				}
			  /* now the comment has been eaten */
			  yyleng = 0; yymore(); }
\"		{  /* character string */  /* taken from LISCH1 */
			    register int c ;

			    for(yyleng = 0; c = input(); ++yyleng) {
				switch(c) {
				case '\\':
				    if ((c = input()) == '\n')
					--yyleng ;
				    else {
					unput(c) ;
					yytext[yyleng] = backslash() ;
				    }
				    break ;
				case '\n':
				    SPwerror("bad string format");
				    unput('\n') ;
				    /* fall through */
				case '"':
				    yytext[yyleng] = '\0' ;
				    goto break2 ;
				default:
				    if (isprint(c))
					yytext[yyleng] = c;
				    else
					SPwerror("bad char in string (%3o)",c);
				    break ;
				}
			    }
			break2:
			    SPtokenpval = yytext;
			    RETURN(SPTokStr);
			}
"0"{x}{H}+	{ sscanf( yytext+2, "%x", &SPtokenival);  RETURN(SPTokInt);}
"0"([oO])?{O}+	{ sscanf( yytext, "%o", &SPtokenival); RETURN(SPTokInt); }
"0"[oO]{D}+	{ SPwerror("bad octal integer");
			  SPtokenival = 0; RETURN(SPTokInt); }
{D}+		{ sscanf( yytext, "%d", &SPtokenival); RETURN(SPTokInt); }
{D}+"."{D}*({E})?	|
{D}*"."{D}+({E})?	|
{D}+{E}		{ sscanf( yytext, "%f", &SPtokenfval); RETURN(SPTokFloat); }
{W}+		{ /* ignore white space */ }
"NIL"		{ RETURN(SPTokNil); }
{S}{s}*		{ SPtokenpval = yytext; RETURN(SPTokName); }
"("		{ RETURN(SPTokLP); }
")"		{ RETURN(SPTokRP); }
";"		{ RETURN(SPTokSM); }
"."|[^.]		{ illchar("in input"); }

%%

/* user subroutines */
/* we are supplying our own input routines */

char cstack[256];	/* the unput buffer */
int ccount;		/* number of chars in the unput buffer */
int cindex;		/* index into input line buffer array */
char *cinline;		/* the input line buffer */

SPlexinit(info)
SPstreaminfo *info;
{
	cindex=0;
	cinline = info->SPlinebuf;
	ccount = 0;
}

static
input()
{
	int c;

	if (ccount>0) {
		c = cstack[--ccount];
			/* these are chars pushed back with unput */
	}
	else {		/* no lookahead, get a new char */
		c = cinline[cindex++];
		if (c==0) cindex--;
	}
	return c;
}

/*..........*/

unput(c)
char c;
{

	if ((cindex>0)&&(c==cinline[cindex-1])) {
		/* see if he is putting back the most recent char */
		cindex--;	/* just back up the pointer and counter */
	}
	else	/*** should check for overflow */
		cstack[ccount++] = c;		/* stack up the char */
}

/*..........*/

output(c)
{
	/* this should never be called */
	SPwerror("compiler error: 'output' called with arg %3o",c);
}

/*..........*/

illchar(s)
char *s;
{
	char c;

	c = yytext[yyleng-1];
	if (isprint(c)) SPwerror("illegal char '%c' %s", c, s);
		/* printable chars */
	else SPwerror("illegal char %03o %s", c, s);
		/* non-printing chars */
}

yywrap() { 
	return 1; 
}

backslash()	/* taken from LISCH1 */
{
	register int c ;

	switch(c = input()) {
	case '\\':  
		return('\\') ;
	case 'b':   
		return('\b') ;
	case 'e':   
		return('\033') ;        /* escape */
	case 'f':   
		return('\f') ;
	case 'n':   
		return('\n') ;
	case 'r':   
		return('\r') ;
	case 't':   
		return('\t') ;
	case 'v':   
		return('\013') ;        /* vertical tab */
	case '"':   
		return('"') ;
	case '\'':  
		return('\'') ;
	case '^':
		c = input() ;
		if (isprint(c))
			return(c & ~0140) ;
				/* convert to control char range */
		else {
			unput(c) ;
			return('^') ;
		}
	default:
		if (! isdigit(c))
			return(c) ;
		else {
			int i, n ;
			char buf[4] ;

			buf[0] = c ;
			for (i = 1; i < 3; i++)
				if (! isdigit(buf[i] = input())) {
					unput(buf[i]) ;
					break ;
				}
			buf[i] = '\0' ;
			sscanf(buf, "%o", &n) ;
			return(n) ;
		}
	}
}

/* end */
