static char rcs_stuff[] = "$Id: st.c,v 1.1.1.1 1992/01/03 17:10:25 murf Exp $";
/*LINTLIBRARY*/
/*
 * String Table (Hash) Package
 *
 * Peter Moore
 * University of California, Berkeley
 * 1985
 *  
 * This is a general purpose hash table package.
 */


#ifndef OCTTOOLS_COPYRIGHT_H
#define OCTTOOLS_COPYRIGHT_H
/*
 * Oct Tools Distribution 3.0
 *
 * Copyright (c) 1988, 1989, Regents of the University of California.
 * All rights reserved.
 *
 * Use and copying of this software and preparation of derivative works
 * based upon this software are permitted.  However, any distribution of
 * this software or derivative works must include the above copyright
 * notice.
 *
 * This software is made available AS IS, and neither the Electronics
 * Research Laboratory or the University of California make any
 * warranty about the software, its performance or its conformity to
 * any specification.
 *
 * Suggestions, comments, or improvements are welcome and should be
 * addressed to:
 *
 *   octtools@eros.berkeley.edu
 *   ..!ucbvax!eros!octtools
 */

#if !defined(lint) && !defined(SABER)
#ifdef MCC
static char octtools_copyright[] = "\
Copyright (C) 1988, 1989, Regents of the University of California.  All rights reserved.\n\
Copyright (C) 1989, Microelectronics and Computer Technology Corporation. All rights reserved.";
#else
static char octtools_copyright[] = "Copyright (c) 1988, 1989, Regents of the University of California.  All rights reserved.";
#endif /* MCC */
#endif
#endif 
#ifndef PORT_H
#define PORT_H

#ifdef SABER
#define volatile
#endif

/*
 * int32 should be defined as the most economical sized integer capable of
 * holding a 32 bit quantity
 * int16 should be similarly defined
 */

/* XXX hack */
#ifndef MACHDEP_INCLUDED
#define MACHDEP_INCLUDED
#ifdef vax
typedef int int32;
typedef short int16;
#else
     /* Ansi-C promises that these definitions should always work */
typedef long int32;
typedef int int16;
#endif /* vax */
#endif /* MACHDEP_INCLUDED */


#ifndef __STDC__
#ifndef __DATE__
#ifdef CUR_DATE
#define __DATE__	CUR_DATE
#else
#define __DATE__	"unknown-date"
#endif /* CUR_DATE */
#endif /* __DATE__ */

#ifndef __TIME__
#ifdef CUR_TIME
#define __TIME__	CUR_TIME
#else
#define __TIME__	"unknown-time"
#endif /* CUR_TIME */
#endif /* __TIME__ */
#endif /* __STDC__ */

#ifdef sun386
#define PORTAR
#endif

#include <stdio.h>
#include <ctype.h>
#ifdef macintosh
#include <Types.h>
#else
#include <sys/types.h>
#endif
#undef HUGE
#include <math.h>
#include <signal.h>

#if defined(ultrix)  /* { */
#if defined(_SIZE_T_) /* { */
#define ultrix4
#else		     /* } else { */
#if defined(SIGLOST) /* { */
#define ultrix3
#else                /* } else { */
#define ultrix2
#endif               /* } */
#endif               /* } */
#endif               /* } */

#if defined(ultrix3) && defined(mips)
extern double rint();
extern double trunc();
#endif

#if defined(sun) && defined(FD_SETSIZE)
#define sunos4
#else
#define sunos3
#endif

#if defined(sequent) || defined(news800)
#define LACK_SYS5
#endif

#if defined(ultrix3) || defined(sunos4) || defined(_IBMR2)
#define SIGNAL_FN	void
#else
/* sequent, ultrix2, 4.3BSD (vax, hp), sunos3 */
#define SIGNAL_FN	int
#endif

/* Some systems have 'fixed' certain functions which used to be int */
#if defined(ultrix) || defined(SABER) || defined(hpux) || defined(aiws) || defined(apollo) || defined(__STDC__)
#define VOID_HACK void
#else
#define VOID_HACK int
#endif

#ifndef NULL
#define NULL 0
#endif /* NULL */

/*
 * CHARBITS should be defined only if the compiler lacks "unsigned char".
 * It should be a mask, e.g. 0377 for an 8-bit machine.
 */

#ifndef CHARBITS
#	define	UNSCHAR(c)	((unsigned char)(c))
#else
#	define	UNSCHAR(c)	((c)&CHARBITS)
#endif

#define SIZET int

#ifdef __STDC__
#define CONST const
#define VOIDSTAR   void *
#else
#define CONST
#define VOIDSTAR   char *
#endif /* __STDC__ */


/* Some machines fail to define some functions in stdio.h */
#ifndef __STDC__
extern FILE *popen(), *tmpfile();
extern int pclose();
#ifndef clearerr		/* is a macro on many machines, but not all */
extern VOID_HACK clearerr();
#endif /* clearerr */
#ifndef rewind
#ifndef macintosh
extern VOID_HACK rewind();
#endif
#endif /* rewind */
#endif /* __STDC__ */


/* most machines don't give us a header file for these */
#ifdef __STDC__
#include <stdlib.h>
#else
#ifdef hpux
extern int abort();
extern void free(), exit(), perror();
#else
#ifndef macintosh
extern VOID_HACK abort(), free(), exit(), perror();
#endif
#endif /* hpux */
extern char *getenv(), *malloc(), *realloc(), *calloc();
#ifdef aiws
extern int sprintf();
#else
#ifndef macintosh
extern char *sprintf();
#endif
#endif
extern int system();
extern double atof();
extern long atol();
extern int sscanf();
#endif /* __STDC__ */


/* some call it strings.h, some call it string.h; others, also have memory.h */
#ifdef __STDC__
#include <string.h>
#else
/* ANSI C string.h -- 1/11/88 Draft Standard */
#if defined(ultrix4)
#include <strings.h>
#else
extern char *strcpy(), *strncpy(), *strcat(), *strncat(), *strerror();
extern char *strpbrk(), *strtok(), *strchr(), *strrchr(), *strstr();
extern int strcoll(), strxfrm(), strncmp(), strlen(), strspn(), strcspn();
extern char *memmove(), *memccpy(), *memchr(), *memcpy(), *memset();
extern int memcmp(), strcmp();
#endif /* ultrix4 */
#endif /* __STDC__ */

#ifdef lint
#undef putc			/* correct lint '_flsbuf' bug */
#endif /* lint */

/* a few extras */
extern VOID_HACK srandom();
extern long random();

#if defined(ultrix3)
extern unsigned sleep();
#else
extern VOID_HACK sleep();
#endif

/* assertion macro */

#ifndef assert
#ifdef __STDC__
#include <assert.h>
#else
#ifndef NDEBUG
#define assert(ex) {\
    if (! (ex)) {\
	(void) fprintf(stderr, "Assertion failed: file %s, line %d\n",\
	    __FILE__, __LINE__);\
	(void) fflush(stdout);\
	abort();\
    }\
}
#else
#define assert(ex) {;}
#endif
#endif
#endif

/* handle the various limits */
#if defined(__STDC__) || defined(POSIX)
#include <limits.h>
#else
#define USHRT_MAX	(~ (unsigned short int) 0)
#define UINT_MAX	(~ (unsigned int) 0)
#define ULONG_MAX	(~ (unsigned long int) 0)
#define SHRT_MAX	((short int) (USHRT_MAX >> 1))
#define INT_MAX		((int) (UINT_MAX >> 1))
#define LONG_MAX	((long int) (ULONG_MAX >> 1))
#endif

#endif /* PORT_H */

#include "errtrap.h"
#ifndef UTILITY_H
#define UTILITY_H

/*
 *  assumes the memory manager is libmm.a
 *	- allows malloc(0) or realloc(obj, 0)
 *	- catches out of memory (and calls MMout_of_memory())
 *	- catch free(0) and realloc(0, size) in the macros
 */
#define NIL(type)		((type *) 0)
#define ALLOC(type, num)	\
    ((type *) malloc(sizeof(type) * (num)))
#define REALLOC(type, obj, num)	\
    (obj) ? ((type *) realloc((char *) obj, sizeof(type) * (num))) : \
	    ((type *) malloc(sizeof(type) * (num)))
#define FREE(obj)		\
    if ((obj)) { (void) free((char *) (obj)); (obj) = 0; }


extern long  util_cpu_time();
extern char *util_path_search
	ARGS((char *program));
extern char *util_file_search
	ARGS((char *file, char *path, char *mode));
extern int   util_pipefork
	ARGS((char **argv, FILE **toCommand, FILE **fromCommand));
extern int   util_csystem
	ARGS((char *command));
extern char *util_print_time
	ARGS((long t));
extern char *util_strsav
	ARGS((char *ptr));
extern char *util_tilde_expand
	ARGS((char *filename));

#ifndef NIL_FN
#define NIL_FN(type) ((type (*)()) 0)
#endif /* NIL_FN */

#ifndef MAX
#define MAX(a,b)	((a) > (b) ? (a) : (b))
#endif /* MAX */
#ifndef MIN
#define MIN(a,b)	((a) < (b) ? (a) : (b))
#endif /* MIN */
#ifndef ABS
#define ABS(a)		((a) > 0 ? (a) : -(a))
#endif /* ABS */


#ifdef lint
#undef ALLOC			/* allow for lint -h flag */
#undef REALLOC
#define ALLOC(type, num)	(((type *) 0) + (num))
#define REALLOC(type, obj, num)	((obj) + (num))
#endif /* lint */

#endif

#include "st.h"

#define ST_NUMCMP(x,y) ((int) (x) - (int) (y))
#define ST_NUMHASH(x,size) (ABS((int)x)%(size))
#define ST_PTRHASH(x,size) ((int)((unsigned)(x)>>2)%size)
#define ST_EQUAL(func, x, y) \
    ((((func) == st_numcmp) || ((func) == st_ptrcmp)) ?\
      (ST_NUMCMP((x),(y)) == 0) : ((*func)((x), (y)) == 0))


#define do_hash(key, table)\
    ((table->hash == st_ptrhash) ? ST_PTRHASH((key),(table)->num_bins) :\
     (table->hash == st_numhash) ? ST_NUMHASH((key), (table)->num_bins) :\
     (*table->hash)((key), (table)->num_bins))

char st_pkg_name[] = "st";

/* Possible error conditions */
char *st_no_mem = "out of memory";
char *st_bad_ret = "bad return code from function passed to st_foreach";
char *st_bad_gen = "null or zero generator";

/* Forward declarations */
int st_numhash(), st_ptrhash(), st_numcmp(), st_ptrcmp();
static void rehash();


st_table *st_init_table_with_params(compare, hash, size, density, grow_factor,
				    reorder_flag)
int (*compare)();
int (*hash)();
int size;
int density;
double grow_factor;
int reorder_flag;
/* Detailed table allocator */
{
    st_table *new;

    new = ALLOC(st_table, 1);
    if (!new) {
	errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);
	/* NOTREACHED */
    }
    new->compare = compare;
    new->hash = hash;
    new->num_entries = 0;
    new->max_density = density;
    new->grow_factor = grow_factor;
    new->reorder_flag = reorder_flag;
    if (size <= 0) {
	size = 1;
    }
    new->num_bins = size;
    new->bins = 
	(st_table_entry **) calloc((unsigned)size, sizeof(st_table_entry *));
    if (!new->bins) {
	free((char *) new);
	errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);
	/* NOTREACHED */
    }
    return new;
}

st_table *st_init_table(compare, hash)
int (*compare)();
int (*hash)();
/* Default table allocator */
{
    return st_init_table_with_params(compare, hash, ST_DEFAULT_INIT_TABLE_SIZE,
				     ST_DEFAULT_MAX_DENSITY,
				     ST_DEFAULT_GROW_FACTOR,
				     ST_DEFAULT_REORDER_FLAG);
}
			    

void
st_free_table(table)
st_table *table;
/* Destroy a table */
{
    register st_table_entry *ptr, *next;
    int i;

    for(i = 0; i < table->num_bins ; i++) {
	ptr = table->bins[i];
	while (ptr != NIL(st_table_entry)) {
	    next = ptr->next;
	    free((char *) ptr);
	    ptr = next;
	}
    }
    free((char *) table->bins);
    free((char *) table);
}


#define ST_PTR_NOT_EQUAL(table, ptr, user_key)\
(ptr != NIL(st_table_entry) && !ST_EQUAL(table->compare, user_key, (ptr)->key))

#define FIND_ENTRY(table, hash_val, key, ptr, last) \
    (last) = &(table)->bins[hash_val];\
    (ptr) = *(last);\
    while (ST_PTR_NOT_EQUAL((table), (ptr), (key))) {\
	(last) = &(ptr)->next; (ptr) = *(last);\
    }\
    if ((ptr) != NIL(st_table_entry) && (table)->reorder_flag) {\
	*(last) = (ptr)->next;\
	(ptr)->next = (table)->bins[hash_val];\
	(table)->bins[hash_val] = (ptr);\
    }

int st_lookup(table, key, value)
st_table *table;
register char *key;
char **value;
/* Look up item in table -- return zero if not found */
{
    int hash_val;
    register st_table_entry *ptr, **last;

    hash_val = do_hash(key, table);

    FIND_ENTRY(table, hash_val, key, ptr, last);
    
    if (ptr == NIL(st_table_entry)) {
	return 0;
    } else {
	if (value != NIL(char *))  *value = ptr->record; 
	return 1;
    }
}

#define ADD_DIRECT(table, key, value, hash_val, new)\
{\
    if (table->num_entries/table->num_bins >= table->max_density) {\
	rehash(table);\
	hash_val = do_hash(key,table);\
    }\
    \
    new = ALLOC(st_table_entry, 1);\
    \
    if (new) {\
	new->key = key;\
	new->record = value;\
	new->next = table->bins[hash_val];\
	table->bins[hash_val] = new;\
	table->num_entries++;\
    } else {\
	errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);\
	/* NOTREACHED */ \
    } \
}

int st_insert(table, key, value)
register st_table *table;
register char *key;
char *value;
/* Insert an item into the table - replacing if it already exists */
{
    int hash_val;
    st_table_entry *new;
    register st_table_entry *ptr, **last;

    hash_val = do_hash(key, table);

    FIND_ENTRY(table, hash_val, key, ptr, last);

    if (ptr == NIL(st_table_entry)) {
	ADD_DIRECT(table,key,value,hash_val,new);
	return 0;
    } else {
	ptr->record = value;
	return 1;
    }
}

void st_add_direct(table, key, value)
st_table *table;
char *key;
char *value;
/* Add item to table without checking for existing item */
{
    int hash_val;
    st_table_entry *new;
    
    hash_val = do_hash(key, table);
    ADD_DIRECT(table, key, value, hash_val, new);
}

int st_find_or_add(table, key, slot)
st_table *table;
char *key;
char ***slot;
/* Return slot for key - make one if one doesn't exist */
{
    int hash_val;
    st_table_entry *new, *ptr, **last;

    hash_val = do_hash(key, table);

    FIND_ENTRY(table, hash_val, key, ptr, last);

    if (ptr == NIL(st_table_entry)) {
	ADD_DIRECT(table, key, (char *)0, hash_val, new);
	if (slot != NIL(char **)) *slot = &new->record;
	return 0;
    } else {
	if (slot != NIL(char **)) *slot = &ptr->record;
	return 1;
    }
}

int st_find(table, key, slot)
st_table *table;
char *key;
char ***slot;
/* Finds an entry in table */
{
    int hash_val;
    st_table_entry *ptr, **last;

    hash_val = do_hash(key, table);

    FIND_ENTRY(table, hash_val, key, ptr, last);

    if (ptr == NIL(st_table_entry)) {
	return 0;
    } else {
	if (slot != NIL(char **)) *slot = &ptr->record;
	return 1;
    }
}

static void rehash(table)
register st_table *table;
/* Grows table */
{
    register st_table_entry *ptr, *next, **old_bins = table->bins;
    int i, old_num_bins = table->num_bins, hash_val;

    table->num_bins = table->grow_factor*old_num_bins;
    
    if (table->num_bins%2 == 0) {
	table->num_bins += 1;
    }
    
    table->bins = 
      (st_table_entry **) calloc((unsigned) table->num_bins,
	    sizeof(st_table_entry *));

    if (!table->bins) {
	/* If out of memory: don't resize */
      	table->bins = old_bins;
	table->num_bins = old_num_bins;
	return;
    }
    
    table->num_entries = 0;

    for(i = 0; i < old_num_bins ; i++) {
	ptr = old_bins[i];
	while (ptr != NIL(st_table_entry)) {
	    next = ptr->next;
	    hash_val = do_hash(ptr->key, table);
	    ptr->next = table->bins[hash_val];
	    table->bins[hash_val] = ptr;
	    table->num_entries++;
	    ptr = next;
	}
    }
    free((char *) old_bins);
}

st_table *st_copy(old_table)
st_table *old_table;
{
    st_table *new_table;
    st_table_entry *ptr, *new;
    int i, num_bins = old_table->num_bins;

    new_table = ALLOC(st_table, 1);
    if (new_table == NIL(st_table)) {
	errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);
	/* NOTREACHED */
    }
    
    *new_table = *old_table;
    new_table->bins = 
      (st_table_entry **) calloc((unsigned) num_bins, sizeof(st_table_entry *));
    
    if (new_table->bins == NIL(st_table_entry *)) {
	free((char *) new_table);
	errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);
	/* NOTREACHED */
    }

    for(i = 0; i < num_bins ; i++) {
	new_table->bins[i] = NIL(st_table_entry);
	ptr = old_table->bins[i];
	while (ptr != NIL(st_table_entry)) {
	    new = ALLOC(st_table_entry, 1);
	    if (new == NIL(st_table_entry)) {
		free((char *) new_table->bins);
		free((char *) new_table);
		errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);
		/* NOTREACHED */
	    }
	    *new = *ptr;
	    new->next = new_table->bins[i];
	    new_table->bins[i] = new;
	    ptr = ptr->next;
	}
    }
    return new_table;
}

int st_delete(table, keyp, value)
register st_table *table;
register char **keyp;
char **value;
{
    int hash_val;
    char *key = *keyp;
    register st_table_entry *ptr, **last;

    hash_val = do_hash(key, table);

    FIND_ENTRY(table, hash_val, key, ptr ,last);
    
    if (ptr == NIL(st_table_entry)) {
	return 0;
    }

    *last = ptr->next;
    if (value != NIL(char *)) *value = ptr->record;
    *keyp = ptr->key;
    free((char *) ptr);
    table->num_entries--;
    return 1;
}

int st_foreach(table, func, arg)
st_table *table;
enum st_retval (*func)();
char *arg;
{
    st_table_entry *ptr, **last;
    enum st_retval retval;
    int i;

    for(i = 0; i < table->num_bins; i++) {
	last = &table->bins[i]; ptr = *last;
	while (ptr != NIL(st_table_entry)) {
	    retval = (*func)(ptr->key, ptr->record, arg);
	    switch (retval) {
	    case ST_CONTINUE:
		last = &ptr->next; ptr = *last;
		break;
	    case ST_STOP:
		return 0;
	    case ST_DELETE:
		*last = ptr->next;
		free((char *) ptr);
		ptr = *last;
		break;
	    default:
		errRaise(st_pkg_name, ST_BAD_RET, st_bad_ret);
		/* NOTREACHED */
	    }
	}
    }
    return 1;
}

int st_strhash(string, modulus)
register char *string;
int modulus;
{
    register int val = 0;
    register int c;
    
    while ((c = *string++) != '\0') {
	val = val*997 + c;
    }

    return ((val < 0) ? -val : val)%modulus;
}

int st_numhash(x, size)
char *x;
int size;
{
    return ST_NUMHASH(x, size);
}

int st_ptrhash(x, size)
char *x;
int size;
{
    return ST_PTRHASH(x, size);
}

int st_numcmp(x, y)
char *x;
char *y;
{
    return ST_NUMCMP(x, y);
}

int st_ptrcmp(x, y)
char *x;
char *y;
{
    return ST_NUMCMP(x, y);
}

st_generator *
st_init_gen(table)
st_table *table;
/* Initializes generation of items in table */
{
    st_generator *gen;

    gen = ALLOC(st_generator, 1);
    if (!gen) {
	errRaise(st_pkg_name, ST_NO_MEM, st_no_mem);
	/* NOTREACHED */
    }
    gen->table = table;
    gen->entry = NIL(st_table_entry);
    gen->indx = 0;
    return gen;
}


int 
st_gen(gen, key_p, value_p)
st_generator *gen;
char **key_p;
char **value_p;
/* Generates next item in generation sequence */
{
    register int i;

    if (!gen) {
	errRaise(st_pkg_name, ST_BAD_GEN, st_bad_gen);
	/* NOTREACHED */
    }
    
    if (gen->entry == NIL(st_table_entry)) {
	/* try to find next entry */
	for(i = gen->indx; i < gen->table->num_bins; i++) {
	    if (gen->table->bins[i] != NIL(st_table_entry)) {
		gen->indx = i+1;
		gen->entry = gen->table->bins[i];
		break;
	    }
	}
	if (gen->entry == NIL(st_table_entry)) {
	    return 0;		/* that's all folks ! */
	}
    }
    *key_p = gen->entry->key;
    if (value_p != 0) *value_p = gen->entry->record;
    gen->entry = gen->entry->next;
    return 1;
}


void
st_free_gen(gen)
st_generator *gen;
{
    if (gen) {
	free((char *) gen);
    } else {
	errRaise(st_pkg_name, ST_BAD_GEN, st_bad_gen);
	/* NOTREACHED */
    }
}
