/* starting time is 11:50:27 */
/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -G -k 1,3,4 -p -S 1 -t keys.gperf  */
static char rcs_stuff[] = "$Id: keys.gperf,v 1.2 1992/01/03 17:49:58 murf Exp $";
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include "gedcom.b.tab.h"
extern int lineno;
static char buff[300]; /* Actually, 80 may be enough */
static char *buff_ptr = &buff[0];


FILE *yyin;
struct keyword {	char *name; 	int val; };

#define TOTAL_KEYWORDS 41
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 4
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 155
/* maximum key range = 152, duplicates = 0 */

static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156,  10,  50,  11,  41,  15,
      55,   6,  35,  55, 156, 156,  25,   0,  15,   0,
       1,  40,   0,   0,   6,   5, 156,  10,   5, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156, 156, 156,
     156, 156, 156, 156, 156, 156, 156, 156,
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 4:
        hval += asso_values[str[3]];
      case 3:
        hval += asso_values[str[2]];
      case 2:
      case 1:
        hval += asso_values[str[0]];
    }
  return hval;
}

static struct keyword wordlist[] =
{
      {"",}, {"",}, {"",}, {"",}, 
      {"MARR",  MARR},
      {"SEX",  SEX},
      {"SOUR",  SOUR},
      {"SLGS",  SLGS},
      {"TEMP",  TEMP},
      {"CHR",  CHR},
      {"COMM",  COMM},
      {"PHON",  PHON},
      {"SLGC",  SLGC},
      {"CHAR",  CHAR},
      {"PLAC",  PLAC},
      {"REL",  REL},
      {"NAME",  NAME},
      {"TRLR",  TRLR},
      {"CONT",  CONT},
      {"STAL",  STAL},
      {"NOTE",  NOTE},
      {"TITL",  TITL},
      {"DEST",  DEST},
      {"SUBM",  SUBM},
      {"ADDR",  ADDR},
      {"FAM",  FAM},
      {"FAMS",  FAMS},
      {"BIRT",  BIRT},
      {"DEAT",  DEAT},
      {"BIC",  BIC},
      {"DATE",  DATE},
      {"NUMB",  NUMB},
      {"FAMC",  FAMC},
      {"REFN",  REFN},
      {"FLAG",  FLAG},
      {"QUAL",  QUAL},
      {"BAPL",  BAPL},
      {"WIFE",  WIFE},
      {"ENDL",  ENDL},
      {"HUSB",  HUSB},
      {"HEAD",  HEAD},
      {"CHIL",  CHIL},
      {"FILE",  FILE9},
      {"BURI",  BURI},
      {"INDI",  INDI},
};

struct keyword *
in_word_set (str, len)
     register char *str;
     register unsigned int len;
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
            {
              struct keyword  *resword; 

              switch (key)
                {
                case    4:
                  resword = &wordlist[4]; break;
                case    8:
                  resword = &wordlist[5]; break;
                case    9:
                  resword = &wordlist[6]; break;
                case   10:
                  resword = &wordlist[7]; break;
                case   11:
                  resword = &wordlist[8]; break;
                case   14:
                  resword = &wordlist[9]; break;
                case   15:
                  resword = &wordlist[10]; break;
                case   20:
                  resword = &wordlist[11]; break;
                case   21:
                  resword = &wordlist[12]; break;
                case   25:
                  resword = &wordlist[13]; break;
                case   26:
                  resword = &wordlist[14]; break;
                case   28:
                  resword = &wordlist[15]; break;
                case   34:
                  resword = &wordlist[16]; break;
                case   35:
                  resword = &wordlist[17]; break;
                case   36:
                  resword = &wordlist[18]; break;
                case   39:
                  resword = &wordlist[19]; break;
                case   40:
                  resword = &wordlist[20]; break;
                case   41:
                  resword = &wordlist[21]; break;
                case   51:
                  resword = &wordlist[22]; break;
                case   54:
                  resword = &wordlist[23]; break;
                case   55:
                  resword = &wordlist[24]; break;
                case   58:
                  resword = &wordlist[25]; break;
                case   59:
                  resword = &wordlist[26]; break;
                case   60:
                  resword = &wordlist[27]; break;
                case   61:
                  resword = &wordlist[28]; break;
                case   64:
                  resword = &wordlist[29]; break;
                case   66:
                  resword = &wordlist[30]; break;
                case   69:
                  resword = &wordlist[31]; break;
                case   70:
                  resword = &wordlist[32]; break;
                case   74:
                  resword = &wordlist[33]; break;
                case   75:
                  resword = &wordlist[34]; break;
                case   79:
                  resword = &wordlist[35]; break;
                case   80:
                  resword = &wordlist[36]; break;
                case   84:
                  resword = &wordlist[37]; break;
                case   85:
                  resword = &wordlist[38]; break;
                case   89:
                  resword = &wordlist[39]; break;
                case   90:
                  resword = &wordlist[40]; break;
                case   95:
                  resword = &wordlist[41]; break;
                case   99:
                  resword = &wordlist[42]; break;
                case  109:
                  resword = &wordlist[43]; break;
                case  155:
                  resword = &wordlist[44]; break;
                default: return 0;
                }
              if (*str == *resword->name && !strcmp (str + 1, resword->name + 1))
                return resword;
              return 0;
            }
         }
    }
  return 0;
}


yylex()
{
	struct keyword *kw;
	char *p;
	int i;
	
	if( !(*buff_ptr) )
	{
		int lev;
		if( !fgets(buff,300,yyin) )
		{
			return 0; /* end of file */
		}
		buff[strlen(buff)-1] = 0; /* blast the newline */
		lineno++;
		buff_ptr = &buff[0]; /* get a new line */
		/* the first thing on a line is the level number, get it */
		lev = strtol(buff,&p,10);
		if( p == buff_ptr )
		{
			fprintf(stderr,"No level number at the beginning of the line on line %d\n",
					lineno);
			return LEV0;
		}
		buff_ptr = p;
		return LEV0+lev;
	}
	else
	{
		/* either a type or a reference */
		while(*buff_ptr &&
			  (*buff_ptr == ' ' || *buff_ptr == '\t') )
			buff_ptr++;
		/* collect next token */
		p = buff_ptr;
		while( *buff_ptr && (*buff_ptr != ' ' && *buff_ptr != '\t' &&
							 *buff_ptr != '\n' ) )
			buff_ptr++;
		if( *p == '@' )
		{
			char x,*y;
			
			x = *buff_ptr;
			*buff_ptr = 0;
			p++; /* skip the @ stuff and just pass the ref id */
			yylval.str = (char *)malloc(buff_ptr-p);
			strncpy(yylval.str,p,buff_ptr-p);
			yylval.str[buff_ptr-p-1] = 0; /* leave out the '@'s */
			*buff_ptr = x;
			return REF;
		}
		if( !strncmp(p,"DIV",3) ) /* DIV is a slightly special case ... ? */
		{
			if( *(p+4) == 'Y' ) yylval.num = 1;
			else yylval.num = 0;
			*buff_ptr = 0; /* we are done here */
			return DIV;
		}
		*buff_ptr = 0;
		/* then match on the token, and return the rest of the line as
		   the value */
		/* the tokens are arranged in a ______table. */
		kw = in_word_set(p,strlen(p));
		if( kw )
		{
			*buff_ptr = ' ';
			if( *(buff_ptr+1) == '@' )
			{
				return kw->val;
			}
			setyystr(p);
			*buff_ptr = 0; /* this will reset the lexer and read in a
							  new line next time.... */
			return kw->val;
		}
		else
		{
			/* else report error */
			fprintf(stderr,"HEY, '%s' is not a keyword I understand! (line %d)\n",
					p, lineno);
		}
	}
}


setyystr(txt)
char *txt;
{
	int x=strlen(txt);
	char *y = txt;
	while( *y && *y != ' ' )
		y++;
	if( *y )
	{
		/* there is a space */
		x -= (y-txt);
		y++;
		yylval.str = (char *)malloc(x);
		strcpy(yylval.str,y);
	}
	else
		yylval.str = "";
}

/* ending time is 11:50:27 */
