static char rcs_stuff[] = "$Id: mylex.c,v 1.2 1992/01/03 17:49:59 murf Exp $";
#include <stdio.h>
#include "gedcom.b.tab.h"
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

FILE *yyin;

struct keyword
{
	char *name;
	int val;
};

static struct keyword keylist[] = 
{
	{"ADDR",ADDR},
	{"BAPL",BAPL},
	{"CHAR",CHAR},
	{"COMM",COMM},
	{"CONT",CONT},
	{"DATE",DATE},
	{"DEST",DEST},
	{"ENDL",ENDL},
	{"FILE",FILE9},
	{"FLAG",FLAG},
	{"NAME",NAME},
	{"NOTE",NOTE},
	{"PHON",PHON},
	{"PLAC",PLAC},
	{"QUAL",QUAL},
	{"REL",REL},
	{"SEX",SEX},
	{"SOUR",SOUR},
	{"TEMP",TEMP},
	{"TITL",TITL},
	{"BIC",BIC},
	{"NUMB",NUMB},
	{"REFN",REFN},
	{"BIRT",BIRT},
	{"BURI",BURI},
	{"CHIL",CHIL},
	{"CHR",CHR},
	{"DEAT",DEAT},
	{"FAM",FAM},
	{"FAMC",FAMC},
	{"FAMS",FAMS},
	{"HEAD",HEAD},
	{"HUSB",HUSB},
	{"INDI",INDI},
	{"MARR",MARR},
	{"STAL",STAL},
	{"TRLR",TRLR},
	{"WIFE",WIFE},
	{"SUBM",SUBM},
	{"SLGC",SLGC},
	{"SLGS",SLGS},
	{0,0}
};

extern int lineno;
static char buff[300]; /* Actually, 80 may be enough */
static char *buff_ptr = &buff[0];

yylex()
{
	char *p;
	int i;
	
	if( !(*buff_ptr) )
	{
		int lev;
		if( !fgets(buff,300,yyin) )
		{
			return 0; /* end of file */
		}
		buff[strlen(buff)-1] = 0; /* blast the newline */
		lineno++;
		buff_ptr = &buff[0]; /* get a new line */
		/* the first thing on a line is the level number, get it */
		lev = strtol(buff,&p,10);
		if( p == buff_ptr )
		{
			fprintf(stderr,"No level number at the beginning of the line on line %d\n",
					lineno);
			return LEV0;
		}
		buff_ptr = p;
		return LEV0+lev;
	}
	else
	{
		/* either a type or a reference */
		while(*buff_ptr &&
			  (*buff_ptr == ' ' || *buff_ptr == '\t') )
			buff_ptr++;
		/* collect next token */
		p = buff_ptr;
		while( *buff_ptr && (*buff_ptr != ' ' && *buff_ptr != '\t' &&
							 *buff_ptr != '\n' ) )
			buff_ptr++;
		if( *p == '@' )
		{
			char x,*y;
			
			x = *buff_ptr;
			*buff_ptr = 0;
			p++; /* skip the @ stuff and just pass the ref id */
			yylval.str = (char *)malloc(buff_ptr-p);
			strncpy(yylval.str,p,buff_ptr-p);
			yylval.str[buff_ptr-p-1] = 0; /* leave out the '@'s */
			*buff_ptr = x;
			return REF;
		}
		if( !strncmp(p,"DIV",3) ) /* DIV is a slightly special case ... ? */
		{
			if( *(p+4) == 'Y' ) yylval.num = 1;
			else yylval.num = 0;
			*buff_ptr = 0; /* we are done here */
			return DIV;
		}
		*buff_ptr = 0;
		/* then match on the token, and return the rest of the line as
		   the value */
		/* the tokens are arranged in a ______table. */
		for(i=0; keylist[i].name; i++)
		{
			if( !strcmp(keylist[i].name,p) )
			{
				*buff_ptr = ' ';
				if( *(buff_ptr+1) == '@' )
				{
					return keylist[i].val;
				}
				setyystr(p);
				*buff_ptr = 0; /* this will reset the lexer and read in a
								  new line next time.... */
				return keylist[i].val;
			}
		}
		/* else report error */
		fprintf(stderr,"HEY, '%s' is not a keyword I understand! (line %d)\n",
				p, lineno);
	}
}


setyystr(txt)
char *txt;
{
	int x=strlen(txt);
	char *y = txt;
	while( *y && *y != ' ' )
		y++;
	if( *y )
	{
		/* there is a space */
		x -= (y-txt);
		y++;
		yylval.str = (char *)malloc(x);
		strcpy(yylval.str,y);
	}
	else
		yylval.str = "";
}

