static char rcs_stuff[] = "$Id: gedwrite.c,v 1.2 1992/01/03 17:49:56 murf Exp $";
#include <stdio.h>
#include "gedcom.h"
#include <string.h>
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* output routines */
static struct gedfile *curr_fileg;

void write_gedfile(gf)
struct gedfile *gf;
{
	FILE *f;
	f = fopen(gf->header->file,"w");
	if( !f )
	{
		fprintf(stderr,"Couldn't open %s for writing!\n", gf->header->file);
		return;
	}
	curr_fileg = gf;
	write_header(f,gf->header);
	write_submits(f,gf->submitlist);
	write_individs(f,gf->indlist);
	write_fams(f,gf->famlist);
	fprintf(f,"0 TRLR\n");
	fclose(f);
}

void write_header(f,h)
FILE *f;
struct gheader *h;
{
	
	fprintf(f,"0 HEAD\n");
	if( h->source )
 		fprintf(f,"1 SOUR %s\n",h->source);
	if(h->dest)
  		fprintf(f,"1 DEST %s\n",h->dest);
	if(h->date)
   		fprintf(f,"1 DATE %s\n",h->date);
 	if(h->file)
   		fprintf(f,"1 FILE %s\n",h->file);
 	if(h->charset)
   		fprintf(f,"1 CHAR %s\n",h->charset);
}

void write_submits(f,s)
FILE *f;
struct submitlist *s;
{
	int i;
	for(i=0; i< s->num; i++)
	{
 		fprintf(f,"0 @S%d@ SUBM\n",i);
 		if( s->subm[i]->name )
 			fprintf(f,"1 NAME %s\n",s->subm[i]->name);
		write_address(f,s->subm[i]->addr);
  		if( s->subm[i]->phone )
  			fprintf(f,"1 PHON %s\n",s->subm[i]->phone);
  		write_stake(f,s->subm[i]->stake );
		write_comments(f,s->subm[i]->comments);
	}
}

void write_address(f,a)
FILE *f;
struct address *a;
{
	int i;
	if( !a )
		return;
		
	fprintf(f,"1 ADDR %s\n", a->addr[0]);
	for(i=1; i< a->num; i++)
	{
		fprintf(f,"2 CONT %s\n", a->addr[i]);
	}
}

void write_stake(f,s)
FILE *f;
struct stake *s;
{
	if( !s)
		return;
		
	fprintf(f,"1 STAL\n");
	if( s->name )
		fprintf(f,"2 NAME %s\n", s->name);
	if( s->num )
		fprintf(f,"2 NUMB %d\n",s->num);
}

void write_comments(f,c)
FILE *f;
struct comment *c;
{
	int i;
	
	if( !c )
		return;
	fprintf(f,"1 COMM %s\n", c->line[0]);
	for(i=1; i< c->lines; i++)
	{
		fprintf(f,"2 CONT %s\n",c->line[1]);
	}
}

void write_notes(f,n)
FILE *f;
struct notelist *n;
{
	int i,j;
	if( !n )
		return;
	for(i=0; i< n->notes; i++)
	{
		fprintf(f,"1 NOTE %s\n", n->note[i].line[0]);
		for(j=1; j< n->note[i].lines; j++)
		{
			fprintf(f,"2 CONT %s\n",n->note[i].line[j]);
		}
	}
}

void write_individs(f,indl)
FILE *f;
struct indivlist *indl;
{
	int i;
	struct individ *in;
	
	for(i = 0; i< indl->num; i++ )
	{
		write_ind(f,indl->ind[i]);
	}
}

void write_ind(f,in)
FILE *f;
struct individ *in;
{
		fprintf(f,"0 @I%d@ INDI\n", in->index);
		if( in->name )
			fprintf(f,"1 NAME %s\n", in->name);
		if( in->title )
  			fprintf(f,"1 TITL %s\n", in->title);
		if( in->sex == 'M' || in->sex == 'F' )
			fprintf(f,"1 SEX %c\n",in->sex);
		if( in->givenref )
 			fprintf(f,"1 REFN %s\n", in->givenref);
 		write_datplace(f,1,"BIRT",in->birth);
 		write_datplace(f,1,"CHR",in->christen);
 		write_datplace(f,1,"DEAT",in->death);
  		write_datplace(f,1,"BURI",in->burial);
		write_ordinance(f,1,"BAPL",in->baptism);
 		write_ordinance(f,1,"ENDL", in->endow);
 		write_ordinance(f,1,"SLGC",in->child_to_parent);
		if( in->flag )
 			fprintf(f,"1 FLAG %s\n", in->flag);
		if( in->fams )
		{
			int i;
			for(i=0; i<in->fams->num; i++)
			{
				struct family *fm;
				st_lookup(curr_fileg->families, in->fams->family_refs[i],(char **)&fm);
				fprintf(f,"1 FAMS @F%d@\n", fm->index);
			}
		}
		if( in->famc )
		{
			struct family *fm;
			st_lookup(curr_fileg->families, in->famc,(char **)&fm);
			fprintf(f,"1 FAMC @F%d@\n",fm->index);
		}
		if( in->submitter )
		{
			struct  submitter *s;
			st_lookup(curr_fileg->submits, in->submitter,(char **)&s);
			fprintf(f,"1 SUBM @S%d@\n", s->index);
			if( in->submitter_rel )
				fprintf(f,"2 REL %s\n", in->submitter_rel);
		}
		if( in->destination_flag )
 			fprintf(f,"1 DEST %s\n", in->destination_flag);
		write_notes(f,in->notes);
}

void write_datplace(f,lev,tag,ptr)
FILE *f;
int lev;
char *tag;
struct datplace *ptr;
{
	if( ptr )
	{
		fprintf(f,"%d %s\n", lev, tag);
 		if(ptr->date)
   			fprintf(f,"%d DATE %s\n", lev+1, ptr->date);
 		if(ptr->place)
   			fprintf(f,"%d PLAC %s\n", lev+1, ptr->place);
	}
}

void write_ordinance(f,lev,tag,ptr)
FILE *f;
int lev;
char *tag;
struct ordinance *ptr;
{
	if( ptr )
	{
		if( ptr->val )
			fprintf(f,"%d %s %s\n", lev, tag, ptr->val);
		else
			fprintf(f,"%d %s\n", lev, tag);
 		if(ptr->date)
   			fprintf(f,"%d DATE %s\n", lev+1, ptr->date);
  		if(ptr->temp[0])
    			fprintf(f,"%d TEMP %s\n", lev+1, ptr->temp);
  		if(ptr->qual)
    			fprintf(f,"%d QUAL %s\n", lev+1, ptr->qual);
	}
}

void write_fams(f,faml)
FILE *f;
struct famlylist *faml;
{
	int i;
	struct family *fm;
	
	for(i = 0; i< faml->num; i++ )
	{
		write_fam(f,faml->fam[i]);
	}
}

int deref_ind(ref)
char *ref;
{
	struct individ *i;
	st_lookup(curr_fileg->indiv, ref, (char **)&i);
	return i->index;
}

void write_fam(f,fm)
FILE *f;
struct family *fm;
{
	int i;
	
	fprintf(f,"0 @F%d@ FAM\n", fm->index);
 	if( fm->husb )
     			fprintf(f,"1 HUSB @I%d@\n", deref_ind(fm->husb));
 	if( fm->wife )
     			fprintf(f,"1 WIFE @I%d@\n", deref_ind(fm->wife));
	if( fm->kids )
	{
		for(i=0; i< fm->kids->kids; i++)
		{
			struct child *c;
			c = &fm->kids->kid[i];
 			fprintf(f,"1 CHIL @I%d@\n", deref_ind(c->ref));
			write_ordinance(f,2,"SLGC",c->slgc);
		}
	}
	write_datplace(f,1,"MARR",fm->marriage);
	if( fm->divorce )
 		fprintf(f,"1 DIV Y\n", fm->divorce);
 	if( fm->dest )
 		fprintf(f,"1 DEST %s\n", fm->dest);
 	if( fm->flag )
 		fprintf(f,"1 FLAG %s\n", fm->flag);
	if( fm->submitter )
	{
		struct  submitter *s;
		st_lookup(curr_fileg->submits, fm->submitter,(char **)&s);
		fprintf(f,"1 SUBM @S%d@\n", s->index);
		if( fm->submitter_rel )
			fprintf(f,"2 REL %s\n", fm->submitter_rel);
	}
}

