static char rcs_stuff[] = "$Id: gedmerge.c,v 1.2 1992/01/03 17:49:55 murf Exp $";
#include <stdio.h>
#include "gedcom.h"
#include <ctype.h>
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* all the merges will try to take stuff in b and "add it" to a. */

void merge_strings(a,b,what)
char **a,**b,*what;
{
	if( *a && *b && strcmp(*a,*b) )
		fprintf(stderr,"!!!!! %ss differ.... ref=%s, addit=%s\n", 
				what,*a,*b);
	else if( !(*a) && (*b) )
	{
		*a = *b;
		*b=0; /* at the same time, take away from b */
		fprintf(stderr,"added %s to ref (%s)\n", what, *a);
	}
}

void merge_datplace(a,b)
struct datplace **a,**b;
{
	if( !(*a) && !(*b) ) /* neither has any */
		return;
	if( !(*b) ) /* a has something and b does not */
		return;
	if( !(*a) && *b)
	{
		/* b has some, add to a */
		*a = Calloc(struct  datplace);
	}
	merge_strings(&(*a)->date,&(*b)->date,"date");
	merge_strings(&(*a)->place,&(*b)->place,"place");
}

void merge_ordinance(a,b)
struct ordinance **a,**b;
{
	if( !(*a) && !(*b) ) /* neither has any */
		return;
	if( !(*b) ) /* a has something and b does not */
		return;
	if( !(*a) && *b)
	{
		/* b has some, add to a */
		*a = Calloc(struct  ordinance);
	}
	merge_strings(&(*a)->date,&(*b)->date,"date");
	merge_strings(&(*a)->qual,&(*b)->qual,"qualifier");
	merge_strings(&(*a)->val,&(*b)->val,"temple ord desc");
	if( (*a)->temp[0] && (*b)->temp[0] && strcmp((*a)->temp,(*b)->temp) )
		fprintf(stderr,"!!!!! temples differ... ref=%s, addit=%s\n",
					(*a)->temp,(*b)->temp);
}

void merge_notes(a,b)
struct notelist **a,**b;
{
	int i,j,k,match;
	
	if( !(*a) && !(*b) ) /* neither has any */
		return;
	if( !(*b) ) /* a has something and b does not */
		return;
	if( !(*a) && *b)
	{
		/* b has some, add to a */
		*a = Calloc(struct  notelist);
	}
	/* only copy in notes not an exact duplication of previous
	     notes */
	for(i=0; i < (*b)->notes; i++)
	{
		for(match=0,j=0; j < (*a)->notes; j++)
		{
			/* either every comment entry in b matches every
			comment entry in a or, the note in b can be added to a */
			if( (*a)->note[j].lines != (*b)->note[i].lines )
			{
				continue;
			}
				
			for(k=0; k < (*a)->note[j].lines; k++)
			{
				if( strcmp((*a)->note[j].line[k], (*b)->note[i].line[k]))
				{
					match = -1;
					break;
				}
			}
			if( !match )
			{
				/* I know this is confusing, but the above loop will turn
				   out a -1 if it sees a non-match. if it sees no non-matches
				   it will drop out without changing match. This means a
				   match with match zero. Apply an inverter: */
				match  = 1;
				break;
			}
		} /* j for loop */
		if ( !match )
		{
			/* no match, so add this morsel of b into a */
			if( (*a)->notes )
				(*a)->note = (struct comment *)realloc((*a)->note,
								   sizeof(struct comment)*((*a)->notes+1));
			else
				(*a)->note = Calloc(struct comment);
			(*a)->note[(*a)->notes].lines = (*b)->note[i].lines;
			(*a)->note[(*a)->notes].line = (*b)->note[i].line;
			/* make the transfer of information complete */
			(*b)->note[i].lines = 0;
			fprintf(stderr,"added note to ref database, '%s.....'\n",
				(*a)->note[(*a)->notes].line[0]);
			(*a)->notes++;
		}
	}
}

void merge_address(a,b)
struct address **a,**b;
{
/* since addresses are only in the submission stuff, 
leave it alone */
}

void merge_stake(a,b)
struct stake **a,**b;
{
/* since stake info are only in the submission stuff, leave it */
}

void merge_comment(a,b)
struct comment **a,**b;
{
	int i,j,different;
	
	if( !(*a) && !(*b) ) /* neither has any */
		return;
	if( !(*b) ) /* a has something and b does not */
		return;
	if( !(*a) && *b)
	{
		/* b has some, add to a */
		*a = Calloc(struct  comment);
	}
	/* all the lines of a comment match, or the comment in b is
	     added to a */
	if( (*a)->lines != (*b)->lines )
		different = 1;
	else 
		different = 0;
	
}

void upcase(str)
char *str;
{
	char *p,toupper();
	p = str;
	while( *p )
	{
		if( islower(*p) )
			*p = toupper(*p);
		p++;
	}
}

int my_strcmp(a,b)
char *a,*b;
{
	char buf1[300],buf2[300];
	
	strcpy(buf1,a);
	strcpy(buf2,b);
	upcase(buf1);
	upcase(buf2);
	return(strcmp(buf1,buf2));
}

int same_individual(a,b)
struct individ *a,*b;
{
	/* this routine is trying to determine if two seperate individuals
	could be considered to be the same person. */
	/* the name MUST match -- if not, edit the input files
	      and try again.........!*/
	if( a->birth && b->birth )
	{
		if(a->birth->date && b->birth->date )
		{
			if( my_strcmp(a->birth->date, b->birth->date) )
				return 0;
		}
	}
	else
		return 0;
	if( a->title && !b->title || !a->title && b->title )
		return 0;
	if( a->title && b->title && my_strcmp(a->title,b->title) )
		return 0;
	if( !my_strcmp(a->name, b->name) )
		return 1;
	else 
		return 0;
}
void merge_fams(a,b)
struct family *a,*b;
{
	fprintf(stderr,"*****Merging data for Family %s...\n", a->ref);
	merge_datplace(&a->marriage,&b->marriage);
	merge_ordinance(&a->sealspouse,&b->sealspouse);
}

void merge_individ(a,b)
struct individ *a,*b;
{
	fprintf(stderr,"*****Merging data for %s...\n", a->name);
	/* it is assumed these individuals are supposed to be the same
	   person. merge the data within each into "a" */
	merge_strings(&a->name,&b->name,"name");
	merge_strings(&a->title,&b->title, "title");
	merge_strings(&a->givenref, &b->givenref,"ref");
	merge_strings(&a->flag,&b->flag,"flag");
	merge_notes(&a->notes,&b->notes);
	merge_datplace(&a->birth,&b->birth);
	merge_datplace(&a->christen,&b->christen);
	merge_datplace(&a->death,&b->death);
	merge_datplace(&a->burial,&b->burial);
	merge_ordinance(&a->baptism,&b->baptism);
	merge_ordinance(&a->endow,&b->endow);
	merge_ordinance(&a->child_to_parent,&b->child_to_parent);
	if( !a->sex && b->sex )
		a->sex = b->sex;
	else if( a->sex != b->sex )
		fprintf(stderr,"!!!!! He or She? Sex mismatch! ref = %s, addit= %s\n", a->name, b->name);
}

merge_dbs(ged1,ged2)
struct gedfile *ged1,*ged2;
{
	int i,overlapi,overlapf,numinds,numfams;
	struct individ *ind1,*ind2;
	struct family *fam1,*fam2;
	overlapi=overlapf=numinds=numfams = 0;
	
	for(i=0; i < ged1->indlist->num; i++)
	{
		if( ged1->indlist->ind[i]->corr.match_ind )
		{
			ind1 = ged1->indlist->ind[i];
			ind2 = ged2->indlist->ind[ind1->corr.index];
			merge_individ(ind1,ind2);
			overlapi++;
		}
		numinds++;
	}
	for(i=0; i < ged1->famlist->num; i++)
	{
		if( ged1->famlist->fam[i]->corr.match_ind )
		{
			fam1 = ged1->famlist->fam[i];
			fam2 = ged2->famlist->fam[fam1->corr.index];
			merge_fams(fam1,fam2);
			overlapf++;
		}
		numfams++;
	}
	fprintf(stderr,"upon completion of data merging, the ref database\n\
now holds %d individuals and %d families, with %d individs and %d fams \n\
overlapping between databases\n", numinds, numfams, overlapi, overlapf);
}


