static char rcs_stuff[] = "$Id: gedfuncs.c,v 1.2 1992/01/03 17:49:52 murf Exp $";
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include "gedcom.h"

static int refnum = 0;

int deref_ind2(ged,ref,ind)
struct gedfile *ged;
char *ref;
struct individ **ind;
{
	st_lookup(ged->indiv, ref, (char **)ind);
	return (*ind)->index;
}

int deref_fam2(ged,ref,fam)
struct gedfile *ged;
struct family **fam;
char *ref;
{
	st_lookup(ged->families, ref, (char **)fam);
	return (*fam)->index;
}

print_family(ged,fam)
struct gedfile *ged;
struct family *fam;
{
	struct individ *a,*b;
	char *an,*bn, *ar, *br;
	int i;
	
	an = bn = ar = br = 0;
	
	if( fam->husb )
	{
		deref_ind2(ged, fam->husb, &a);
		an = a->name;
		ar = a->ref;
	}
	if( fam->wife )
	{
		deref_ind2(ged, fam->wife, &b);
		bn = b->name;
		br = b->ref;
	}
	fprintf(stderr,"   FAM %s [%s(%s)<=>%s(%s)] (", fam->ref, an, ar, bn, br);
	for(i = 0; fam->kids && i< fam->kids->kids; i++ )
	{
		deref_ind2(ged, fam->kids->kid[i].ref, &a );
		an = a->name;
		ar = a->ref;
		fprintf(stderr,"%s(%s), ", an, ar);
	}
	fprintf(stderr,")\n");
}

print_matching_family(ged1,ged2,fam1,fam2)
struct gedfile *ged1,*ged2;
struct family *fam1,*fam2;
{
	struct individ *a,*b;
	char *as,*bs,c;
	
	
	fprintf(stderr,"                 (%s)   Ref Fam        Addit Family (%s)\n",
			fam1->ref,fam2->ref);
	if( fam1->husb )
	{
		deref_ind2(ged1,fam1->husb,&a);
		as = a->name;
	}
	else
	{
		a = 0;
		as = "(nil)";
	}
	if( fam2->husb )
	{
		deref_ind2(ged2,fam2->husb,&b);
		bs = b->name;
	}
	else
	{
		b = 0;
		bs = "(nil)";
	}
	if( a && b && a->corr.index == b->index && b->corr.index == a->index )
		c = '=';
	else
		c = '*';
	fprintf(stderr,"Hus %30.30s <%c> %-30.30s\n",as,c,bs);
	if( fam1->wife )
	{
		deref_ind2(ged1,fam1->wife,&a);
		as = a->name;
	}
	else
	{
		a=0;
		as = "(nil)";
	}
	if( fam2->wife )
	{
		deref_ind2(ged2,fam2->wife,&b);
		bs = b->name;
	}
	else
	{
		b = 0;
		bs = "(nil)";
	}
	if( a && b && a->corr.index == b->index && b->corr.index == a->index )
		c = '=';
	else
		c = '*';
	fprintf(stderr,"Wif %30.30s <%c> %-30.30s\n",as,c,bs);
			
}


print_non_matches(ged)
struct gedfile *ged;
{
	int i;
	
	for(i=0; i < ged->indlist->num; i++)
	{
		if( !ged->indlist->ind[i]->corr.match_ind )
		{
			fprintf(stderr,"%s(%s)\n",
					ged->indlist->ind[i]->name,
					ged->indlist->ind[i]->ref);
		}
	}
	for(i=0; i < ged->famlist->num; i++)
	{
		if( !ged->famlist->fam[i]->corr.match_ind )
		{
			print_family(ged,ged->famlist->fam[i]);
		}
	}
}

print_matches(ged1, ged2)
struct gedfile *ged1, *ged2;
{
	int i,j,k;
	for(i=0; i < ged1->indlist->num; i++)
	{
		if( ged1->indlist->ind[i]->corr.match_ind )
		{
			fprintf(stderr,"%s(%s) <=> %s(%s)\n",
					ged1->indlist->ind[i]->name,
					ged1->indlist->ind[i]->ref,
					ged2->indlist->ind[ged1->indlist->ind[i]->corr.index]->name,
					ged2->indlist->ind[ged1->indlist->ind[i]->corr.index]->ref);
		}
	}
	
	fprintf(stderr,"FAMILY MATCHES FOUND:\n");
	
	for(i=0; i < ged1->famlist->num; i++)
	{
		if( ged1->famlist->fam[i]->corr.match_ind )
		{
			print_family(ged1,ged1->famlist->fam[i]);
			fprintf(stderr,"  <=Matches=>\n");
			print_family(ged2,ged2->famlist->fam[ged1->famlist->fam[i]->corr.index]);
			fprintf(stderr,"\n");
		}
	}

	fprintf(stderr,"Non-Matchings: REF\n");
	print_non_matches(ged1);
	fprintf(stderr,"\n\nNon-Matches: ADDITIONAL\n");
	print_non_matches(ged2);
}



int group_tree(gedfile)
struct gedfile *gedfile;
{
  /* this routine will determine how many unrelated "groups" are in the database.
	These groups have no apparent ancestral connections. It may be that they overlap. */
	/* the routine first creates a "pool" of individuals, picks the first one in the pool,
	and then recursively plucks every spouse, child, relative, etc out of the pool, until the
	links are completely traversed. This is the first group. If any remain in the pool, the same
	is repeated on the survivors until the search is exhausted. This is repeated until the pool is
	emptied. The number of times this is repeated is the number of groups in the pool. */
	return 0;
}

make_fams_match(ged1,ged2,famc1,famc2)
struct gedfile *ged1,*ged2;
struct family *famc1,*famc2;
{
	/* the safe version of this checks to see if there's already something here, and breaks the
	   old connection first */
	fprintf(stderr,"Matching FAM %s and %s\n",famc1->ref,famc2->ref);
	print_family(ged1,famc1);
	print_family(ged2,famc2);
	if( famc1->corr.match_ind && famc2->corr.match_ind && famc1->corr.index == famc2->index )
		return; /* already done! */
	if( famc1->corr.match_ind )
	{
		fprintf(stderr,"A link matching ref family %s with addtl %s is being broken\n\
in favor of linking %s with %s.\n", famc1->ref,
				ged2->famlist->fam[famc1->corr.index]->ref,
				famc1->ref, famc2->ref);
		ged2->famlist->fam[famc1->corr.index]->corr.match_ind = 0;
	}
	if( famc2->corr.match_ind )
	{
		fprintf(stderr,"A link matching family addtl %s with ref %s is being broken\n\
in favor of linking %s with %s.\n", famc2->ref,
				ged1->famlist->fam[famc2->corr.index]->ref,
				famc1->ref, famc2->ref);
		ged1->famlist->fam[famc2->corr.index]->corr.match_ind = 0;
	}
	famc1->corr.match_ind = 1;
	famc2->corr.match_ind = 1;
	famc1->corr.index = famc2->index;
	famc2->corr.index = famc1->index;
}

make_inds_match(ged1,ged2,ind1,ind2)
struct gedfile *ged1,*ged2;
struct individ *ind1,*ind2;
{
	/* the safe version of this checks to see if there's already something here, and breaks the
	   old connection first */
	fprintf(stderr,"Matching IND %s(%s) and %s(%s)\n",ind1->ref,ind1->name,
			ind2->ref,ind2->name);
	
	if( ind1->corr.match_ind && ind2->corr.match_ind && ind1->corr.index == ind2->index )
		return; /* already done! */
	if( ind1->corr.match_ind )
	{
		fprintf(stderr,"A link matching ref %s(%s) with addtl %s (%s) is being broken\n\
in favor of linking %s (%s) with %s (%s).\n", ind1->name,ind1->ref,
				ged2->indlist->ind[ind1->corr.index]->name,
				ged2->indlist->ind[ind1->corr.index]->ref,
				ind1->name,ind1->ref, ind2->name,ind2->ref);
		ged2->indlist->ind[ind1->corr.index]->corr.match_ind = 0;
	}
	if( ind2->corr.match_ind )
	{
		fprintf(stderr,"A link matching addtl %s(%s) with ref %s (%s) is being broken\n\
in favor of linking %s (%s) with %s (%s).\n", ind2->name,ind2->ref,
				ged1->indlist->ind[ind2->corr.index]->name,
				ged1->indlist->ind[ind2->corr.index]->ref,
				ind1->name,ind1->ref, ind2->name,ind2->ref);
		ged1->indlist->ind[ind2->corr.index]->corr.match_ind = 0;
	}
	ind1->corr.match_ind = 1;
	ind2->corr.match_ind = 1;
	ind1->corr.index = ind2->index;
	ind2->corr.index = ind1->index;
}

match_kids_spouses(ged1,ged2,ind1,ind2)
struct gedfile *ged1,*ged2;
struct individ *ind1,*ind2;
{
	struct family *fams1,*fams2;
	int i,j,k,match_found;
	/* when we match the kids, checking the famc is out, as we
	   got to them from there, so the inds that are kids have only
	   one significant traversal: the fams in which they are spouses */
	/* this is a bit tricky, as people can have multiple fams's. */
	/* try and match each spouse of ind2 to one of ind1. When we
	   find one, then we can match the individs AND the fam involved */
	/* if one exists for ind2 that does not for ind1, then...
	   we have to add */
	if( ind2->fams )
	{
		struct family *fams1,*fams2;
		char *sp1,*sp2;
		struct individ *inds1,*inds2;
		
		/* find a match of spouses between the two, and the families will correspond */
		/* you can them do a match_families call on the pair */
		/* But find the spouse pair. Ugh */
		for(i=0;i < ind2->fams->num; i++)
		{
			int found = 0;
			
			deref_fam2(ged2, ind2->fams->family_refs[i], &fams2);
			if( fams2->corr.match_ind )
			{
				continue; /* already matched */
			}
			sp2 = (ind2->sex == 'M' ? fams2->wife : fams2->husb );
			if( !sp2 )
				continue;
			deref_ind2(ged2, sp2, &inds2 );
			for(j=0; ind1->fams && j < ind1->fams->num; j++)
			{
				deref_fam2(ged1, ind1->fams->family_refs[j], &fams1);
				if( fams1->corr.match_ind  )
					continue; /* they already are spoken for? */
				/* we have taken care of the "already match" conditions,
				   now see if they DO match */
				sp1 = (ind1->sex == 'M' ? fams1->wife : fams1->husb );
				if( !sp1 )
					continue;
				
				deref_ind2(ged1, sp1, &inds1 );
				
				if( same_spouse(inds1,inds2) )
				{
					/* mark them as matching */
					make_inds_match(ged1,ged2,inds1,inds2);
					make_fams_match(ged1,ged2,fams1,fams2);
					match_families(ged1,ged2,fams1);
					found = 1;
					break; /* go to the next person in ged1 */
				}
			}
			if( !found )
			{
				/* here we have the case where this spouse isn't in the list? It would
				   seem maybe we just couldn`t match individs, but, here goes */
				/* add this spouse and the family to boot */
				fprintf(stderr,"%%%% Could not match spouse for %s %%%%\n",
						inds2->name);
				if( inds2->corr.match_ind )
				{
					/* there is a corresponding spouse in the ref database, so just
					   hook up to them */
					/* HA! the family in which this person is a spouse to this person
					   may not exist in this database ! */
					
				}
				else
				{
					char buf1[100],*bp;
					
					sprintf(buf1,"IADDIT%d",refnum++);
					bp = (char *)malloc(strlen(buf1)+1);
					strcpy(bp,buf1);
					inds1 = set_ind(ged1,bp,inds2);  /* create and register the new individual in the ged1 */
					inds1->famc = 0;
					inds1->fams = 0;
					inds1->corr.match_ind = 1;
					inds2->corr.match_ind = 1;
					inds1->corr.index = inds2->index;
					inds2->corr.index = inds1->index;
					
					sprintf(buf1,"FADDIT%d",refnum++);
					bp = (char *)malloc(strlen(buf1)+1);
					strcpy(bp,buf1);
					fams1 = set_fam(ged1,bp,fams2);  /* create and register the new family in the ged1 */
					if( inds1->sex == 'M' )
					{
						fams1->husb = inds1->ref;
						fams1->wife = ind1->ref;
					}
					else
					{
						fams1->husb = ind1->ref;
						fams1->wife = inds1->ref;
					}
					fams1->kids = 0;
					fams1->corr.match_ind = 0;
					fams1->corr.match_fam = 0;
					add_spouse(inds1,fams1->ref);
					add_spouse(ind1, fams1->ref);
					make_fams_match(ged1,ged2,fams1,fams2);
					match_families(ged1,ged2,fams1);
				}
			}
		}
	}
}


match_kids_families(ged1,ged2,ind1,ind2)
struct gedfile *ged1,*ged2;
struct individ *ind1,*ind2;
{
	struct family *famc1,*famc2;
	int i,j,k;
	
	if( ind1->famc && ind2->famc)
	{
		deref_fam2(ged1,ind1->famc,&famc1);
		deref_fam2(ged2,ind2->famc,&famc2);
		make_fams_match(ged1,ged2,famc1,famc2);
		match_families(ged1,ged2,famc1);
	}
	else if( ind2->famc)
	{
		char buf1[100],*bp;
		/* hey, the additional database can take a generation further */
		
		deref_fam2(ged2,ind2->famc,&famc2);
		/* recreate the family in which this person is the kid in the ref database */
		
		sprintf(buf1,"FADDIT%d",refnum++);
		bp = (char *)malloc(strlen(buf1)+1);
		strcpy(bp,buf1);
		famc1 = set_fam(ged1,bp,famc2);  /* create and register the new family in the ged1 */
		famc1->wife = 0;
		famc1->husb = 0;
		famc1->kids = 0;
		famc1->corr.index = 0;
		famc1->corr.match_ind = 0;
		famc1->corr.match_fam = 0;
		make_fams_match(ged1,ged2,famc1,famc2);
		match_families(ged1,ged2,famc1);
	}
	match_kids_spouses(ged1,ged2,ind1,ind2);
}


check_match_in_fam(ged1,ged2,ind1,ind2,fam1,fam2,they_are,match_kids)
struct gedfile *ged1,*ged2;
struct individ *ind1,*ind2;
struct family *fam1,*fam2;
char *they_are;
int match_kids;
{
	if( !ind1->corr.match_ind && ind2->corr.match_ind
	   || !ind2->corr.match_ind && ind1->corr.match_ind
	   || ind1->corr.match_ind && ind2->corr.match_ind
	   && ind1->corr.index != ind2->index )
	{
		fprintf(stderr,"Family %s says that reference data %s (%s)\n\
should be equivalent to additional data %s (%s), because they are %s\n\
in these respective families. Am going to force them to correspond.\n",
				fam1->ref, ind1->name,ind1->ref, ind2->name,ind2->ref,they_are);
		/* pull apart the existing match */
	}
	make_inds_match(ged1,ged2,ind1,ind2);
}

same_kid(ged,fam1,a,b)
struct gedfile *ged;
struct family *fam1;
struct individ *a,*b;
{
	/* this routine is trying to determine if two seperate individuals
	   could be considered to be the same person, in the context of their
	   existing within two seperate families as kids, where the families are
	   considered to be equivalent */
	if( a->birth && b->birth )
	{
		if(a->birth->date && b->birth->date )
		{
			if( !my_strcmp(a->birth->date, b->birth->date) )
			{
				/* a birthdate can match an individual all by itself,
				   except in the case of twin/trips/etc. How many other
				   kids have this same birthday in the family? */
				int i,count;
				count = 0;
				for(i=0;i<fam1->kids->kids;i++)
				{
					struct individ *indx;
					deref_ind2(ged,fam1->kids->kid[i].ref,&indx);
					if( indx->birth && indx->birth->date
					   && !strcmp(indx->birth->date,a->birth->date) )
					{
						count++;
					}
				}
				if( count < 2 )
					return 1;
			}
		}
	}
	if( !my_strcmp(a->name, b->name) )
		return 1;
	else 
		return 0;
}

same_spouse(a,b)
struct individ *a,*b;
{
	/* this routine is trying to determine if two seperate individuals
	   could be considered to be the same person, in the context of their
	   existing within two seperate families as kids, where the families are
	   considered to be equivalent */
	if( a->birth && b->birth )
	{
		if(a->birth->date && b->birth->date )
		{
			if( !my_strcmp(a->birth->date, b->birth->date) )
			{
				/* a birthdate can match an individual all by itself,
				   except in the case of twin/trips/etc. How many other
				   kids have this same birthday in the family? */
				return 1;
			}
		}
	}
	if( !my_strcmp(a->name, b->name) )
		return 1;
	else 
		return 0;
}

static st_table *famtab = 0;

	
match_families(ged1,ged2,fam1)
struct gedfile *ged1,*ged2;
struct family *fam1;
{
	struct family *fam2,*ofam1,*ofam2;
	struct individ *ind1,*ind2,*husb1,*husb2,*wife1,*wife2;
	int i,j,k;
	struct family *famc1,*famc2;
	char buf1[20],*bp;

	if( !famtab )
		famtab = st_init_table(st_ptrcmp, st_ptrhash);
	if( st_lookup(famtab, fam1, 0) )
		return;
	st_insert(famtab, fam1, 0);
	
	fam2 = ged2->famlist->fam[fam1->corr.index];
	/* between the two families, the husbands correspond, and
	   the wives correspond, and the kids do, too, to some extent, in that
	   they may not occur in the same order, and the ref database may or may not
	   have them while the additional database does/doesn't. If the additional has
	   more than the ref, add the info from the other database. */
	/* husband */
	if(!fam1->husb && fam2->husb)
	{
		/* the additional database has more than the ref. Insert a copy */
		deref_ind2(ged2,fam2->husb,&ind2);
		husb2 = ind2;
		if(ind2->corr.match_ind)
		{
			/* this individual, the husband in this family, has a match in the ref
			   data. But the one in the ref isn't registered as a husband in this
			   family! */
			/* But that's cool, as long as he's not a husband somewhere else?
			   What if this is one of his families in which he could have been the
			   husband thru divorce, etc.....*/
			/* I guess just add this family to his list in the ref database */
			ind1 = ged1->indlist->ind[ind2->corr.index];
			fprintf(stderr,"The additional database reports %s[%s] as being a husband\n\
in family %s, but family %s in the ref database has no husband. I'm making %s the husband\n\
in the ref database to match.\n",
					ind2->name,ind2->ref, fam2->ref, fam1->ref, ind1->name);
			fam1->husb = ind1->ref;
			add_spouse(ind1,fam1->ref);
			/* of these two men, equate the families they are kids in */
			/* Well, that'd have to be done already, after all, the corr's
			   said they were each other -- at any rate, something else
			   may pick this up.....  ???????? */
			husb1 = ind1;
		}
		else
		{
			/* in this case, fam2 has a hub that fam1 doesn't, and an ind that
			   ged1 doesn't. So, it would be smart to add this ind to ged1, and
			   copy the info from ind2 to this new individ, and give him the
			   family spouse relationship that ged2 did. */
			sprintf(buf1,"IADDIT%d",refnum++);
			bp = (char *)malloc(strlen(buf1)+1);
			strcpy(bp,buf1);
			ind1 = set_ind(ged1,bp,ind2);  /* create and register the new individual in the ged1 */
			ind1->fams = 0;
			ind1->famc = 0;
			ind1->corr.match_ind = 1;
			ind2->corr.match_ind = 1;
			ind1->corr.index = ind2->index;
			ind2->corr.index = ind1->index;
			ind1->famc = 0;
			add_spouse(ind1, fam1->ref);
			fam1->husb = bp;
			husb1 = ind1;
			/* in this case the ind's refs to the family in which he is a child  are just copied from
			   ged2. This needs to be fixed */
			/* how? copy in the family! zero out the kids. force ind2's fam and this one to correspond.
			   Recurse on match_family */
		}
		if( ind2->famc )
		{
			deref_fam2(ged2,ind2->famc,&famc2);
			if( famc2->corr.match_ind )
			{
				famc1 = ged1->famlist->fam[famc2->corr.match_ind];
				deref_fam2(ged1,ind1->famc,&famc1);
				/* link up to the corresponding family -- shouldn't happen much. */
				fprintf(stderr,"LINKUP**** unusual path *****\nfamc2 = %s, matchind = %d\n",
						famc2->ref, famc2->corr.index);
				if( ind1->famc )
				{
					struct family *famcc1;

					famcc1 = famc1;
					
					deref_fam2(ged1,ind1->famc,&famc1);
					if( famcc1 != famc1 )
						fprintf(stderr,"HOOOBOOOOOOY\n");
				}
				else
				{
					/* the fam is there, so ref it */
					struct child *c;
					c = Calloc(struct child);
					c->ref = ind1->ref;
					add_child(famc1,c);
					ind1->famc = famc1->ref;
				}
				make_fams_match(ged1,ged2,famc1,famc2);
				match_families(ged1,ged2,famc1);
			}
			else
			{
				/* copy in the family, wipe out husband, wife, kids.
				   Put ind1 in as a kid */
				struct child *c;
				
				sprintf(buf1,"FADDIT%d",refnum++);
				bp = (char *)malloc(strlen(buf1)+1);
				strcpy(bp,buf1);
				famc1 = set_fam(ged1,bp,famc2);  /* create and register the new family in the ged1 */
				famc1->husb = famc1->wife = 0;
				famc1->kids = 0;
				c = Calloc(struct child);
				c->ref = ind1->ref;
				add_child(famc1,c);
				ind1->famc = famc1->ref;
				match_kids_families(ged1,ged2,famc1,famc2);
			}
		}
	}
	else if(fam1->husb && fam2->husb)
	{
		/* Both are set. But do they match? */
		deref_ind2(ged1,fam1->husb,&ind1);
		deref_ind2(ged2,fam2->husb,&ind2);
		check_match_in_fam(ged1,ged2,ind1,ind2,fam1,fam2,"the husbands",1);
		husb1 = ind1;
		husb2 = ind2;
	}
	else
	{
		husb1 = husb2 = 0;
	}
	/* wife */
	if(!fam1->wife && fam2->wife)
	{
		/* the additional database has more than the ref. Insert a copy */
		deref_ind2(ged2,fam2->wife,&ind2);
		wife2 = ind2;
		if(ind2->corr.match_ind)
		{
			/* this individual, the wife in this family, has a match in the ref
			   data. But the one in the ref isn't registered as a wife in this
			   family! */
			/* But that's cool, as long as he's not a wife somewhere else?
			   What if this is one of his families in which he could have been the
			   wife thru divorce, etc.....*/
			/* I guess just add this family to his list in the ref database */
			ind1 = ged1->indlist->ind[ind2->corr.index];
			fprintf(stderr,"The additional database reports %s[%s] as being a wife\n\
in family %s, but family %s in the ref database has no wife. I'm making %s the wife\n\
in the ref database to match.\n",
					ind2->name,ind2->ref, fam2->ref, fam1->ref, ind1->name);
			fam1->wife = ind1->ref;
			wife1 = ind1;
			add_spouse(ind1,fam1->ref);
		}
		else
		{
			/* in this case, fam2 has a hub that fam1 doesn't, and an ind that
			   ged1 doesn't. So, it would be smart to add this ind to ged1, and
			   copy the info from ind2 to this new individ, and give him the
			   family spouse relationship that ged2 did. */
			char buf1[20],*bp;
			sprintf(buf1,"IADDIT%d",refnum++);
			bp = (char *)malloc(strlen(buf1)+1);
			strcpy(bp,buf1);
			ind1 = set_ind(ged1,bp,ind2);
			ind1->famc = 0;
			ind1->fams = 0;
			ind1->corr.match_ind = 1;
			ind2->corr.match_ind = 1;
			ind1->corr.index = ind2->index;
			ind2->corr.index = ind1->index;
			add_spouse(ind1, fam1->ref);
			fam1->wife = bp;
			wife1 = ind1;
		}
		/* just added the wife to fam1 */
		if( ind2->famc )
		{
			deref_fam2(ged2,ind2->famc,&famc2);
			if( famc2->corr.match_ind )
			{
				famc1 = ged1->famlist->fam[famc2->corr.match_ind];
				deref_fam2(ged1,ind1->famc,&famc1);
				/* link up to the corresponding family -- shouldn't happen much. */
				fprintf(stderr,"LINKUP**** unusual path *****\nfamc2 = %s, matchind = %d\n",
						famc2->ref, famc2->corr.index);
				if( ind1->famc )
				{
					struct family *famcc1;

					famcc1 = famc1;
					
					deref_fam2(ged1,ind1->famc,&famc1);
					if( famcc1 != famc1 )
						fprintf(stderr,"HOOOBOOOOOOY\n");
				}
				else
				{
					/* the fam is there, so ref it */
					struct child *c;
					c = Calloc(struct child);
					c->ref = ind1->ref;
					add_child(famc1,c);
					ind1->famc = famc1->ref;
				}
				make_fams_match(ged1,ged2,famc1,famc2);
				match_families(ged1,ged2,famc1);
			}
			else
			{
				/* copy in the family, wipe out husband, wife, kids.
				   Put ind1 in as a kid */
				struct child *c;
				
				sprintf(buf1,"FADDIT%d",refnum++);
				bp = (char *)malloc(strlen(buf1)+1);
				strcpy(bp,buf1);
				famc1 = set_fam(ged1,bp,famc2);  /* create and register the new family in the ged1 */
				famc1->husb = famc1->wife = 0;
				famc1->kids = 0;
				c = Calloc(struct child);
				c->ref = ind1->ref;
				add_child(famc1,c);
				ind1->famc = famc1->ref;
				famc1->corr.match_ind = 1;
				famc2->corr.match_ind = 1;
				famc1->corr.index = famc2->index;
				famc2->corr.index = famc1->index;
				match_families(ged1,ged2,famc1); /* work way up hierarchy */
			}
		}
	}
	else if(fam1->wife && fam2->wife)
	{
		/* Both are set. But do they match? */
		deref_ind2(ged1,fam1->wife,&ind1);
		deref_ind2(ged2,fam2->wife,&ind2);
		check_match_in_fam(ged1,ged2,ind1,ind2,fam1,fam2,"the wives",1);
		wife1 = ind1;
		wife2 = ind2;
	}
	else
	{
		wife1 = wife2 = 0;
	}
	
	/* children */
	/* matching children between the two families. Foreach kid in addtl
	   that doesn't match ref, add to ref. For each that does, make the
	   match strong. */
	for( i=0; fam2->kids && i< fam2->kids->kids; i++ )
	{
		int found;
		deref_ind2(ged2,fam2->kids->kid[i].ref,&ind2);

		
		for( j=0, found=0; fam1->kids && j < fam1->kids->kids; j++ )
		{
			deref_ind2(ged1,fam1->kids->kid[j].ref,&ind1);
			if( same_kid(ged2,fam2,ind1,ind2) )
			{
				found =1 ;
				check_match_in_fam(ged1,ged2,ind1,ind2,fam1,fam2,
								   "one of the kids",1);
				match_kids_spouses(ged1,ged2,ind1,ind2);
			}
		}
		if( !found )
		{
			/* in this case, fam2 has a kid that fam1 doesn't, and ged2 an ind that
			   ged1 doesn't. So, it would be smart to add this ind to ged1, and
			   copy the info from ind2 to this new individ, and give him the
			   family child relationship that ged2 did. */
			char buf1[20],*bp;
			/* but, in most cases, the kid already exists! check to see if
			   the kid here in fam2 has a match. If so, link the matching
			   kid into fam1! */
			if( ind2->corr.match_ind )
			{
				struct child *c;
				c = Calloc(struct child);
				c->ref = ged1->indlist->ind[ind2->corr.index]->ref;
				add_child(fam1,c);
				deref_ind2(ged1,c->ref,&ind1);
				fprintf(stderr,"Attached %s(%s) as kid to family %s in REF\n",
						ind1->name,ind1->ref,fam1->ref );
				ind1->famc = fam1->ref;
			}
			else
			{
				sprintf(buf1,"IADDIT%d",refnum++);
				bp = (char *)malloc(strlen(buf1)+1);
				strcpy(bp,buf1);
				fprintf(stderr,"Adding %s (%s) [in addtl:%s] as child to Family %s in ref,\n\
because there was no match there\n",
						ind2->name, bp, ind2->ref, fam1->ref);
				
				ind1 = set_ind(ged1,bp,ind2);
				ind1->fams = 0;
				ind1->famc = 0;
				ind1->corr.match_ind = 1;
				ind2->corr.match_ind = 1;
				ind1->corr.index = ind2->index;
				ind2->corr.index = ind1->index;
				add_child(fam1, &fam2->kids->kid[i]);
				/* adjust references */
				fam1->kids->kid[fam1->kids->kids-1].ref = bp;
				/* on both ends */
				ind1->famc = fam1->ref;
			}
			match_kids_spouses(ged1,ged2,ind1,ind2);
		}
	}
	print_matching_family(ged1,ged2,fam1,fam2);
	/* see if you can line up on the family in which they are children! */
	if( husb1 && husb2 )
	{
		match_kids_families(ged1,ged2,husb1,husb2);
	}
	if( wife1 && wife2 )
	{
		match_kids_families(ged1,ged2,wife1,wife2);
	}
}

void find_correspondence(ged1,ged2)
struct gedfile *ged1,*ged2;
{
	/* this routine traverses both databases looking for individuals that match in name and birthdate.
	It then uses family information to further solidify the relationships. When done, it will generate
	a pair of data structures that describe correspondents, both individual and family. It will then be
	a simple matter to add to ged1 those in ged2 that are not already in ged1, and to merge together the
	info in the individuals that do not overlap, and combine family info. */
	/* everything will be relative to ged1! */
	/* family correspondents */
	/* individual correspondents. */
	
	/* method. Search for a single match. Then traverse the relationship lists. Mark all that match */
	/* the user can/should have input in this, identifying a starting positive match, or let the computer
	do it for him. */
	int i,matches_found=0;
	int j,matches_ind=0,matches_fam=0;
	int k;

	fprintf(stderr,"\nSearching for name/birth correspondencies...\n");

	for(i=0; i< ged1->indlist->num; i++)
	{
		struct individ *ind1;
		ind1 = ged1->indlist->ind[i];
		for(j=0; j< ged2->indlist->num; j++)
		{
			struct individ *ind2;
			if(same_individual(ind1,(ind2 = ged2->indlist->ind[j]) ))
			{
				/* mark them as matching */
				ind1->corr.match_ind = 1;
				ind2->corr.match_ind = 1;
				ind1->corr.index = ind2->index;
				ind2->corr.index = ind1->index;
				matches_found++;
				matches_ind++;
				break; /* go to the next person in ged1 */
			}
		}
		if( (i % 10) == 0 )
			fprintf(stderr,"."),fflush(stderr);
		
	}
	/* now, that we some indivs that match, we can get others
	via family relationships */
	fprintf(stderr,"\n%d individuals matched between the 2 databases\n",matches_found );
	fprintf(stderr,"\nTraversing matched data to expand matched ind's and fams...\n");
	if( matches_found )
	{
		for(i=0; i< ged1->indlist->num; i++)
		{
			struct family *fam1,*fam2;
			struct individ *ind1;
			ind1 = ged1->indlist->ind[i];

			if( !ind1->corr.match_ind )
				continue;
			if( !ind1->famc || !ged2->indlist->ind[ind1->corr.index]->famc )
				continue;
			deref_fam2(ged1,ind1->famc,&fam1);
			deref_fam2(ged2,ged2->indlist->ind[ind1->corr.index]->famc,&fam2);
			/* these two families should correspond, because the individuals
			   do, and this family is the one they belong to. */
			
			/* mark them as matching */
			if( fam1->corr.match_ind || fam2->corr.match_ind )
			{ /* already at least one is matched. check that the match matches */
				if( fam1->corr.match_ind && !fam2->corr.match_ind )
				{
					fprintf(stderr,
							"families %d and %d matching disagreement:\n",
							fam1->index,fam2->index);
					fprintf(stderr,
							"fam1 is matched to %d, and %d has no match\n",
							fam1->corr.index, fam2->index);
					fprintf(stderr,"Indiv = %s, fam1= %s, fam2 = %s\n",
							ind1->name, ind1->famc,
							ged2->indlist->ind[ind1->corr.index]->famc);
					continue;
				}
				if( fam2->corr.match_ind && !fam1->corr.match_ind )
				{
					fprintf(stderr,
							"families %d(%s) and %d(%s) matching disagreement:\n",
							fam1->index,fam1->ref,
							fam2->index,fam2->ref);
					fprintf(stderr,
							"fam2 is matched to %d(%s), and %d has no match\n",
							fam2->corr.index, ged1->famlist->fam[fam2->corr.index]->ref, fam1->index);
					fprintf(stderr,"Indiv = %s, fam1= %s, fam2 = %s\n",
							ind1->name, ind1->famc,
							ged2->indlist->ind[ind1->corr.index]->famc);
					continue;
				}
				if( fam1->corr.index != fam2->index || fam2->corr.index != fam1->index )
				{
					fprintf(stderr,
							"families %d and %d matching disagreement:\n",
							fam1->index,fam2->index);
					fprintf(stderr,
							"fam1 is matched to %d, and fam2 to %d!\n",
							fam1->corr.index, fam2->corr.index);
					fprintf(stderr,"Indiv = %s, fam1= %s, fam2 = %s\n",
							ind1->name, ind1->famc,
							ged2->indlist->ind[ind1->corr.index]->famc);
					continue;
				}
			}
			else
			{
				make_fams_match(ged1,ged2, fam1,fam2);
				match_families(ged1,ged2,fam1);
				matches_found++;
				matches_fam++;
			}
		}
		fprintf(stderr,"Matched %d families on basis of matched individs having\n\
 declared themselves as children in these families\n", matches_fam);
	}
	/* having found families that match via name-coincident pairs, that are children in these families,
	   expand the matching based on the family relationships that the families contain. */
	for(i=0; i< ged1->famlist->num; i++)
	{
		struct family *fam1,*fam2;
		
		if( (fam1 = ged1->famlist->fam[i])->corr.match_ind )
		{
			match_families(ged1,ged2,fam1);
		}
	}
	print_matches(ged1,ged2);
}
