/* $Id: gedcom.h,v 1.2 1992/01/03 17:49:46 murf Exp $ */
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "st.h"
#define Calloc(x)	(x *)calloc(sizeof(x),1)
#define Callocs(x,n)	(x *)calloc(sizeof(x),n)

#ifdef macintosh
#define const const
#else
#define const 
#endif


struct datplace
{
	char *date;
	char *place;
};

struct ordinance
{
	char *val;
	char *date;
	char temp[4];
	char *qual;
};

struct address
{
	int num;
	char *addr[4];
};

struct stake
{
	char *name;
	char *num;
};

struct comment
{
	int lines;
	char **line; /* a ptr to an array of char ptrs. */
};

struct notelist
{
	int notes;
	struct comment *note; /* an array of comment structs */
};

struct gedfile
{
	struct gheader *header;
	struct submission *submission;
	st_table *families, *indiv,*submits;
	struct indivlist *indlist;
	struct famlylist *famlist;
	struct submitlist *submitlist;
};

struct gheader
{
	char *source;
	char *dest;
	char *date;
	const char *file;
	char *charset;
};

struct indivlist
{
	struct individ **ind;
	int num;
	int allocd;
};

struct corresponds
{
	char match_ind;
	char match_fam;
	int index;
	char add;
};

struct individ
{ 
	char *name;
	char *title;
	char sex;
	char *givenref;
	struct datplace *birth;
	struct datplace *christen;
	struct datplace *death;
	struct datplace *burial;
	struct ordinance *baptism;
	struct ordinance *endow;
	struct ordinance *child_to_parent;
	char *flag;
	struct famlist *fams;
	char *famc;
 	char *submitter;
	char *submitter_rel;
	char *destination_flag;
	struct notelist *notes;
	int index;
	struct corresponds corr;
	char *ref;
};

struct child_list
{
	int kids;
	struct child *kid; /* a ptr is also potentially an array ptr, as is this case */
};

struct child
{
	char *ref;
	struct ordinance *slgc;
};

struct famlist
{
	int num;
	char **family_refs; /*An array of ptrs to namerefs */
};

struct family
{
	char *husb;
	char *wife;
	struct child_list *kids;
	struct datplace *marriage;
	struct ordinance *sealspouse;
	char divorce;
	char *dest;
	char *flag;
	char *submitter;
	char *submitter_rel;
	int index;
	struct corresponds corr;
	char *ref;
};

struct famlylist
{
	struct family **fam;
	int num;
	int allocd;
};

struct submitter
{
	char *name;
	struct address *addr;
	char *phone;
	struct stake *stake;
	struct comment *comments;
	int index;
};

struct submitlist
{
	struct submitter **subm;
	int num;
	int allocd;
};

struct submission
{
	char *type;
	struct comment *comments;
	char *indi_ref;
	char *fam_ref;
	char *eval;
	char *submitter_name;
	struct address *submitter_addr;
	char *submitter_phone;
	char *fam_file;
	char *temple;
	char bapl;
	char endl;
	char slgc;
	char slgs;
};
extern struct gedfile *curr_file;
#ifdef macintosh
/* here is a list of function decls that the compiler will
  	appreciate */
void copytempitem(struct ordinance *,struct ordinance *);
void clear_indi();
struct individ *set_ind(char *);
void clear_fam();
struct family *add_fam(struct family *);
void clear_head();
void add_submitter(struct submitter *);
void set_subm(char *);
void clear_submitter();
void clear_gedfile();
void yyerror(char *);
int main(int, char **);
int group_tree(struct gedfile *);
void find_correspondence(struct gedfile *, struct gedfile *);
void merge_strings(char **,char **,char *);
void merge_datplace(struct datplace **,struct datplace **);
void merge_ordinance(struct ordinance **a,struct ordinance **);
void merge_children(struct child_list **,struct child_list **);
void remove_child(struct child_list *, int);
void merge_notes(struct notelist **, struct notelist **);
void merge_address(struct address **,struct address**);
void merge_stake(struct stake **,struct stake **);
void merge_comment(struct comment **,struct comment **);
int same_individual(struct individ *,struct individ *);
void merge_famlist(struct famlist **,struct famlist **);
void merge_individ(struct individ *,struct individ *);
void write_gedfile(struct gedfile *);
void write_header(FILE *,struct gheader *);
void write_submits(FILE *,struct submitlist *);
void write_address(FILE *,struct address *);
void write_stake(FILE *, struct stake *);
void write_comments(FILE *,struct comment *);
void write_notes(FILE *,struct notelist *);
void write_individs(FILE *,struct indivlist *);
void write_ind(FILE *, struct individ *);
void write_datplace(FILE *,int, char *, struct datplace *);
void write_ordinance(FILE *,int,char *, struct ordinance *);
void write_fams(FILE *,struct famlylist *);
int deref_ind(char *);
void write_fam(FILE *,struct family *);
#else
/* here is a list of function decls that the compiler will
  	appreciate */
void copytempitem();
void clear_indi();
struct individ *set_ind();
void clear_fam();
struct family *set_fam();
void clear_head();
void add_submitter();
void set_subm();
void clear_submitter();
void clear_gedfile();
void yyerror();
int main();
int group_tree();
void find_correspondence();
void merge_strings();
void merge_datplace();
void merge_ordinance();
void merge_children();
void remove_child();
void merge_notes();
void merge_address();
void merge_stake();
void merge_comment();
int same_individual();
void merge_famlist();
void merge_individ();
void write_gedfile();
void write_header();
void write_submits();
void write_address();
void write_stake();
void write_comments();
void write_notes();
void write_individs();
void write_ind();
void write_datplace();
void write_ordinance();
void write_fams();
int deref_ind();
void write_fam();
#endif
