%{
#ifndef LINT
static char rcs_gedcom_id[] = "$Id: gedcom.b,v 1.2 1992/01/03 17:49:44 murf Exp $";
#endif
/* # Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include "gedcom.h"
int lineno;
struct  individ curr_ind;
struct family curr_fam;
struct gedfile *curr_file;
struct submitter curr_submitter;
struct gheader curr_head;
struct submitt{char *submitter; char *rel;};
int strcmp();
static char rcs_stuff[] = "$Id: gedcom.b,v 1.2 1992/01/03 17:49:44 murf Exp $";
%}

	
%union
{ 	int num;
	char *str;
	struct datplace *datplace;
	struct ordinance *ordinance;
	struct notelist *notelist;
	struct individ *individ;
	struct family *family;
	struct gheader *header;
	struct submitt *submit;
	struct child *child;
	struct submitt *submitt;
	struct comment *comment;
	struct stake *stake;
	struct address *address;
}



%token <num> DIV LEV0 LEV1 LEV2 LEV3
%token <str> ADDR BAPL CHAR COMM CONT DATE DEST ENDL FILE9 FLAG NAME NOTE PHON
		 PLAC QUAL REL SEX SOUR TEMP TITL REF
%token <str> BIC NUMB REFN  SLGC SLGS
		

%token BIRT BURI CHIL CHR DEAT FAM FAMC FAMS HEAD HUSB INDI MARR STAL TRLR 
	WIFE SUBM
%type <datplace> marriage buried death christen datplacitem2
							birth 

%type <ordinance> seal2spou endow t_item tempitem3 t_item3
                             tempitem bap c2pseal c2pseal3

%type <submitt> submitter2
%type <comment> comment ext_list
%type <notelist> note
%type <child> child
%type <address> address
%type <stake> stake

/* these tokens are unused but part of the GEDCOM definition. If you want to expand the
parser, here are the neccessary defs. Use the big version of the lexical analyzer */

/*
%token <num> NUM
%token <str>  AFN  CANC  EVAL 
		 TYPE  ASSD ASSI DCHR IBRZ
%token <str> ABBR ABY ACTI ACTN ADDI ADMI ADOP AENT AGE AGEF AGEM ALIA ALPH ALSO ANCE ANCI ANUL AREA ASSO
		ATLA AUTH BAPM BARM BASM BATC BEN BENT BLES BLSL BOOK BRID BYTE CALN CAUS CDAT CEME
		CENS CHAN CHEC CHEK CIFF CITA CITY CIVI CIVL CLEA CLRK CNTR CO CODE CODI COFN COLO COMP
		COND CONE CONF CONL COON COOR CORP CORR COST COUN COUP COUR COVE CREA CRFN CRIM CTRY DATA DAU
		DCR DESC DESI DIR DISC DISK DIVF DOCS DUP DWEL EDUC EMIG EMPL END ENGA ENTR ENUM ENUR EOF9
		EVEN EXCE EXCO EXEC EXPL EXTD EXTR FAMO FAMP FAMR FATH FCOM FEMA FGR FHC FILM
		FOFN FOLI FONL FORE FORG FOST FRAM FRFN FROM FSUB FUNC GENE GIVN GNRL GRAD GROO GSC GUAR HAML
		HAND HDOF HDOH HEAL HEIL HEIR HEPR HIST IBAZ ILLE ILLU IMMI INDE INFA INFL INFO
		INFT INST IRFN ITEM LANG LAST LATI LDAT LENG LINE LINK LIVE LOC LOCA LOCC LOCD LOCE LOCG LOCH
		LOCI LOCL LOCM LOCN LOCO LOCQ LOCR LOCS LOCU LOCX LONG LSF LVG MAID MALE MAP MARB MARC MARD MARL
 		MARS MARY MESS MICR MILI MINR MISC MOTH MTD NAMR NAMS NATU NFCI NOTI NULL9
 		NUMP NXTB OBJ OCCU OFFI OLD OPER ORDI ORDL ORDN ORG ORPH OTHE OUT OVER PACK PAGE PARE PARI
		PART PASL PATC PATR PBRZ PED PEDC PENS PERS PID PIFF POLY PORT POST POVE PREF PRES
		PREV PRIN PRIO PRNT PROB PROP PROT PROV PROX PRTR PRVB PSUB PUBL PUBR PVMG PVRL QUAY RACE RANG
		RARS RATI REAL REBA RECD RECO RECR  REGD REGI REJE RELI REMA REPO REQD REQU RES RESE RESI
		RESN REST RETI RFN SBID SCHO SEAR SELF SEQU SERI SERS SERV SHEE SHIP SIBL SIS SLGP SON SORT
		SPEC SPEI SPEP SPLI SPOU SPUR SREF STAC STAE STAT STDN STIL SUB SUBJ SURN SURO SYMB SYST
		TAPE TASK TEXT TIME TIMP TMPL TOR TOWC TOWN TRAK TRAN TRAS TWP UDER UNIF UPDA VALU VERI VITA
		VOID VOIL VOLU WAC WARD WARL WIDO WILL WITN YEAR YOUN YTD
%token FAMF SUBN 


*/



%%

file : header submitter record_list trailer;

header : LEV0 HEAD { clear_head(); } head_rec_list {curr_file->header = &curr_head; };

head_rec_list: headrec
	| head_rec_list headrec;
							
headrec: LEV1 SOUR  {curr_head.source = $2; }
	| LEV1 DEST { curr_head.dest = $2; }
	| LEV1 DATE { curr_head.date = $2; }
	| LEV1 CHAR { curr_head.charset = $2; }
	| LEV1 FILE9 {curr_head.file = $2; };

 submitter: LEV0 REF {clear_submitter();} SUBM subm_list
		{set_subm(curr_file,$2,&curr_submitter); };

subm_list: LEV1 submrec {}
	| subm_list LEV1 submrec{};
					
submrec : NAME { curr_submitter.name = $1; }
	| PHON { curr_submitter.phone = $1;}
	| comment { curr_submitter.comments = $1;}
	| address { curr_submitter.addr = $1;}
	| stake { curr_submitter.stake = $1;};
				
address : ADDR ext_list { int i;
			$$ = Calloc(struct address);
			$$->addr[0] = $1;
			for(i=0; i< $2->lines; i++)
			{
				$$->addr[i+1] = $2->line[i];
			}
			$$->num = $2->lines+1;
			free($2->line);
			free($2);
			 }
	| ADDR { $$ = Calloc(struct address);
			$$->addr[0] = $1;
			$$->num = 1;};

ext_list : LEV2 CONT { $$=Calloc(struct comment);$$->line=(char **)malloc(sizeof(char *)); $$->line[0] = $2; $$->lines=1;}
	| ext_list LEV2 CONT {$$=$1; $$->line = (char **)realloc($$->line,sizeof(char *) * ($$->lines+1));
			$$->line[$$->lines++] = $3; };
							
comment : COMM ext_list {int i; $$=Calloc(struct comment);$$->line=(char **)malloc(sizeof(char *) * ($2->lines+1));$$->line[0]=$1;
			for(i=0;i<$2->lines;i++){$$->line[i+1]=$2->line[i]; }$$->lines = $2->lines+1; }
	| COMM {$$=Calloc(struct comment);$$->line = (char **)malloc(sizeof(char *)); $$->line[0] = $1;$$->lines =1;};
				
stake: STAL { $$=Calloc(struct stake);}
 	| STAL LEV2 NAME {$$=Calloc(struct stake);$$->name=$3; }
 	| STAL LEV2 NUMB {$$=Calloc(struct stake);$$->num=$3; }
	| STAL LEV2 NAME LEV2 NUMB {$$=Calloc(struct stake); 
 				$$->name = $3;
 				$$->num = $5;}
	| STAL LEV2 NUMB LEV2 NAME {$$=Calloc(struct stake);
				$$->name = $5;
 				$$->num = $3;};

record_list: record { }
	| record_list record { };

record : individual_rec { }
	| fam_rec { };

individual_rec : LEV0 REF INDI  {clear_indi(); } indiv_stuff_list
			{set_ind(curr_file,$2,&curr_ind); };

indiv_stuff_list : LEV1 indivrec { }
	| indiv_stuff_list LEV1 indivrec { };

indivrec : NAME 	{ curr_ind.name = $1; }
	| TITL { curr_ind.title = $1;}
	| SEX { curr_ind.sex = ($1[0]? $1[0]:($1[1]? $1[1]: 'x'));
		if( curr_ind.sex != 'M' && curr_ind.sex != 'F' )
			fprintf(stderr,"Sex (%c) indecipherable line %d\n", curr_ind.sex,lineno);}
	| REFN { curr_ind.givenref = $1;}
	| birth { curr_ind.birth = $1;}
	| christen { curr_ind.christen = $1;}
	| death { curr_ind.death = $1;}
	| buried { curr_ind.burial = $1;}
	| bap { curr_ind.baptism = $1;}
	| endow { curr_ind.endow = $1;}
	| c2pseal { curr_ind.child_to_parent = $1;}
	| FLAG { curr_ind.flag = $1;}
	| FAMS REF { add_spouse(&curr_ind,$2);  }
	| FAMC REF { curr_ind.famc = $2;}
	| submitter2 { curr_ind.submitter = $1->submitter;curr_ind.submitter_rel = $1->rel;}
	| DEST { curr_ind.destination_flag = $1;}
	| note { if(curr_ind.notes){
		/* merge notes */
		curr_ind.notes->notes++; /* increment the num of notes */
		curr_ind.notes->note = (struct comment *)realloc(curr_ind.notes->note,sizeof(struct comment)*curr_ind.notes->notes);
		curr_ind.notes->note[curr_ind.notes->notes-1].lines = $1->note[0].lines;
		curr_ind.notes->note[curr_ind.notes->notes-1].line = $1->note[0].line;
		$1->note[0].line = 0;
		free($1->note[0]);
		free($1);
		} else {
		/* stick in */
		curr_ind.notes = $1;
		}};
birth: BIRT datplacitem2 { $$ = $2; };

datplacitem2 : LEV2 DATE {$$ = Calloc(struct datplace); $$->date = $2; }
	| LEV2 PLAC {$$ = Calloc(struct datplace); $$->place = $2; }
	| LEV2 DATE LEV2 PLAC {$$ = Calloc(struct datplace); $$->place = $4;$$->date = $2; }
	| LEV2 PLAC LEV2 DATE {$$ = Calloc(struct datplace); $$->place = $2;$$->date = $4; };

christen: CHR datplacitem2   {$$=$2; };

death: DEAT datplacitem2  {$$=$2; };

buried: BURI datplacitem2 {$$=$2; };

bap: BAPL tempitem { $$=$2; $$->val = $1;}
	| BAPL { $$= Calloc(struct ordinance); $$->val = $1;};

tempitem : t_item {$$=$1; }
	| tempitem t_item { $$ =$1; 
			copytempitem($$,$2);};
					
t_item :  LEV2 DATE { $$ = Calloc(struct ordinance); $$->date=$2;}
	| LEV2 TEMP {  $$ = Calloc(struct ordinance); strcpy($$->temp,$2);}
	| LEV2 QUAL {  $$ = Calloc(struct ordinance); $$->qual=$2;};

tempitem3 : t_item3 {$$=$1; }
	| tempitem3 t_item3 {$$ =$1; 
				copytempitem($$,$2); };
				
t_item3 :  LEV3 DATE { $$ = Calloc(struct ordinance); $$->date=$2; }
	| LEV3 TEMP { $$ = Calloc(struct ordinance); strcpy($$->temp,$2); }
	| LEV3 QUAL { $$ = Calloc(struct ordinance); $$->qual=$2; };

endow: ENDL tempitem { $$=$2; $$->val = $1; }
	| ENDL {$$= Calloc(struct ordinance); $$->val = $1; };

c2pseal: SLGC tempitem { $$=$2;$$->val = $1; }
	| SLGC {$$= Calloc(struct ordinance); $$->val = $1;};

c2pseal3: SLGC  { $$=Calloc(struct ordinance); $$->val = $1;}
	| SLGC tempitem3 {$$=$2; $$->val = $1; };

submitter2: SUBM REF {$$=Calloc(struct submitt); $$->submitter = $2; }
	| SUBM REF LEV2 REL {$$=Calloc(struct submitt); $$->submitter = $2; $$->rel = $4; };
					
note: NOTE { $$=Calloc(struct notelist); $$->note=Calloc(struct comment); $$->note[0].lines=1;
		$$->note[0].line = Calloc(char *); $$->note[0].line[0] = $1; $$->notes=1;$$->note[0].lines = 1;}
	| NOTE ext_list {int i;
		$$=Calloc(struct notelist); 
		$$->note=$2;
		$$->note[0].line = (char **)realloc($$->note[0].line,sizeof(char *)*($2->lines+1)); 
		$$->notes=1; 
		for(i=$2->lines; i; i--)
		{$2->line[i]=$2->line[i-1];}
		$2->line[0] = $1;$2->lines++;};
		


fam_rec: LEV0 REF {clear_fam();} FAM fam_stuff_list
			{set_fam(curr_file,$2,&curr_fam);};

fam_stuff_list : LEV1 famrec { }
	| fam_stuff_list LEV1 famrec { };

famrec: HUSB REF {curr_fam.husb = $2; }
	| WIFE REF {curr_fam.wife = $2; }
	| child { add_child(&curr_fam, $1); }
	| marriage {curr_fam.marriage = $1; }
	| seal2spou {curr_fam.sealspouse = $1; }
	| DIV {curr_fam.divorce = 1; }
	| DEST { curr_fam.dest = $1;}
	| FLAG { curr_fam.flag = $1;}
	| submitter2 { curr_fam.submitter = $1->submitter;
			curr_fam.submitter_rel = $1->rel;};

child : CHIL REF { $$=Calloc(struct child);$$->ref=$2;}
	| CHIL REF LEV2 c2pseal3 {$$=Calloc(struct child);$$->ref = $2; $$->slgc =$4; };
			
marriage: MARR datplacitem2 {$$=$2; };

seal2spou : SLGS tempitem {$$=$2; $$->val = $1;}
	| SLGS {$$= Calloc(struct ordinance); $$->val = $1; };

trailer: LEV0 TRLR{};

%%
void copytempitem(a,b)
struct ordinance *a,*b;
{
	if( b->val )
		a->val = b->val;
	if(b->date)
		a->date = b->date;
	if(b->temp[0] )
		strcpy(a->temp,b->temp);
	if(b->qual)
		a->qual = b->qual;
	free(b);
}

void clear_indi()
{
	curr_ind.name = 0;
	curr_ind.title = 0;
	curr_ind.sex = 0;
	curr_ind.givenref = 0;
	curr_ind.birth = 0;
	curr_ind.christen = 0;
	curr_ind.death = 0;
	curr_ind.burial = 0;
	curr_ind.baptism = 0;
	curr_ind.endow = 0;
	curr_ind.child_to_parent = 0;
	curr_ind.flag = 0;
	curr_ind.fams = 0;
	curr_ind.famc = 0;
	curr_ind.submitter = 0;
	curr_ind.submitter_rel = 0;
	curr_ind.destination_flag = 0;
	curr_ind.notes = 0;
}

static int add_ind(ged,ip)
struct gedfile *ged;
struct individ *ip;
{
	struct indivlist *x=ged->indlist;
	if( !ged->indlist )
		x = ged->indlist = Calloc(struct indivlist);
	if( !x->allocd )
	{
		x->allocd += 20;
		x->ind = Callocs(struct individ *,20);
	}
	if( x->num == x->allocd )
	{
		x->allocd += 20;
		x->ind = (struct individ **)realloc(x->ind,x->allocd*sizeof(struct individ *));
	}
	ip->index = x->num;
	x->ind[x->num++] = ip;
	return ip->index;
}

struct individ *set_ind(ged,ref,curr_in)
struct gedfile *ged;
char *ref;
struct individ *curr_in;
{
	struct individ *ind;
	
	if( !ged->indiv )
	{
		ged->indiv = st_init_table(strcmp,st_strhash);
	}
	ind = Calloc(struct individ);
	*ind = *curr_in;
	st_insert(ged->indiv,ref,(char *)ind);
	ind->ref = ref;
	add_ind(ged,ind);
	return ind;
}

void clear_fam()
{
	curr_fam.husb = 0;
	curr_fam.wife = 0;
	curr_fam.kids = 0;
	curr_fam.marriage = 0;
	curr_fam.sealspouse = 0;
	curr_fam.divorce = 0;
	curr_fam.dest = 0;
	curr_fam.flag = 0;
	curr_fam.submitter = 0;
	curr_fam.submitter_rel = 0;
}
struct family *set_fam(ged,ref,curr_fa)
char *ref;
struct gedfile *ged;
struct family *curr_fa;
{
	struct family *fam;
	
	if( !ged->families )
	{
		ged->families = st_init_table(strcmp,st_strhash);
	}
	fam = Calloc(struct family);
	*fam = *curr_fa;
	st_insert(ged->families,ref,(char *)fam);
	fam->ref = ref;
	add_fam(ged,fam);
	return fam;
}

static int add_fam(ged,fp)
struct family *fp;
struct gedfile *ged;
{
	struct famlylist *x=ged->famlist;
	if( !ged->famlist )
		x = ged->famlist = Calloc(struct famlylist);
	if( !x->allocd )
	{
		x->allocd += 20;
		x->fam = Callocs(struct family *,20);
	}
	if( x->num == x->allocd )
	{
		x->allocd += 20;
		x->fam = (struct family **)realloc(x->fam,x->allocd*sizeof(struct family *));
	}
	fp->index = x->num;
	x->fam[x->num++] = fp;
	return fp->index;
}

void clear_head() /* blow nose? */
{
	curr_head.source = 0;
	curr_head.dest = 0;
	curr_head.date = 0;
	curr_head.file = 0;
	curr_head.charset = 0;
}

void add_submitter(ged,ip)
struct submitter *ip;
struct gedfile *ged;
{
	struct submitlist *x=ged->submitlist;
	if( !ged->submitlist )
		x = ged->submitlist = Calloc(struct submitlist);
	if( !x->allocd )
	{
		x->allocd += 20;
		x->subm = Callocs(struct submitter *,20);
	}
	if( x->num == x->allocd )
	{
		x->allocd += 20;
		x->subm = (struct submitter **)realloc(x->subm,x->allocd*sizeof(struct submitter *));
	}
	ip->index = x->num;
	x->subm[x->num++] = ip;
}
void set_subm(ged,ref,curr_submitte)
char *ref;
struct gedfile *ged;
struct submitter *curr_submitte;
{
	struct submitter *ind;
	
	if( !ged->submits )
	{
		ged->submits = st_init_table(strcmp,st_strhash);
	}
	ind = Calloc(struct submitter);
	*ind = *curr_submitte;
	st_insert(ged->submits,ref,(char *)ind);
	add_submitter(ged,ind);
}

void clear_submitter()
{
	curr_submitter.name = 0;
 	curr_submitter.addr = 0;
 	curr_submitter.phone = 0;
 	curr_submitter.stake = 0;
 	curr_submitter.comments = 0;
 	curr_submitter.index = 0;
}

void clear_gedfile()
{
	curr_file->header = 0;
	curr_file->submission = 0;
	curr_file->indiv = 0;
	curr_file->families = 0;
	curr_file->submits = 0;
	curr_file->indlist = 0;
	curr_file->famlist = 0;
	curr_file->submitlist = 0;
}


void yyerror(s)
char *s;
{
	extern int lineno; 
	fprintf(stderr,"Parse error in line %d\n",lineno);
}

add_spouse(ind,ref)
struct individ *ind;
char *ref;
{
	if( !ind->fams)
	{
		ind->fams = Calloc(struct famlist);
		ind->fams->family_refs = (char **)malloc(sizeof(char *));
		ind->fams->family_refs[ind->fams->num++] = ref;
	}
	else
	{
		ind->fams->family_refs = (char **)
			realloc(ind->fams->family_refs,
					sizeof(char *)*(ind->fams->num+1));
		ind->fams->family_refs[ind->fams->num++] = ref;
	}
}

add_child(fam,chil)
struct family *fam;
struct child *chil;
{
	if(!fam->kids)
	{
		fam->kids=Calloc(struct child_list);
		fam->kids->kid=Calloc(struct child);
		fam->kids->kid[0] = *chil;
		fam->kids->kids=1;
	}
	else
	{
		fam->kids->kid=(struct child *)realloc(fam->kids->kid, 
								sizeof(struct child)*(fam->kids->kids+1));
		fam->kids->kid[fam->kids->kids++] = *chil;
	}
}
