#ifndef ANSI_H
#define ANSI_H
/* $Id: errtrap.h,v 1.1.1.1 1992/01/03 17:10:25 murf Exp $ */

/* Function prototypes */
#ifdef __STDC__
#define ARGS(args)	args
#else
#define ARGS(args)	()
#endif

#endif
#ifndef ERRTRAP_H
#define ERRTRAP_H

#include <setjmp.h>
#include <stdio.h>

#define ERR_PKG_NAME	"errtrap"

extern void errProgramName( /* char *progName */ );
extern void errCore( /* int flag */ );
extern void errPushHandler( /* void (*handler)() */ );
extern void errPopHandler();
extern void errRaise( /* char *pkgName, int code, char *format, ... */ );
extern void errPass( /* char *format, ... */ );

#define ERR_IGNORE(expr)	\
    {					\
	if ( ! setjmp(errJmpBuf)) {	\
	    errIgnPush();		\
	    expr;			\
	}				\
	errIgnPop();			\
    }
extern jmp_buf errJmpBuf;
extern void errIgnPush(), errIgnPop();
extern int errStatus();

#endif /* ERRTRAP_H */
