/*=============================================================
 * assert.c -- Standard assertion routines
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   3.0.2 - 16 Oct 94
 *===========================================================*/

#include "standard.h"

/*===============================
 * __fatal -- Fatal error routine
 *=============================*/
__fatal (file, line)
STRING file;
int line;
{
	wprintf("FATAL: %s: line %d\n", file, line);
	final_cleanup();
	abort();
}
/*============================
 * __assert -- Check assertion
 *==========================*/
__assert (exp, file, line)
BOOLEAN exp;
STRING file;
int line;
{
	if (exp) return;
	__fatal(file, line);
}
