/*=============================================================
 * newrecs.c -- Handle source, event and other record types
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   3.0.0 - 11 Sep 94    3.0.2 - 14 Apr 95
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "translat.h"
#include "btree.h"

extern BTREE BTR;

#define SS static STRING

extern STRING cfradd, cfeadd, cfxadd, rredit, eredit, xredit;
extern STRING cfrupt, cfeupt, cfxupt, gdrmod, gdemod, gdxmod;
extern STRING idredt, ideedt, idxedt;

SS rstr = (STRING) "0 SOUR\n1 REFN\n1 TITL Title\n1 AUTH Author";
SS estr = (STRING) "0 EVEN\n1 REFN\n1 DATE\n1 PLAC\n1 INDI\n  2 NAME\n  2 ROLE\n1 SOUR";
SS xstr = (STRING) "0 XXXX\n1 REFN";

void edit_record();
NODE ask_for_record();
NODE refn_to_record();
NODE key_to_record();

extern BOOLEAN valid_sour_tree(), valid_even_tree(), valid_othr_tree();

/*================================================
 * add_source -- Add source to database by editing
 *==============================================*/
BOOLEAN add_source ()
{
	STRING str = (STRING) valueof(useropts, "SOURREC");
	if (!str) str = rstr;
	return add_record(str, rredit, valid_sour_tree, cfradd,
	    getsxref, sour_to_dbase, sour_to_cache);
}
/*==============================================
 * add_event -- Add event to database by editing
 *============================================*/
BOOLEAN add_event ()
{
	STRING str = (STRING) valueof(useropts, "EVENREC");
	if (!str) str = estr;
	return add_record(str, eredit, valid_even_tree, cfeadd,
	    getexref, even_to_dbase, even_to_cache);
}
/*====================================================
 * add_other -- Add user record to database by editing
 *==================================================*/
BOOLEAN add_other ()
{
	STRING str = (STRING) valueof(useropts, "OTHRREC");
	if (!str) str = xstr;
	return add_record(str, xredit, valid_othr_tree, cfxadd,
	    getxxref, othr_to_dbase, othr_to_cache);
}
/*================================================
 * add_record -- Add record to database by editing
 *==============================================*/
BOOLEAN add_record (recstr, redt, val, cfrm, getref, todbase, tocache)
STRING recstr;		/* default record */
STRING redt;		/* re-edit message */
BOOLEAN (*val)();	/* tree validate predicate */
STRING cfrm;		/* confirm message */
INT (*getref)();	/* get next internal key */
INT (*todbase)();	/* write record to dbase */
INT (*tocache)();	/* write record to cache */
{
	FILE *fp;
	NODE node, refn;
	STRING msg, str, key;
	BOOLEAN emp;
	TRANTABLE tti = tran_tables[MEDIN];

/* Create template for user to edit */
	if (!(fp = fopen(editfile, "w"))) return NULL;
	fprintf(fp, "%s\n", recstr);

/* Have user edit new record */
	fclose(fp);
	do_edit();
	while (TRUE) {
		node = file_to_node(editfile, tti, &msg, &emp);
		if (!node) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			} 
			break;
		}
		if (!(*val)(node, &msg, NULL)) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			}
			free_nodes(node);
			node = NULL;
			break;
		}
		break;
	}
	if (!node || !ask_yes_or_no(cfrm)) {
		if (node) free_nodes(node);
		return FALSE;
	}
	nxref(node) = strsave((*getref)());
	refn = REFN(node);
	key = rmvat(nxref(node));
	if (refn && nval(refn)) add_refn(nval(refn), key);
	(*todbase)(node);
	(*tocache)(node);
	return TRUE;
}
/*=======================================
 * edit_source -- Edit source in database
 *=====================================*/
void edit_source (node)
NODE node;
{
	edit_record(node, idredt, 'S', rredit, valid_sour_tree,
	    cfrupt, "SOUR", sour_to_dbase, gdrmod);
}
/*=====================================
 * edit_event -- Edit event in database
 *===================================*/
void edit_event (node)
NODE node;
{
	edit_record(node, ideedt, 'E', eredit, valid_even_tree,
	     cfeupt, "EVEN", even_to_dbase, gdemod);
}
/*===========================================
 * edit_other -- Edit user record in database
 *=========================================*/
void edit_other (node)
NODE node;
{
	edit_record(node, idxedt, 'X', xredit, valid_othr_tree,
	     cfxupt, NULL, othr_to_dbase, gdxmod);
}
/*=======================================
 * edit_record -- Edit record in database
 *=====================================*/
void edit_record (node1, idedt, letr, redt, val, cfrm, tag, todbase, gdmsg)
NODE node1;		/* record to edit, poss NULL */
STRING idedt;		/* user id prompt */
INT letr;		/* record type: E, S or X */
STRING redt;		/* re-edit message */
BOOLEAN (*val)();	/* validate routine */
STRING cfrm;		/* confirm message */
INT (*todbase)();	/* write record to dbase */
STRING gdmsg;		/* success message */
{
	TRANTABLE tti = tran_tables[MEDIN], tto = tran_tables[MINED];
	INT i;
	STRING msg, newr, oldr, key;
	FILE *fp;
	BOOLEAN emp;
	NODE refn, node2, temp;

/* Identify record if need be */
	if (!node1) node1 = ask_for_record(idedt, letr);
	if (!node1) return;
	refn = REFN(node1);
	oldr = refn ? nval(refn) : NULL;

/* Have user edit record */
	ASSERT(fp = fopen(editfile, "w"));
	write_nodes(0, fp, tto, node1,  TRUE, TRUE, TRUE);
	fclose(fp);
	do_edit();
	while (TRUE) {
		node2 = file_to_node(editfile, tti, &msg, &emp);
		if (!node2) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			}
			break;
		}
		if (!(*val)(node2, &msg, node1)) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			}
			free_nodes(node2);
			node2 = NULL;
			break;
		}
		break;
	}

/* If error or no change or user backs out return */
	if (!node2) return;
	if (equal_tree(node1, node2) || !ask_yes_or_no(cfrm)) {
		free_nodes(node2);
		return;
	}

/* Change database */
	refn = REFN(node2);
	newr = refn ? nval(refn) : NULL;
	if (newr && oldr && eqstr(newr, oldr))
                newr = oldr = NULL;
	key = rmvat(nxref(node1));
        if (oldr) remove_refn(oldr, key);
        if (newr) add_refn(newr, key);
	temp = nchild(node1);
	nchild(node1) = nchild(node2);
	nchild(node2) = temp;
	(*todbase)(node1);
	free_nodes(node2);
	mprintf(gdrmod);
}
/*=========================================
 * key_to_record -- Returns record with key
 *=======================================*/
NODE key_to_record (str, let)
STRING str;	/* string that may be a key */
INT let;	/* if string starts with letter it must be this */
{
	char kbuf[MAXNAMELEN];
	INT i = 0, c;

/*wprintf("key_to_record: %s, %c\n", str, let);/*DEBUG*/
	if (!str || *str == 0) return NULL;
	c = *str++;
	if (c != let && chartype(c) != DIGIT) return NULL;
	kbuf[i++] = let;
	if (c != let) kbuf[i++] = c;
	while ((c = *str++) && chartype(c) == DIGIT)
		kbuf[i++] = c;
	if (c != 0) return NULL;
	kbuf[i] = 0;
	if (!isrecord(BTR, str2rkey(kbuf))) return NULL;
/*wprintf("key_to_record: %s\n", kbuf);/*DEBUG*/
	switch (let) {
	case 'I': return key_to_indi(kbuf);
	case 'F': return key_to_fam(kbuf);
	case 'S': return key_to_sour(kbuf);
	case 'E': return key_to_even(kbuf);
	case 'X': return key_to_othr(kbuf);
	default:  FATAL();
	}
}
/*==============================================
 * ask_for_record -- Ask user to identify record
 *============================================*/
NODE ask_for_record (idstr, letr)
STRING idstr;	/* question prompt */
INT letr;	/* letter to possibly prepend to key */
{
	NODE node;
	STRING str = ask_for_string(idstr, "enter key or refn: ");
	if (!str || *str == 0) return NULL;
	node = key_to_record(str, letr);
	if (!node) node = refn_to_record(str, letr);
	return node;
}
/*================================================
 * refn_to_record - Get record from user reference
 *================================================*/
NODE refn_to_record (ukey, letr)
STRING ukey;	/* user refn key */
INT letr;	/* type of record */
{
        STRING *keys;
        INT num, i;

/*wprintf("refn_to_record called: %s, %c\n", ukey, letr);/*DEBUG*/
        if (!ukey || *ukey == 0) return NULL;
        get_refns(ukey, &num, &keys, letr);
	if (num)
		return key_to_record(keys[0], letr);
	else
		return NULL;
}
