/*============================================================
 * choose.c -- Implements the choose operations
 * Copyright(c) 1992-4 by T.T. Wetmore IV; all rights reserved
 *   3.0.2 - 06 Dec 94
 *==========================================================*/

#include "standard.h"
#include "table.h"
#include "indiseq.h"
#include "gedcom.h"

/*=================================================
 * choose_child -- Choose child of person or family
 *===============================================*/
NODE choose_child (indi, fam, msg0, msgn, ask1)
NODE indi, fam;
STRING msg0, msgn;
BOOLEAN ask1;
{
	INDISEQ seq;
	NODE node;
	INT i = 0;
	if (indi) seq = indi_to_children(indi);
	if (!indi && fam) seq = fam_to_children(fam);
	if (!seq) {
		message(msg0);
		return NULL;
	}
	node = format_and_choose_indi(seq, FALSE, FALSE, ask1, msgn, msgn);
	remove_indiseq(seq, FALSE);
	return node;
}
/*========================================
 * choose_spouse -- Choose person's spouse
 *======================================*/
NODE choose_spouse (indi, msg0, msgn)
NODE indi;
STRING msg0, msgn;
{
	INDISEQ seq;
	NODE node;
	INT i = 0, len;
	if (!indi) return NULL;
	seq = indi_to_spouses(indi);
	if (!seq) {
		message(msg0);
		return NULL;
	}
	node = format_and_choose_indi(seq, FALSE, TRUE, FALSE, NULL, msgn);
	remove_indiseq(seq, FALSE);
	return node;
}
/*==========================================================
 * choose_family -- Choose family from person's FAMS/C lines
 *========================================================*/
NODE choose_family (indi, msg0, msgn, fams)
NODE indi;
STRING msg0, msgn;
BOOLEAN fams;
{
	NODE node, fam, spouse;
	INT i = 0, len;
	char scratch[12];
	INDISEQ seq = indi_to_families(indi, fams);
	if (!seq) {
		message(msg0);
		return NULL;
	}
	node = format_and_choose_indi(seq, TRUE, FALSE, FALSE, NULL, msgn);
	remove_indiseq(seq, FALSE);
	return node;
}
/*===================================================
 * choose_father -- Choose father of person or family
 *=================================================*/
NODE choose_father (indi, fam, msg0, msgn, ask1)
NODE indi, fam;
STRING msg0, msgn;
BOOLEAN ask1;
{
	INDISEQ seq;
	NODE node;
	INT i = 0;
	if (indi) seq = indi_to_fathers(indi);
	if (!indi && fam) seq = fam_to_fathers(fam);
	if (!seq) {
		message(msg0);
		return NULL;
	}
	node = format_and_choose_indi(seq, FALSE, FALSE, ask1, msgn, msgn);
	remove_indiseq(seq, FALSE);
	return node;
}
/*===================================================
 * choose_mother -- Choose mother of person or family
 *=================================================*/
NODE choose_mother (indi, fam, msg0, msgn, ask1)
NODE indi, fam;
STRING msg0, msgn;
BOOLEAN ask1;
{
	INDISEQ seq;
	NODE node;
	INT i = 0;
	if (indi) seq = indi_to_mothers(indi);
	if (!indi && fam) seq = fam_to_mothers(fam);
	if (!seq) {
		message(msg0);
		return NULL;
	}
	node = format_and_choose_indi(seq, FALSE, FALSE, ask1, msgn, msgn);
	remove_indiseq(seq, FALSE);
	return node;
}
