/*=============================================================
 * newrecs.c -- Handle source, event and other record types
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   3.0.0 - 11 Sep 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "translat.h"

extern STRING cfradd, cfeadd, cfxadd, rredit, eredit, xredit;
extern STRING cfrupt, cfeupt, cfxupt, gdrmod, gdemod, gdxmod;
extern STRING idredt, ideedt, idxedt;

static STRING rstr =
	"0 SOUR\n1 TITL Title\n1 AUTH Author\n1 INDX Keywords";
static STRING estr =
	"0 EVEN\n1 DATE\n1 PLAC\n1 INDI\n  2 NAME\n  2 ROLE";
static STRING xstr =
	"0 XXXX";

void edit_record();
NODE ask_for_record();
BOOLEAN valid_sour_tree () { return TRUE; } /*LOOSEEND*/
BOOLEAN valid_even_tree () { return TRUE; } /*LOOSEEND*/
BOOLEAN valid_othr_tree () { return TRUE; } /*LOOSEEND*/

/*================================================
 * add_source -- Add source to database by editing
 *==============================================*/
BOOLEAN add_source ()
{
	STRING str = (STRING) valueof(useropts, "SOURREC");
	if (!str) str = rstr;
	return add_record(str, rredit, valid_sour_tree,
	    cfradd, getsxref);
}
/*==============================================
 * add_event -- Add event to database by editing
 *============================================*/
BOOLEAN add_event ()
{
	STRING str = (STRING) valueof(useropts, "EVENREC");
	if (!str) str = estr;
	return add_record(str, eredit, valid_even_tree,
	    cfeadd, getexref);
}
/*====================================================
 * add_other -- Add user record to database by editing
 *==================================================*/
BOOLEAN add_other ()
{
	STRING str = (STRING) valueof(useropts, "OTHRREC");
	if (!str) str = xstr;
	return add_record(str, xredit, valid_othr_tree,
	    cfxadd, getxxref);
}
/*================================================
 * add_record -- Add record to database by editing
 *==============================================*/
BOOLEAN add_record (recstr, redt, val, cfrm, getref)
STRING recstr;		/* default record */
STRING redt;		/* re-edit message */
BOOLEAN (*val)();	/* tree validate predicate */
STRING cfrm;		/* confirm message */
INT (*getref)();	/* get next internal key */
{
	FILE *fp;
	NODE node;
	STRING msg, str, key;
	BOOLEAN emp;
	TRANTABLE tti = tran_tables[MEDIN];

/* Create template for user to edit */
	if (!(fp = fopen(editfile, "w"))) return NULL;
	fprintf(fp, "%s\n", recstr);

/* Have user edit new record */
	fclose(fp);
	do_edit();
	while (TRUE) {
		node = file_to_node(editfile, tti, &msg, &emp);
		if (!node) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			} 
			break;
		}
		if (!(*val)(node, &msg)) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			}
			free_nodes(node);
			node = NULL;
			break;
		}
		break;
	}
	if (!node || !ask_yes_or_no(cfrm)) {
		if (node) free_nodes(node);
		return NULL;
	}
	nxref(node) = strsave((*getref)());
	key = rmvat(nxref(node));
	ASSERT(str = node_to_string(node));
	ASSERT(store_record(key, str, strlen(str)));
	stdfree(str);
	return TRUE;
}
/*=======================================
 * edit_source -- Edit source in database
 *=====================================*/
void edit_source (node1)
NODE node1;
{
	edit_record(node1, idredt, 'S', rredit, valid_sour_tree,
	    cfrupt, "SOUR", gdrmod);
}
/*=====================================
 * edit_event -- Edit event in database
 *===================================*/
void edit_event (node1)
NODE node1;
{
	edit_record(node1, ideedt, 'E', eredit, valid_even_tree,
	     cfeupt, "EVEN", gdemod);
}
/*===========================================
 * edit_other -- Edit user record in database
 *=========================================*/
void edit_other (node1)
NODE node1;
{
	edit_record(node1, idxedt, 'X', xredit, valid_othr_tree,
	     cfxupt, NULL, gdxmod);
}
/*=======================================
 * edit_record -- Edit record in database
 *=====================================*/
void edit_record (node1, idedt, letr, redt, val, cfrm, tag, gdmsg)
NODE node1;
STRING idedt;
INT letr;
STRING redt;
BOOLEAN (*val)();
STRING cfrm;
STRING gdmsg;
{
	TRANTABLE tti = tran_tables[MEDIN], tto = tran_tables[MINED];
	INT i;
	STRING msg;
	FILE *fp;
	BOOLEAN emp;
	NODE node2;

/* Identify record if need be */
	if (!node1) node1 = ask_for_record(idedt, letr);
	if (!node1) return;

/* Have user edit record */
	ASSERT(fp = fopen(editfile, "w"));
	write_nodes(0, fp, tto, node1,  TRUE, TRUE, TRUE);
	fclose(fp);
	do_edit();
	while (TRUE) {
		node2 = file_to_node(editfile, tti, &msg, &emp);
		if (!node2) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			}
			break;
		}
		if (!valid_sour_tree(node2, &msg)) {
			if (ask_yes_or_no_msg(msg, redt)) {
				do_edit();
				continue;
			}
			free_nodes(node2);
			node2 = NULL;
			break;
		}
		break;
	}

/* If error or no change or user backs out return */
	if (!node2) {
		free_nodes(node1);
		return;
	}
	if (equal_tree(node1, node2) || !ask_yes_or_no(cfrm)) {
		free_nodes(node1);
		free_nodes(node2);
		return;
	}

/* Change database */
	record_to_dbase(node2, tag);
	mprintf(gdrmod);
}
/*=========================================
 * key_to_record -- Returns record with key
 *=======================================*/
NODE key_to_record (str, let)
STRING str;	/* string that may be a key */
INT let;	/* if string starts with letter it must be this */
{
	STRING rec, p = str;
	char kbuf[MAXNAMELEN];
	INT i = 0, c, len;
	NODE node;

	while ((c = *p++) && chartype(c) == WHITE)
		;
	if (c == 0) return NULL;
	if (c != let && chartype(c) != DIGIT) return NULL;
	kbuf[i++] = let;
	if (c != let) kbuf[i++] = c;
	while ((c = *p++) && chartype(c) == DIGIT)
		kbuf[i++] = c;
	if (c != 0) return NULL;
	kbuf[i] = 0;
	if (!(rec = retrieve_record(kbuf, &len))) return NULL;
	node = string_to_node(rec);
	stdfree(rec);
	return node;
}
/*==============================================
 * ask_for_record -- Ask user to identify record
 *============================================*/
NODE ask_for_record (idstr, letr)
STRING idstr;	/* question prompt */
INT letr;	/* letter to possibly prepend to key */
{
	STRING str = ask_for_string(idstr, "enter key: ");
	if (!str || *str == 0) return NULL;
	return key_to_record(str, letr);
}
/*============================================
 * record_to_dbase -- Store record in database
 *==========================================*/
record_to_dbase (node, tag)
NODE node;
STRING tag;
{
	STRING str;
	if (!node || (tag && strcmp(tag, ntag(node)))) return;
	str = node_to_string(node);
	ASSERT(store_record(rmvat(nxref(node)), str, strlen(str)));
	stdfree(str);
}
