/*=============================================================
 * init.c -- Initialize LifeLines data structures
 * Copyright(c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 29 Aug 93
 *   3.0.0 - 05 Oct 94
 *===========================================================*/

#include "standard.h"
#include "btree.h"
#include "table.h"
#include "gedcom.h"

TABLE tagtable;		/* table for tag strings */
TABLE placabbvs;	/* table for place abbrevs */
TABLE useropts;		/* table for user options */
BTREE BTR = NULL;	/* database */
STRING editstr, editfile;
STRING llarchives, llreports, llprograms;
STRING getenv();

/*=================================
 * init_lifelines -- Open LifeLines
 *===============================*/
init_lifelines ()
{
	STRING e, emsg;
	char scratch[100];
	tagtable = create_table();
	placabbvs = create_table();
	useropts = create_table();
	init_valtab_from_rec("VPLAC", placabbvs, ':', &emsg);
	init_valtab_from_rec("VUOPT", useropts, '=', &emsg);
	init_caches();
	init_browse_lists();
	init_mapping();
	e = getenv("LLEDITOR");
	if (!e || *e == 0) e = getenv("ED");
	if (!e || *e == 0) e = getenv("EDITOR");
	if (!e || *e == 0) e = "vi";
	sprintf(scratch, ".%dltmp", getpid());
	editfile = strsave(scratch);
	editstr = (STRING) stdalloc(strlen(e) + strlen(editfile) + 2);
	sprintf(editstr, "%s %s", e, editfile);
	llprograms = getenv("LLPROGRAMS");
	if (!llprograms || *llprograms == 0) llprograms = ".";
	llreports = getenv("LLREPORTS");
	if (!llreports || *llreports == 0) llreports = ".";
	llarchives = getenv("LLARCHIVES");
	if (!llarchives || *llarchives == 0) llarchives = ".";
	openxref();
}
/*===================================
 * close_lifelines -- Close LifeLines
 *=================================*/
close_lifelines ()
{
	char scratch[40];
	closexref();
	sprintf(scratch, "rm -f %s\n", editfile);
	system(scratch);
	closebtree(BTR);
}
