/*=============================================================
 * delete.c -- Removes person and family records from database 
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 15 Aug 93
 *   3.0.0 - 30 Jun 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"

extern STRING idpdel, cfpdel, haslnk;

static del_in_dbase();

/*============================================================
 * delete_indi -- Delete person and with links; if this leaves
 *   families with no links remove them
 *==========================================================*/
delete_indi (indi, conf)
NODE indi;	/* person to remove */
BOOLEAN conf;	/* have user confirm */
{
	STRING key;
	NODE name, sex, body, famc, fams;
	INT isex, keyint;
	NODE node, husb, wife, chil, rest, fam, prev, next;
	BOOLEAN found;
	if (!indi && !(indi = ask_for_indi(idpdel, FALSE, FALSE)))
		return;
	if (conf && !ask_yes_or_no(cfpdel)) return;
	split_indi(indi, &name, &sex, &body, &famc, &fams);
	if (!fams) goto checkfamc;
	isex = val_to_sex(sex);
	ASSERT(isex != SEX_UNKNOWN);
	for (node = fams; node; node = nsibling(node)) {
		fam = key_to_fam(rmvat(nval(node)));
		split_fam(fam, &husb, &wife, &chil, &rest);
		ASSERT(husb || wife || chil);
		if (isex == SEX_MALE) {
			ASSERT(husb && eqstr(nval(husb), nxref(indi)));
			free_nodes(husb);
			husb = NULL;
		} else {
			ASSERT(wife && eqstr(nval(wife), nxref(indi)));
			free_nodes(wife);
			wife = NULL;
		}
		join_fam(fam, husb, wife, chil, rest);
		if (!husb && !wife && !chil)
			delete_fam(fam);
		else
			fam_to_dbase(fam);
	}
checkfamc:
	if (famc) {
		fam = key_to_fam(rmvat(nval(famc)));
		split_fam(fam, &husb, &wife, &chil, &rest);
		ASSERT(husb || wife || chil);
		found = FALSE;
		prev = NULL;
		node = chil;
		while (node) {
			if (!strcmp(nxref(indi), nval(node))) {
				found = TRUE;
				break;
			}
			prev = node;
			node = nsibling(node);
		}
		ASSERT(found);
		next = nsibling(node);
		if (!prev)
			chil = next;
		else
			nsibling(prev) = next;
		nsibling(node) = NULL;
		free_nodes(node);
		join_fam(fam, husb, wife, chil, rest);
		if (!husb && !wife && !chil)
			delete_fam(fam);
		else
			fam_to_dbase(fam);
	}
	key = rmvat(nxref(indi));
	keyint = atoi(key + 1);
	addixref(keyint);
	remove_indi_cache(key);
	for (node = name; node; node = nsibling(node))
		remove_name(nval(node), key);
	remove_from_browse_lists(key);
	del_in_dbase(key);
	join_indi(indi, name, sex, body, famc, fams);
	free_nodes(indi);
}
/*==========================================
 * delete_fam -- Delete family from database
 *========================================*/
delete_fam (fam)
NODE fam;
{
	STRING key;
	NODE husb, wife, chil, rest;
	INT keyint;
	if (!fam) return;
	split_fam(fam, &husb, &wife, &chil, &rest);
	if (husb || wife || chil) {
		message(haslnk);
		join_fam(fam, husb, wife, chil, rest);
		return;
	}
	key = rmvat(nxref(fam));
	keyint = atoi(key + 1);
	addfxref(keyint);
	remove_fam_cache(key);
	del_in_dbase(key);
	join_fam(fam, husb, wife, chil, rest);
	free_nodes(fam);
}
/*=================================================
 * del_in_dbase -- Write deleted record to database
 *===============================================*/
static del_in_dbase (key)
STRING key;
{
	if (!key || *key == 0) return;
	ASSERT(store_record(key, "DELE\n", 5));
}
