/*================================================================
 * write.c -- Handle changes to the database
 * Copyright(c) 1994 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.6 - 01 Jan 94 - created
 *   Version 3.0.0 - 01 Jan 94 - created
 *==============================================================*/

#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "interp.h"

/*============================================
 * _createnode -- Create a GEDCOM node.
 *   usage: createnode(STRING, STRING) -> NODE
 *==========================================*/
WORD _createnode (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	STRING val, tag = (STRING) evaluate(ielist(node), stab, eflg);
	if (*eflg) return NULL;
	val = (STRING) evaluate(inext((INTERP)ielist(node)), stab, eflg);
	if (*eflg) return NULL;
	return (WORD) create_node(NULL, tag, val, NULL);
}
/*===========================================
 * _addnode -- Add a node to a GEDCOM tree.
 *   usage: addnode(NODE, NODE, NODE) -> VOID
 *=========================================*/
WORD _addnode (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	INTERP arg = (INTERP) ielist(node);
	NODE next, prnt, prev;
	NODE this = (NODE) evaluate(arg, stab, eflg);
	if (*eflg || this == NULL) return NULL;
	arg = inext(arg);
	prnt = (NODE) evaluate(arg, stab, eflg);
	if (*eflg || prnt == NULL) return NULL;
	prev = (NODE) evaluate(inext(arg), stab, eflg);
	if (*eflg) return NULL;
	nparent(this) = prnt;
	if (prev == NULL) {
		next = nchild(prnt);
		nchild(prnt) = this;
	} else {
		next = nsibling(prev);
		nsibling(prev) = this;
	}
	nsibling(this) = next;
	return NULL;
}
/*=============================================
 * _deletenode -- Remove node from GEDCOM tree.
 *   usage: deletenode(NODE) -> VOID
 *   NOTE: MEMORY LEAK MEMORY LEAK MEMORY LEAK
 *===========================================*/
WORD _deletenode (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	NODE prnt, prev, curs, next;
	NODE this = (NODE) evaluate(ielist(node), stab, eflg);
	if (*eflg || this == NULL) return NULL;
	if ((prnt = nparent(this)) == NULL) return NULL;
	prev = NULL;
	curs = nchild(prnt);
	while (curs && curs != this) {
		prev = curs;
		curs = nsibling(curs);
	}
	if (curs == NULL) return NULL;
	next = nsibling(this);
	if (prev == NULL) 
		nchild(prnt) = next;
	else
		nsibling(prev) = next;
	return NULL;
}
