/*=============================================================
 * place.c -- Handle place values
 * Copyright(c) 1993-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 30 Aug 93    3.0.0 - 28 Jun 94
 *===========================================================*/

#include "standard.h"

/*===================================================
 * place_to_list -- Convert place string to word list
 *=================================================*/
BOOLEAN place_to_list (place, list, plen)
STRING place;
LIST list;
INT *plen;
{
	return value_to_list(place, list, plen, ",");
}
/*=============================================
 * value_to_list -- Convert string to word list
 *===========================================*/
BOOLEAN value_to_list (str, list, plen, dlm)
STRING str;
LIST list;
INT *plen;
STRING dlm;
{
	static STRING buf = NULL;
	static INT len0 = 0;
	STRING p, q, n;
	INT len, c, i, j;

	if (!str || *str == 0 || !list) return FALSE;
	make_list_empty(list);
	set_list_type(list, LISTDOFREE);
	if ((len = strlen(str)) > len0 - 2) {
		if (buf) stdfree(buf);
		buf = (STRING) stdalloc(len0 = len + 80);
	}
	strcpy(buf, str);
	buf[len + 1] = 0;
	p = buf;
	j = 1;
	while (c = *p++) {
		if (in_string(c, dlm)) {
			*(p - 1) = 0;
			j++;
		}
	}
	p = buf;
	for (i = 1;  i <= j;  i++) {
		n = p + strlen(p) + 1;
		while (chartype(c = *p++) == WHITE)
			;
		p--;
		q = p + strlen(p) - 1;
		while (q > p && chartype(*q) == WHITE)
			*q-- = 0;
		set_list_element(list, i, strsave(p));
		p = n;
	}
	*plen = j;
	return TRUE;
}

BOOLEAN in_string (chr, str)
INT chr;
STRING str;
{
	while (*str && chr != *str)
		str++;
	return *str != 0;
}
