/*=============================================================
 * misc.c -- Various useful, miscellaneous routines
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 02 Sep 93
 *   3.0.0 - 08 May 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"

/*========================================
 * addat -- Add @'s to both ends of string
 *======================================*/
STRING addat (str)
STRING str;
{
	STRING scratch;
	static char buffer[3][20];
	static INT dex = 0;
	if (++dex > 2) dex = 0;
	scratch = buffer[dex];
	sprintf(scratch, "@%s@", str);
	return scratch;
}
/*=============================================
 * rmvat -- Remove @'s from both ends of string
 *===========================================*/
STRING rmvat (str)
STRING str;
{
	STRING scratch;
	static char buffer[3][20];
	static INT dex = 0;
	if (++dex > 2) dex = 0;
	scratch = buffer[dex];
	strcpy(scratch, &str[1]);
	scratch[strlen(scratch)-1] = 0;
	return scratch;
}
/*==============================================
 * find_tag -- Search node list for specific tag
 *============================================*/
NODE find_tag (node, str)
NODE node;  STRING str;
{
	while (node) {
		if (eqstr(str, ntag(node))) return node;
		node = nsibling(node);
	}
	return NULL;
}
/*=================================================
 * val_to_sex -- Convert SEX value to internal form
 *===============================================*/
INT val_to_sex (node)
NODE node;
{
	if (!node || !nval(node)) return SEX_UNKNOWN;
	if (!strcmp("M", nval(node))) return SEX_MALE;
	if (!strcmp("F", nval(node))) return SEX_FEMALE;
	return SEX_UNKNOWN;
}
/*====================================================
 * full_value -- Return value of node, with CONT lines
 *==================================================*/
STRING full_value (node)
NODE node;
{
	NODE cont;
	INT len = 0;
	STRING p, q, str;
	if (!node) return NULL;
	if (p = nval(node)) len += strlen(p) + 1;
	cont = nchild(node);
	while (cont && !strcmp("CONT", ntag(cont))) {
		if (p = nval(cont))
			len += strlen(p) + 1;
		else
			len++;
		cont = nsibling(cont);
	}
	if (len == 0) return NULL;
	str = p = stdalloc(len + 1);
	if (q = nval(node)) {
		sprintf(p, "%s\n", q);
		p += strlen(p);
	}
	cont = nchild(node);
	while (cont && !strcmp("CONT", ntag(cont))) {
		if (q = nval(cont))
			sprintf(p, "%s\n", q);
		else
			sprintf(p, "\n");
		p += strlen(p);
		cont = nsibling(cont);
	}
	*(p - 1) = 0;
	return str;
}
