/*=============================================================
 * gstrings.c -- Routines to creates child strings
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 25 Aug 93
 *   3.0.0 - 02 May 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"

static INT nchil = 0;
static INT maxchil = 0;
static STRING *chstrings = NULL;
static STRING *chkeys = NULL;
/*===================================================================
 * get_child_strings -- Return children strings; each string has name
 *   and event info, if avail  
 *=================================================================*/
STRING *get_child_strings (fam, pnum, pkeys)
NODE fam;
INT *pnum;
STRING **pkeys;
{
	NODE chil;
	INT i;

	for (i = 0; i < nchil; i++) {
		stdfree(chstrings[i]);
		stdfree(chkeys[i]);
	}
	nchil = *pnum = 0;
	if (!fam || !(chil = CHIL(fam))) return NULL;
	nchil = node_list_length(chil);
	if (nchil == 0) return NULL;
	if (nchil > (maxchil - 1)) {
		if (maxchil) {
			stdfree(chstrings); 
			stdfree(chkeys); 
		}
		chstrings = (STRING *) stdalloc((nchil+5)*sizeof(STRING));
		chkeys = (STRING *) stdalloc((nchil+5)*sizeof(STRING));
		maxchil = nchil + 5;
	}
	FORCHILDREN(fam,child,i)
		chstrings[i-1] = indi_to_list_string(child, NULL, 66);
		chkeys[i-1] = strsave(rmvat(nxref(child)));
	ENDCHILDREN
	*pnum = nchil;
	*pkeys = chkeys;
	return chstrings;
}
/*================================================
 * indi_to_list_string -- Return menu list string.
 *==============================================*/
STRING indi_to_list_string (indi, fam, len)
NODE indi, fam;
INT len;
{
	char scratch[MAXLINELEN];
	STRING name, evt = NULL, p = scratch;
	if (indi) {
		ASSERT(name = indi_to_name(indi, len));
	} else
		name = "Spouse unknown";
	sprintf(p, "%s", name);
	p += strlen(p);
	if (fam)  evt = fam_to_event(fam, "MARR", "m. ", len, TRUE);
	if (!evt) evt = indi_to_event(indi, "BIRT", "b. ", len, TRUE);
	if (!evt) evt = indi_to_event(indi, "CHR", "bap. ", len, TRUE);
	if (!evt) evt = indi_to_event(indi, "DEAT", "d. ", len, TRUE);
	if (!evt) evt = indi_to_event(indi, "BURI", "bur. ", len, TRUE);
	if (evt) {
		sprintf(p, ", %s", evt);
		p += strlen(p);
	}
	if (indi && keyflag) {
		sprintf(p, " (%s)", rmvat(nxref(indi))+1);
		p += strlen(p);
	}
	if (fam && keyflag) {
		sprintf(p, " (%s)", rmvat(nxref(fam))+1);
	}
	if (strlen(scratch) > len)
		scratch[len] = 0;
	return strsave(scratch);
}
