/*================================================================
 * tandem.c -- Tandem browsing operations.
 * Copyright(c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 -  1 Sep 93 - modified
 *   Version 2.3.6 -  1 Nov 93 - modified
 *   Version 3.0.0 -  1 Nov 93 - modified
 *================================================================
 */
#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "indiseq.h"

extern STRING nofath, nomoth, nospse, nocofp;
extern STRING twohsb, twowif, idsbrs, idplst, idcbrs;

/*=====================================================
 * browse_tandem -- Handle two person browse operation.
 *===================================================*/
INT browse_tandem (pindi1, pindi2, pfam1, pfam2, pseq)
NODE *pindi1, *pindi2, *pfam1, *pfam2;
INDISEQ *pseq;
{
	NODE node, indi1 = *pindi1, indi2 = *pindi2;
	STRING key, name;
	INDISEQ seq;
	INT c, len, rc;

	if (!indi1 || !indi2) return BROWSE_QUIT;
	while (TRUE) {
		c = tandem_browse(indi1, indi2);
		switch (c) {
		case 'e': 	/* Edit top person */
			indi1 = edit_indi(indi1);
			break;
		case 't': 	/* Browse top person */
			*pindi1 = indi1;
			return BROWSE_INDI;
		case 'f': 	/* Browse top person's father */
			if (!(node = indi_to_fath(indi1)))
				message(nofath);
			else
				indi1 = node;
			break;
		case 'm': 	/* Browse top person's mother */
			if (!(node = indi_to_moth(indi1)))
				message(nomoth);
			else
				indi1 = node;
			break;
		case 's': 	/* Browse top person's spouse/s */
			node = choose_spouse(indi1, nospse, idsbrs);
			if (node) indi1 = node;
			break;
		case 'c': 	/* Browse top person's children */
			if (node = choose_child(indi1, NULL, nocofp,
			    idcbrs, FALSE))
				indi1 = node;
			break;
		case 'j': 	/* Merge two persons */
			if (node = merge_two_indis(indi2, indi1)) {
				*pindi1 = node;
				return BROWSE_INDI;
			}
			break;
		case 'd': 	/* Copy top person to bottom */
			indi2 = indi1;
			break;
		case 'x': 	/* Swap two persons */
			node = indi1;
			indi1 = indi2;
			indi2 = node;
			break;
		case 'a': 	/* Make two persons parents in family */
			node = add_family(indi1, indi2, NULL);
			if (!node)  break;
			*pfam1 = node;
			return BROWSE_FAM;
		case 'b': 	/* Browse to new person list */
			seq = (INDISEQ) ask_for_indiseq(idplst, &rc);
			if (!seq) break;
			if ((len = length_indiseq(seq)) == 1) {
				element_indiseq(seq, 0, &key, &name);
				*pindi1 = key_to_indi(key);
				remove_indiseq(seq, FALSE);
				return BROWSE_INDI;
			}
			*pseq = seq;
			return BROWSE_LIST;
			break;
		case 'q':
			return BROWSE_QUIT;
		default:
			beep();
			continue;
		}
	}
}
/*===================================================
 * browse_2fam -- Handle two family browse operation.
 *=================================================*/
INT browse_2fam (pindi1, pindi2, pfam1, pfam2, pseq)
NODE *pindi1, *pindi2, *pfam1, *pfam2;
INDISEQ *pseq;
{
	NODE node, fam1 = *pfam1, fam2 = *pfam2;
	INT c;
	ASSERT(fam1 && fam2);
	while (TRUE) {
		c = twofam_browse(fam1, fam2);
		switch (c) {
		case 'e':	/* Edit top family */
			fam1 = edit_family(fam1);
			break;
		case 't':	/* Browse top family */
			*pfam1 = fam1;
			return BROWSE_FAM;
		case 'b':	/* Browse bottom family */
			*pfam1 = fam2;
			return BROWSE_FAM;
		case 'h':	/* Browse to husbs/fathers */
			*pindi1 = fam_to_husb(fam1);
			*pindi2 = fam_to_husb(fam2);
			if (!*pindi1 || !*pindi2) {
				message(twohsb);
				break;
			}
			return BROWSE_TAND;
		case 'w':	/* Browse to wives/mothers */
			*pindi1 = fam_to_wife(fam1);
			*pindi2 = fam_to_wife(fam2);
			if (!*pindi1 || !*pindi2) {
				message(twowif);
				break;
			}
			return BROWSE_TAND;
		case 'j':	/* Merge two families */
			if (node = merge_two_fams(fam2, fam1)) {
				*pfam1 = node;
				return BROWSE_FAM;
			}
			break;
		case 'x':	/* Swap two families */
			node = fam1;
			fam1 = fam2;
			fam2 = node;
			break;
		case 'q':	/* Return to main menu */
			return BROWSE_QUIT;
		default:
			beep();
			continue;
		}
	}
}
