/*==================================================================
 * swap.c -- Swaps two children of family or two families of person.
 * Copyright(c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 27 Sep 93 - modified
 *   Version 2.3.6 -  1 Nov 93 - modified
 *   Version 3.0.0 -  1 Nov 93 - modified
 *==================================================================
 */
#include "standard.h"
#include "btree.h"
#include "table.h"
#include "gedcom.h"

extern STRING idcswp, id1csw, id2csw, id1fsw, id2fsw, idfbys;
extern STRING ntprnt, less2c, okcswp, less2f, okfswp, idfswp;

/*==============================================
 * swap_children -- Swap two children in family.
 *============================================*/
BOOLEAN swap_children (prnt, fam)
NODE prnt;	/* parent - poss NULL */
NODE fam;	/* family - poss NULL */
{
	NODE chil1, chil2, chil, one, two, tmp;
	STRING key1, key2, str;
	INT nfam, nchil;

/* Identify parent if need be */
	if (fam) goto gotfam;
	if (!prnt) prnt = ask_for_indi(idfswp, FALSE, FALSE);
	if (!prnt) return FALSE;
	nfam = num_families(prnt);
	if (nfam <= 0) {
		message(ntprnt);
		return FALSE;
	}

/* Identify family if need be */
	if (nfam == 1) {
		fam = key_to_fam(rmvat(nval(FAMS(prnt))));
		goto gotfam;
	}
	if (!(fam = choose_family(prnt, ntprnt, idfbys))) return FALSE;
gotfam:
	nchil = num_children(fam);
	if (nchil < 2) {
		message(less2c);
		return FALSE;
	}

/* Identify two children to swap */
	chil1 = choose_child(NULL, fam, "e", id1csw, FALSE);
	if (!chil1) return FALSE;
	chil2 = choose_child(NULL, fam, "e", id2csw, FALSE);
	if (!chil2) return FALSE;
	if (chil1 == chil2) return FALSE;
	key1 = nxref(chil1);
	key2 = nxref(chil2);

   /* Swap two CHIL nodes and update database */
	ASSERT(chil = CHIL(fam));
	one = two = NULL;
	for (;  chil;  chil = nsibling(chil)) {
		if (!strcmp(key1, nval(chil))) one = chil;
		if (!strcmp(key2, nval(chil))) two = chil;
	}
	ASSERT(one && two);
	str = nval(one);
	nval(one) = nval(two);
	nval(two) = str;
	tmp = nchild(one);
	nchild(one) = nchild(two);
	nchild(two) = tmp;
	fam_to_dbase(fam);
	message(okcswp);
	return TRUE;
}
/*===============================================
 * swap_families -- Swaps two families of person.
 *=============================================*/
BOOLEAN swap_families (indi)
NODE indi;
{
	NODE fam1, fam2, fams, one, two, tmp;
	INT nfam;
	STRING str, key1, key2;

/* Find person and assure has >= 2 families */
	if (!indi) indi = ask_for_indi(idfswp, FALSE, FALSE);
	if (!indi) return FALSE;
	if (!(fams = FAMS(indi))) {
		message(ntprnt);
		return FALSE;
	}
	nfam = num_families(indi);
	if (nfam < 2) {
		message(less2f);
		return FALSE;
	}

/* Find families to swap */
	fam1 = choose_family(indi, "e", id1fsw);
	if (!fam1) return FALSE;
	fam2 = choose_family(indi, "e", id2fsw);
	if (!fam2) return FALSE;
	if (fam1 == fam2) return FALSE;
	key1 = nxref(fam1);
	key2 = nxref(fam2);

/* Swap FAMS nodes and update database */
	ASSERT(fams = FAMS(indi));
	one = two = NULL;
	for (;  fams;  fams = nsibling(fams)) {
		if (!strcmp(key1, nval(fams))) one = fams;
		if (!strcmp(key2, nval(fams))) two = fams;
	}
	ASSERT(one && two);
	str = nval(one);
	nval(one) = nval(two);
	nval(two) = str;
	tmp = nchild(one);
	nchild(one) = nchild(two);
	nchild(two) = tmp;
	indi_to_dbase(indi);
	message(okfswp);
	return TRUE;
}
