/*===================================================================
 * main.c -- This file contains the main program of the LifeLines
 *   genealogical database and report generating system.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 07 Aug 93 - modified
 *   Version 2.3.6 - 01 Jan 94 - modified
 *===================================================================
 */
#include "standard.h"
#include "screen.h"
#include "btree.h"
#include "table.h"
#include "gedcom.h"

extern STRING idldir, nodbse, crdbse, nocrdb, iddbse, usage;

BOOLEAN alloclog = FALSE;	/*turn off allocate/free debugging*/
BOOLEAN keyflag = TRUE;		/*show key values*/
BOOLEAN editindent = TRUE;	/*show GEDCOM records with indentation*/
BOOLEAN resnames = FALSE; 	/* show names when restoring */
BOOLEAN alldone = FALSE;
STRING btreepath, readpath;
STRING version = "2.3.6";
extern int opterr;
extern BTREE BTR;
STRING lldatabases, getenv();
STRING filepath();

/*===================================
 * main -- Main routine of LifeLines.
 *=================================*/
main (argc, argv)
INT argc;
STRING *argv;
{
	extern STRING optarg;
	extern int optind;
	int c;

	initscr();
	noecho();
	cbreak();
	init_smanager();
	set_signals();
	curs_set(0);

	opterr = 0;	/* turn off getopt's error message */
	while ((c = getopt(argc, argv, "aiknV")) != -1) {
		switch (c) {
		case 'a':	/* debug allocation */
			alloclog = TRUE;
			break;
		case 'i':	/* edit indentation */
			editindent = TRUE;
			break;
		case 'k':	/* don't show key values */
			keyflag = FALSE;
			break;
		case 'n':	/* show names when restoring */
			resnames = TRUE;
			break;
		case 'V':	/* show the version */
	wprintf("LifeLines -- Lineage-linked Database System\n");
	wprintf("  Version %s\n", version);
	wprintf("  Copyright(c) 1991, 1992, 1993, 1994 by Thomas T. Wetmore IV\n");
	wprintf("  For more information contact:\n");
	wprintf("      Thomas T. Wetmore IV\n");
	wprintf("      2 Barton Street\n");
	wprintf("      Newburyport, MA  01950\n");
			endwin();
			exit(1);
		case '?':
			wprintf(usage);
			endwin();
			exit(1);
		}
	}
	c = argc - optind;
			
	if (c > 1) {
		wprintf(usage);
		endwin();
		exit(1);
	}
	if (c <= 0) {
		btreepath = (STRING) ask_for_string(idldir, "enter path:");
		if (!btreepath || *btreepath == 0) {
			wprintf(iddbse);
			endwin();
			exit(1);
		}
		btreepath = strsave(btreepath);
	} else
		btreepath = argv[optind];
	if (!btreepath || *btreepath == 0) {
		wprintf(usage);
		endwin();
		exit(1);
	}
	mvwprintw(main_window, 3, 4, "Current Database - %s", btreepath);
	lldatabases = getenv("LLDATABASES");
	if (!lldatabases || *lldatabases == 0) lldatabases = ".";
	readpath = filepath(btreepath, "r", lldatabases);
	if (readpath) {
		if (!(BTR = openbtree("", readpath, FALSE)) &&
		    !trytocreate(readpath)) {
			endwin();
			exit(1);
		}
	} else if (!(BTR = openbtree("", btreepath, FALSE)) &&
	    !trytocreate(btreepath)) {
		endwin();
		exit(1);
	}
	gedinit();
	while (!alldone)
		main_menu();
	gedclose();
	endwin();
	exit(0);
}
/*=============================================
 * trytocreate -- Try to create a new database.
 *===========================================*/
BOOLEAN trytocreate (path)
STRING path;
{
	if (!ask_yes_or_no_msg(nodbse, crdbse)) return FALSE;
	if (!(BTR = openbtree("", path, TRUE))) {
		message(nocrdb, path);
		return FALSE;
	}
	gedinitdbase();
	return TRUE;
}
/*=======================================
 * gedinitdbase -- Initialize a database.
 *=====================================*/
gedinitdbase ()
{
	initxref();
}

user_fatal_calls ()
{
	show_all_stats();
}

show_all_stats ()
{
	cache_stats();
}
