/*================================================================
 * edit.c -- Edit person or family record.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 01 Sep 93 - modified
 *================================================================
 */
#include <stdio.h>
#include "standard.h"
#include "btree.h"
#include "table.h"
#include "gedcom.h"

extern STRING iredit, fredit, cfpupt, cffupt, idpedt, idspse, idfbys;
extern STRING ntprnt;

/*======================================
 * edit_indi -- Edit person in database.
 *====================================*/
NODE edit_indi (indi1)
NODE indi1;
{
	NODE name1, sex1, body1, famc1, fams1;
	NODE name2, sex2, body2, indi2, old, new, node;
	INT isex;
	FILE *fp;
	BOOLEAN emp;
	STRING msg, key;

	if (!indi1 && !(indi1 = ask_for_indi(idpedt, FALSE, FALSE)))
		return NULL;
	split_indi(indi1, &name1, &sex1, &body1, &famc1, &fams1);
	isex = val_to_sex(sex1);
	if (!fams1) isex = SEX_UNKNOWN;

/* Prepare file for user to edit */
	ASSERT(fp = fopen(editfile, "w"));
	write_nodes(0, fp, indi1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, name1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, sex1,  TRUE, TRUE, TRUE);
	write_nodes(1, fp, body1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, famc1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, fams1, TRUE, TRUE, TRUE);
	fclose(fp);

/* Have user edit file */
	endwin();
	system(editstr);
	while (TRUE) {
		indi2 = file_to_node(editfile, &msg, &emp);
		if (!indi2) {
			if (ask_yes_or_no_msg(msg, iredit)) {
				endwin();
				system(editstr);
				continue;
			} 
			break;
		}
		if (!valid_indi_tree(indi2, &msg, isex, indi1, famc1, fams1)) {
			if (ask_yes_or_no_msg(msg, iredit)) {
				endwin();
				system(editstr);
				continue;
			}
			free_nodes(indi2);
			indi2 = NULL;
			break;
		}
		break;
	}

/* Editing done; see if database changes */
	join_indi(indi1, name1, sex1, body1, famc1, fams1);
	if (!indi2) return indi1;
	if (equal_tree(indi1, indi2) || !ask_yes_or_no(cfpupt)) {
		free_nodes(indi2);
		return indi1;
	}

/* Change database */
	split_indi(indi1, &name1, &sex1, &body1, &famc1, &fams1);
	free_nodes(sex1);
	free_nodes(body1);
	free_nodes(famc1);
	free_nodes(fams1);
	old = name1;
	split_indi(indi2, &name2, &sex2, &body2, &famc1, &fams1);
	free_nodes(indi2);
	new = copy_nodes(name2, TRUE, TRUE);
	join_indi(indi1, name2, sex2, body2, famc1, fams1);
	remove_duplicate_names(&old, &new);

/* Write changed person to database */
	indi_to_dbase(indi1);
	key = rmvat(nxref(indi1));
	for (node = old; node; node = nsibling(node))
		remove_name(nval(node), key);
	rename_from_browse_lists(key);
	for (node = new; node; node = nsibling(node))
		add_name(nval(node), key);
	free_nodes(old);
	free_nodes(new);
	return indi1;
}
/*=====================================
 * edit_fam -- Edit family in database.
 *===================================*/
NODE edit_family (fam1)
NODE fam1;
{
	NODE indi, husb1, wife1, chil1, rest1;
	NODE fam2, husb2, wife2, chil2, rest2;
	INT i;
	STRING msg;
	FILE *fp;
	BOOLEAN emp;

/* Identify family if need be */
	if (!fam1) {
		indi = ask_for_indi(idspse, FALSE, FALSE);
		if (!indi) return NULL;
		if (!FAMS(indi)) {
			message(ntprnt);
			return NULL;
		}
		fam1 = choose_family(indi, "e", idfbys);
		if (!fam1) return FALSE;
	}

/* Have user edit record */
	split_fam(fam1, &husb1, &wife1, &chil1, &rest1);
	ASSERT(fp = fopen(editfile, "w"));
	write_nodes(0, fp, fam1,  TRUE, TRUE, TRUE);
	write_nodes(1, fp, husb1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, wife1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, rest1, TRUE, TRUE, TRUE);
	write_nodes(1, fp, chil1, TRUE, TRUE, TRUE);
	fclose(fp);

	endwin();
	system(editstr);
	while (TRUE) {
		fam2 = file_to_node(editfile, &msg, &emp);
		if (!fam2) {
			if (ask_yes_or_no_msg(msg, fredit)) {
				endwin();
				system(editstr);
				continue;
			}
			break;
		}
		if (!valid_fam_tree(fam2, &msg, fam1, husb1, wife1, chil1)) {
			if (ask_yes_or_no_msg(msg, fredit)) {
				endwin();
				system(editstr);
				continue;
			}
			free_nodes(fam2);
			fam2 = NULL;
			break;
		}
		break;
	}

/* If error or user backs out return */
	join_fam(fam1, husb1, wife1, chil1, rest1);
	if (!fam2) return fam1;
	if (equal_tree(fam1, fam2) || !ask_yes_or_no(cffupt)) {
		free_nodes(fam2);
		return fam1;
	}

/* Change database */
	split_fam(fam1, &husb1, &wife1, &chil1, &rest1);
	free_nodes(husb1);
	free_nodes(wife1);
	free_nodes(chil1);
	free_nodes(rest1);
	split_fam(fam2, &husb2, &wife2, &chil2, &rest2);
	free_nodes(fam2);
	join_fam(fam1, husb2, wife2, chil2, rest2);
	fam_to_dbase(fam1);
	return fam1;
}
/*=============================================================
 * remove_duplicate_names -- Remove duplicate names from index.
 *===========================================================*/
remove_duplicate_names (pone, ptwo)
NODE *pone, *ptwo;
{
	NODE copy;
	remove_duplicates(pone);
	remove_duplicates(ptwo);
	copy = copy_nodes(*ptwo, TRUE, TRUE);
	remove_one_way(pone, ptwo);
	remove_one_way(&copy, pone);
	free_nodes(copy);
}
/*=================================================================
 * remove_one_way -- Remove names in second list that are in first.
 *===============================================================*/
remove_one_way (pone, ptwo)
NODE *pone, *ptwo;
{
	NODE one = *pone, two = *ptwo;
	NODE this1, this2, prev1, prev2, next;
	prev1 = NULL;  this1 = one;
	while (this1) {
		prev2 = NULL;  this2 = two;
		while (this2) {
			if (!strcmp(nval(this1), nval(this2))) {
				next = nsibling(this2);
				if (prev2)
					nsibling(prev2) = next;
				else
					two = next;
				nsibling(this2) = NULL;
				free_nodes(this2);
				this2 = next;
			} else {
				prev2 = this2;
				this2 = nsibling(this2);
			}
		}
		prev1 = this1;
		this1 = nsibling(this1);
	}
	*ptwo = two;
}
/*===========================================================
 * remove_duplicates -- Remove duplicates from list of names.
 *   NOTE: this does not take into account lower level lines.
 *=========================================================*/
remove_duplicates (pnames)
NODE *pnames;
{
	NODE base, prev, this, next;
	base = *pnames;
	while (base) {
		prev = base;
		this = nsibling(base);
		while (this) {
			if (!strcmp(nval(base), nval(this))) {
				nsibling(prev) = next = nsibling(this);
				nsibling(this) = NULL;
				free_nodes(this);
				this = next;
			} else {
				prev = this;
				this = nsibling(this);
			}
		}
		base = nsibling(base);
	}
}
/*============================================
 * equal_tree -- Check if two trees are equal.
 *==========================================*/
BOOLEAN equal_tree (root1, root2)
NODE root1, root2;
{
	STRING str1, str2;
	if (!root1 && !root2) return TRUE;
	if (!root1 || !root2) return FALSE;
	if (node_list_length(root1) != node_list_length(root2)) return FALSE;
	while (root1) {
		if (strcmp(ntag(root1), ntag(root2))) return FALSE;
		str1 = nval(root1);
		str2 = nval(root2);
		if (str1 && !str2) return FALSE;
		if (str2 && !str1) return FALSE;
		if (str1 && str2 && strcmp(str1, str2)) return FALSE;
		if (!equal_tree(nchild(root1), nchild(root2))) return FALSE;
		root1 = nsibling(root1);
		root2 = nsibling(root2);
	}
	return TRUE;
}
/*============================================
 * equal_node -- Check if two nodes are equal.
 *==========================================*/
BOOLEAN equal_node (node1, node2)
NODE node1, node2;
{
	STRING str1, str2;
	if (!node1 && !node2) return TRUE;
	if (!node1 || !node2) return FALSE;
	if (strcmp(ntag(node1), ntag(node2))) return FALSE;
	str1 = nval(node1);
	str2 = nval(node2);
	if (str1 && !str2) return FALSE;
	if (str2 && !str1) return FALSE;
	if (str1 && str2 && strcmp(str1, str2)) return FALSE;
	return TRUE;
}
