/*================================================================
 * btree.h -- BTREE package header.
 * Copyright(c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 19 Aug 93 - modified
 *================================================================
 */
#include <stdio.h>

#define BUFLEN 1024
#define NOENTS ((BUFLEN-12)/12)
#define NORECS ((BUFLEN-12)/16)

typedef struct {
	char r_rkey[8];
}  RKEY; /*record key*/

typedef INT FKEY; /*file key*/

typedef WORD RECORD;

typedef struct {
	FKEY k_mkey;	/*current master key*/
	FKEY k_fkey;	/*current file key*/
} KEYFILE;
/*===============================================
 * INDEX -- Data structure for BTREE index files.
 *=============================================*/
typedef struct {
	FKEY  i_self;		/*fkey of this index*/
	SHORT i_type;           /*block/file type*/
	FKEY  i_parent;         /*parent file's fkey*/
	SHORT i_nkeys;          /*num of keys in index*/
	RKEY  i_rkeys[NOENTS];  /*rkeys in index*/
	FKEY  i_fkeys[NOENTS];  /*fkeys in index*/
} *INDEX, INDEXSTRUCT;
/*========================================
 * BTREE -- Internal BTREE data structure.
 *======================================*/
typedef struct {
	STRING  b_name;	        /*btree name*/
	STRING  b_basedir;	/*btree base directory*/
	INDEX   b_master;	/*master index block*/
	FKEY    b_nkey;		/*next index key*/
	FILE   *b_kfp;		/*keyfile file pointer*/
	KEYFILE b_kfile;	/*keyfile contents*/
	INT     b_ncache;	/*number of indices in cache*/
	INDEX  *b_cache;	/*index cache*/
} *BTREE, BTREESTRUCT;
#define bname(b)    ((b)->b_name)
#define bbasedir(b) ((b)->b_basedir)
#define bmaster(b)  ((b)->b_master)
#define bnkey(b)    ((b)->b_nkey)
#define bkfp(b)     ((b)->b_kfp)
#define bkfile(b)   ((b)->b_kfile)
#define bncache(b)  ((b)->b_ncache)
#define bcache(b)   ((b)->b_cache)
/*========================================================
 * BLOCK -- Ddata structure for BTREE record file headers.
 *======================================================*/
typedef struct {
	FKEY   i_self;		/*fkey of this block*/
	SHORT  i_type;		/*block/file type*/
	FKEY   i_parent;	/*parent file's fkey*/
	SHORT  i_nkeys;		/*num of keys in block*/
	RKEY   i_rkeys[NORECS];	/*rkeys in block/file*/
	INT    i_offs[NORECS];	/*offsets for data in file*/
	INT    i_lens[NORECS];	/*lenghts for data in file*/
} *BLOCK, BLOCKSTRUCT;
/*=============================================
 * Macros for selecting INDEX and BLOCK fields.
 *===========================================*/
#define iself(p)    ((p)->i_self)
#define itype(p)    ((p)->i_type)
#define iparent(p)  ((p)->i_parent)
#define nkeys(p)   ((p)->i_nkeys)
#define rkeys(p,i) ((p)->i_rkeys[i])
#define fkeys(p,i) ((p)->i_fkeys[i])
#define offs(p,i)  ((p)->i_offs[i])
#define lens(p,i)  ((p)->i_lens[i])
/*==========================================
 * Declarations for BTREE library functions.
 *========================================*/
extern INDEX  getindex();
extern INDEX  readindex();
extern INDEX  crtindex();
extern STRING fkey2path();
extern STRING rkey2str();
extern FKEY   path2fkey();
extern RKEY   str2rkey();
extern BTREE  openbtree();
extern BLOCK  crtblock();
extern RECORD getrecord();
extern BLOCK  allocblock();

extern INT bterrno;

#define BTERRNOMEM    1 /*no memory for some allocation*/
#define BTERRNOBTRE   2
#define BTERROPNIDX   3 /*can't open an index*/
#define BTERRNOKFL    4	/*there is no key file*/
#define BTERRRDKFL    5
#define BTERROPNKFL   6	/*can't open key file*/
#define BTERRCRTMST   7
#define BTERRWRTKFL   8	/*can't write key file*/
#define BTERRWRTMST   9
#define BTERRLNGDIR  10	/*base directory name too long*/
#define BTERROPNDAT  11 /*can't open a data block*/

#define BTINDEXTYPE 1
#define BTBLOCKTYPE 2

#define BTFLGCRT (1<<0)

