/*================================================================
 * table.c -- Hash table abstraction.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 29 Aug 93 - modified
 *================================================================
 */
#include "standard.h"
#include "table.h"

static ENTRY fndentry();
static INT hash();
/*==============================
 * create_table -- Create table.
 *============================*/
TABLE create_table ()
{
	TABLE tab = (TABLE) stdalloc(MAXHASH*sizeof(ENTRY));
	INT i;
	for (i = 0; i < MAXHASH; i++)
		tab[i] = NULL;
	return tab;
}
/*=======================================
 * insert_table -- Insert entry in table.
 *=====================================*/
insert_table (tab, key, val)
TABLE tab;
KEY key;
VALUE val;
{
	ENTRY entry = fndentry (tab, key);
	if (entry)
		entry->evalue = val;
	else {
		INT hval = hash(key);
		entry = (ENTRY) stdalloc(sizeof(*entry));
		entry->ekey = key;
		entry->evalue = val;
		entry->enext = tab[hval];
		tab[hval] = entry;
	}
}
/*===========================================
 * delete_table -- Remove element from table.
 *=========================================*/
delete_table (tab, key)
TABLE tab;  KEY key;
{
	INT hval = hash(key);
	ENTRY prev = NULL;
	ENTRY this = tab[hval];
	while (this && keycmp(key, this->ekey)) {
		prev = this;
		this = this->enext;
	}
	if (!this) return;
	if (prev)
		prev->enext = this->enext;
	else
		tab[hval] = this->enext;
	stdfree(this);
}
/*=======================================
 * in_table() - Check for entry in table.
 *=====================================*/
BOOLEAN in_table (tab, key)
TABLE tab;
KEY key;
{
	return fndentry(tab, key) != NULL;
}
/*================================
 * valueof -- Find value of entry.
 *==============================*/
VALUE valueof (tab, key)
TABLE tab;
KEY key;
{
	ENTRY entry;
	if (!key) return NULL;
	if (entry = fndentry(tab, key))
		return entry->evalue;
	else
		return NULL;
}
/*====================================
 * valueofbool -- Find value of entry.
 *==================================*/
VALUE valueofbool (tab, key, there)
TABLE tab;
KEY key;
BOOLEAN *there;
{
	ENTRY entry;
	*there = FALSE;
	if (!key) return NULL;
	if (entry = fndentry(tab, key)) {
		*there = TRUE;
		return entry->evalue;
	}
	return NULL;
}
/*=======================
 * hash -- Hash function.
 *=====================*/
static INT hash (key)
KEY key; /* assumed string */
{
	INT hval = 0;
	while (*key)
		hval += *key++;
	return hval %= MAXHASH;
}
/*=================================
 * fndentry -- Find entry in table.
 *===============================*/
static ENTRY fndentry (tab, key)
TABLE tab;
KEY key;
{
	ENTRY entry = tab[hash(key)];
	while (entry) {
		if (!keycmp(key, entry->ekey)) return entry;
		entry = entry->enext;
	}
	return NULL;
}
/*==============================
 * remove_table -- Remove table.
 *============================*/
remove_table (tab, eproc)
TABLE tab;
INT (*eproc)();
{
	INT i;
	ENTRY ent, nxt;
	if (!tab) return;
	for (i = 0; i < MAXHASH; i++) {
		nxt = tab[i];
		while (ent = nxt) {
			nxt = ent->enext;
			if (eproc != NULL) (*eproc)(ent);
			stdfree(ent);
		}
	}
	stdfree(tab);
}
