/*================================================================
 * interface.c -- Interface between NODEs and the BTREE database.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 18 Aug 93 - modified
 *================================================================
 */
#include "standard.h"
#include "btree.h"

extern BTREE BTR;

/*==================================================
 * retrieve_record -- Retrieve record from database.
 *================================================*/
STRING retrieve_record (key, plen)
STRING key;
INT *plen;
{
	return getrecord(BTR, str2rkey(key), plen);
}
/*==========================================
 * store_record -- Store record in database.
 *========================================*/
BOOLEAN store_record (key, rec, len)
STRING key, rec;
INT len;
{
	return addrecord (BTR, str2rkey(key), rec, len);
}
/*==========================================
 * retrieve_file -- Retrieve record to file.
 *========================================*/
BOOLEAN retrieve_file (key, file)
STRING key, file;
{
	return getfile(BTR, str2rkey(key), file);
}
/*======================================
 * store_file -- Store record from file.
 *====================================*/
BOOLEAN store_file (key, file)
STRING key, file;
{
	return addfile(BTR, str2rkey(key), file);
}
