/*===============================================================
 * init.c -- Initialize LifeLines data structures.
 * Copyright(c) 1991 by T. Trask Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled 
 *   Version 2.3.5 - 29 Aug 93 - modified
 *===============================================================
 */
#include "standard.h"
#include "btree.h"
#include "table.h"
#include "gedcom.h"

TABLE placabbvs;	/* table for place abbrevs */
TABLE tagtable;		/* table for tag strings */
BTREE BTR = NULL;
BOOLEAN inited = FALSE;
STRING editstr, editfile;
STRING llarchives, llreports, llprograms;
STRING getenv();

/*=================================
 * gedinit -- Initialize LifeLines.
 *===============================*/
gedinit ()
{
	STRING e;
	char scratch[100];
	placabbvs = create_table();
	tagtable = create_table();
	init_abbvtab_from_rec("VPLAC", placabbvs);
	init_caches();
	init_browse_lists();
	e = getenv("ED");
	if (!e || *e == 0) e = getenv("EDITOR");
	if (!e || *e == 0) e = "vi";
	sprintf(scratch, ".%dltmp", getpid());
	editfile = strsave(scratch);
	editstr = (STRING) stdalloc(strlen(e) + strlen(editfile) + 2);
	sprintf(editstr, "%s %s", e, editfile);
	llprograms = getenv("LLPROGRAMS");
	if (!llprograms || *llprograms == 0) llprograms = ".";
	llreports = getenv("LLREPORTS");
	if (!llreports || *llreports == 0) llreports = ".";
	llarchives = getenv("LLARCHIVES");
	if (!llarchives || *llarchives == 0) llarchives = ".";
	openxref();
	inited = TRUE;
}
/*================================
 * gedclose -- Finalize LifeLines.
 *==============================*/
gedclose ()
{
	char scratch[40];
	closexref();
	sprintf(scratch, "rm -f %s\n", editfile);
	system(scratch);
}
