/*==================================================================
 * block.c -- This file contains the low level code for dealing with
 *   BLOCKs.
 * Copyright(c) 1991 by Thomas Trask Wetmore IV; all rights reserved.
 * Version 2.3.4 - controlled 24 June 1993
 *==================================================================
 */
#include "standard.h"
#include "btree.h"
/*================================================
 * allocblock -- Allocates the memory for a BLOCK.
 *==============================================*/
BLOCK allocblock ()
{
	BLOCK block = (BLOCK) stdalloc(BUFLEN);
	itype(block) = BTBLOCKTYPE;
	iself(block) = 0;
	iparent(block) = 0;
	nkeys(block) = 0;
	return block;
}
/*============================================
 * crtblock -- Create a new BLOCK for a BTREE.
 *==========================================*/
BLOCK crtblock (btree)
BTREE btree;  /*btree handle*/
{
	BLOCK block = allocblock();
	iself(block) = btree->b_kfile.k_fkey;
	nextfkey(btree);
	rewind(bkfp(btree));
	if (fwrite(&bkfile(btree), sizeof(KEYFILE), 1, bkfp(btree)) != 1)
		FATAL();
	return block;
}
